/*
 * Decompiled with CFR 0.152.
 */
package net.dries007.tfc.client.particle;

import net.dries007.tfc.common.blocks.RiverWaterBlock;
import net.dries007.tfc.world.river.Flow;
import net.minecraft.client.multiplayer.ClientLevel;
import net.minecraft.client.particle.Particle;
import net.minecraft.client.particle.ParticleProvider;
import net.minecraft.client.particle.ParticleRenderType;
import net.minecraft.client.particle.SpriteSet;
import net.minecraft.client.particle.TextureSheetParticle;
import net.minecraft.core.BlockPos;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.core.particles.SimpleParticleType;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.material.FluidState;
import net.minecraft.world.phys.Vec3;

public class WaterFlowParticle
extends TextureSheetParticle {
    private final float particleRandom;

    public WaterFlowParticle(ClientLevel level, double x, double y, double z) {
        super(level, x, y, z);
        this.setSize(0.02f, 0.02f);
        this.quadSize *= this.random.nextFloat() * 0.6f + 0.2f;
        BlockPos pos = BlockPos.containing((double)x, (double)y, (double)z);
        FluidState state = level.getFluidState(pos);
        this.setDirectionFromFlow(state);
        this.lifetime = 80 + this.random.nextInt(20);
        this.particleRandom = this.random.nextFloat() - 0.5f;
    }

    private void setDirectionFromFlow(FluidState state) {
        if (state.hasProperty(RiverWaterBlock.FLOW)) {
            Flow flow = (Flow)((Object)state.getValue(RiverWaterBlock.FLOW));
            Vec3 vec = flow.getVector();
            this.xd = vec.x * 0.18 + this.xd * 0.02;
            this.zd = vec.z * 0.18 + this.zd * 0.02;
            this.oRoll = this.roll;
            this.roll = (float)((double)this.roll + (double)this.particleRandom * 0.01);
        } else {
            this.xd *= 0.98;
            this.zd *= 0.98;
        }
    }

    public void tick() {
        this.xo = this.x;
        this.yo = this.y;
        this.zo = this.z;
        BlockPos pos = BlockPos.containing((double)this.x, (double)this.y, (double)this.z);
        FluidState state = this.level.getFluidState(pos);
        this.yo = this.y = (double)((float)pos.getY() + state.getHeight((BlockGetter)this.level, pos) + this.particleRandom * 0.05f);
        this.setDirectionFromFlow(state);
        if (!state.hasProperty(RiverWaterBlock.FLOW) || !this.level.getBlockState(pos.above()).isAir()) {
            this.lifetime = Math.min(this.lifetime, 10);
        }
        if (this.lifetime-- <= 0) {
            this.remove();
            this.level.addParticle((ParticleOptions)ParticleTypes.BUBBLE_POP, this.x, this.y, this.z, 0.0, 0.0, 0.0);
        } else {
            this.move(this.xd, this.yd, this.zd);
        }
    }

    public ParticleRenderType getRenderType() {
        return ParticleRenderType.PARTICLE_SHEET_OPAQUE;
    }

    public record Provider(SpriteSet sprite) implements ParticleProvider<SimpleParticleType>
    {
        public Particle createParticle(SimpleParticleType type, ClientLevel level, double x, double y, double z, double xSpeed, double ySpeed, double zSpeed) {
            WaterFlowParticle particle = new WaterFlowParticle(level, x, y, z);
            particle.pickSprite(this.sprite);
            return particle;
        }
    }
}

