/*
 * Decompiled with CFR 0.152.
 */
package net.dries007.tfc.client.particle;

import net.dries007.tfc.client.ClimateRenderCache;
import net.minecraft.client.multiplayer.ClientLevel;
import net.minecraft.client.particle.Particle;
import net.minecraft.client.particle.ParticleProvider;
import net.minecraft.client.particle.ParticleRenderType;
import net.minecraft.client.particle.SpriteSet;
import net.minecraft.client.particle.TextureSheetParticle;
import net.minecraft.core.particles.SimpleParticleType;
import net.minecraft.util.Mth;
import net.minecraft.world.phys.Vec2;

public class WindParticle
extends TextureSheetParticle {
    private final float xBias;
    private final float zBias;
    private final float amplitude;

    public WindParticle(ClientLevel level, double x, double y, double z) {
        super(level, x, y, z);
        Vec2 wind = ClimateRenderCache.INSTANCE.getWind();
        this.lifetime = 100;
        this.age = this.random.nextInt(20);
        this.amplitude = this.random.nextFloat() * 0.034f;
        float speed = 0.4f * (wind.length() * 0.2f + 0.9f) + this.amplitude;
        this.xBias = wind.x * speed * 2.0f;
        this.zBias = wind.y * speed * 2.0f;
        this.scale(this.random.nextFloat() * 0.4f + 0.1f);
    }

    public void tick() {
        super.tick();
        this.yd = this.onGround ? (double)0.09f : Mth.lerp((double)this.yd, (double)(Mth.sin((float)((float)this.age * 0.05f)) * this.amplitude), (double)0.1f);
        this.xd = this.xBias;
        this.zd = this.zBias;
    }

    public ParticleRenderType getRenderType() {
        return ParticleRenderType.PARTICLE_SHEET_OPAQUE;
    }

    public record Provider(SpriteSet sprite) implements ParticleProvider<SimpleParticleType>
    {
        public Particle createParticle(SimpleParticleType type, ClientLevel level, double x, double y, double z, double xSpeed, double ySpeed, double zSpeed) {
            WindParticle particle = new WindParticle(level, x, y, z);
            particle.pickSprite(this.sprite);
            return particle;
        }
    }
}

