/*
 * Decompiled with CFR 0.152.
 */
package net.dries007.tfc.client.render.blockentity;

import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.math.Axis;
import net.dries007.tfc.client.RenderHelpers;
import net.dries007.tfc.common.blockentities.AnvilBlockEntity;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.blockentity.BlockEntityRenderer;
import net.minecraft.client.renderer.entity.ItemRenderer;
import net.minecraft.core.Direction;
import net.minecraft.world.item.ItemDisplayContext;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.Property;

public class AnvilBlockEntityRenderer
implements BlockEntityRenderer<AnvilBlockEntity> {
    public void render(AnvilBlockEntity anvil, float partialTicks, PoseStack poseStack, MultiBufferSource buffer, int combinedLight, int combinedOverlay) {
        ItemStack catalyst;
        if (anvil.getLevel() == null) {
            return;
        }
        BlockState state = anvil.getLevel().getBlockState(anvil.getBlockPos());
        int rotation = state.hasProperty((Property)BlockStateProperties.HORIZONTAL_FACING) ? ((Direction)state.getValue((Property)BlockStateProperties.HORIZONTAL_FACING)).get2DDataValue() : 0;
        float yOffset = anvil.getTier() == 0 ? 0.875f : 0.6875f;
        poseStack.pushPose();
        poseStack.translate(0.5, 0.003125 + (double)yOffset, 0.5);
        poseStack.scale(0.3f, 0.3f, 0.3f);
        poseStack.mulPose(Axis.XP.rotationDegrees(90.0f));
        poseStack.mulPose(Axis.ZP.rotationDegrees(90.0f * (float)rotation + 270.0f));
        poseStack.translate(1.2f, 0.0f, 0.0f);
        ItemRenderer itemRenderer = Minecraft.getInstance().getItemRenderer();
        AnvilBlockEntity.AnvilInventory inventory = (AnvilBlockEntity.AnvilInventory)anvil.getInventory();
        ItemStack hammer = inventory.getStackInSlot(2);
        if (!hammer.isEmpty()) {
            itemRenderer.renderStatic(hammer, ItemDisplayContext.FIXED, combinedLight, combinedOverlay, poseStack, buffer, anvil.getLevel(), 0);
        }
        poseStack.translate(-1.3f, 0.0f, 0.0f);
        ItemStack input1 = inventory.getStackInSlot(0);
        if (!input1.isEmpty()) {
            itemRenderer.renderStatic(input1, ItemDisplayContext.FIXED, RenderHelpers.getHeatedBrightness(input1, combinedLight), combinedOverlay, poseStack, buffer, anvil.getLevel(), 0);
        }
        poseStack.translate(-0.4f, 0.0f, -0.05f);
        ItemStack input2 = inventory.getStackInSlot(1);
        if (!input2.isEmpty()) {
            itemRenderer.renderStatic(input2, ItemDisplayContext.FIXED, RenderHelpers.getHeatedBrightness(input2, combinedLight), combinedOverlay, poseStack, buffer, anvil.getLevel(), 0);
        }
        if (!(catalyst = inventory.getStackInSlot(3)).isEmpty()) {
            poseStack.pushPose();
            poseStack.translate(0.9f, -0.25f, 0.05f);
            poseStack.scale(0.6f, 0.6f, 0.6f);
            itemRenderer.renderStatic(catalyst, ItemDisplayContext.FIXED, combinedLight, combinedOverlay, poseStack, buffer, anvil.getLevel(), 0);
            poseStack.popPose();
        }
        poseStack.popPose();
    }
}

