/*
 * Decompiled with CFR 0.152.
 */
package net.dries007.tfc.client.render.blockentity;

import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.math.Axis;
import net.dries007.tfc.client.RenderHelpers;
import net.dries007.tfc.common.blockentities.BarrelBlockEntity;
import net.dries007.tfc.common.blocks.devices.BarrelBlock;
import net.dries007.tfc.config.TFCConfig;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.blockentity.BlockEntityRenderer;
import net.minecraft.core.Direction;
import net.minecraft.world.item.ItemDisplayContext;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;
import net.neoforged.neoforge.fluids.FluidStack;

public class BarrelBlockEntityRenderer
implements BlockEntityRenderer<BarrelBlockEntity> {
    public void render(BarrelBlockEntity barrel, float partialTicks, PoseStack poseStack, MultiBufferSource buffer, int combinedLight, int combinedOverlay) {
        ItemStack itemStack;
        BlockState state = barrel.getBlockState();
        if (((Boolean)state.getValue((Property)BarrelBlock.SEALED)).booleanValue() || state.getValue(BarrelBlock.FACING) != Direction.UP) {
            return;
        }
        BarrelBlockEntity.BarrelInventory inventory = (BarrelBlockEntity.BarrelInventory)barrel.getInventory();
        FluidStack fluidStack = inventory.getFluidInTank(0);
        if (!fluidStack.isEmpty()) {
            float fillPercent = (float)fluidStack.getAmount() / (float)TFCConfig.SERVER.barrelCapacity.get().intValue();
            float subtract = (double)fillPercent > 0.03 ? 0.0f : (0.03f - fillPercent) * 7.0f;
            RenderHelpers.renderFluidFace(poseStack, fluidStack, buffer, 0.1875f + subtract, 0.1875f + subtract, 0.8125f - subtract, 0.8125f - subtract, 0.140625f + 0.734375f * fillPercent, combinedOverlay, combinedLight);
        }
        if (!(itemStack = inventory.getStackInSlot(2)).isEmpty()) {
            poseStack.pushPose();
            poseStack.translate(0.5f, 0.15625f, 0.5f);
            poseStack.scale(0.5f, 0.5f, 0.5f);
            poseStack.mulPose(Axis.XP.rotationDegrees(90.0f));
            Minecraft.getInstance().getItemRenderer().renderStatic(itemStack, ItemDisplayContext.FIXED, combinedLight, combinedOverlay, poseStack, buffer, barrel.getLevel(), 0);
            poseStack.popPose();
        }
    }
}

