/*
 * Decompiled with CFR 0.152.
 */
package net.dries007.tfc.client.render.blockentity;

import com.mojang.blaze3d.vertex.PoseStack;
import java.util.Map;
import net.dries007.tfc.client.RenderHelpers;
import net.dries007.tfc.common.blockentities.BowlBlockEntity;
import net.dries007.tfc.common.items.TFCItems;
import net.dries007.tfc.util.Helpers;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.blockentity.BlockEntityRenderer;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.Mth;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.neoforged.neoforge.items.ItemStackHandler;

public class BowlBlockEntityRenderer
implements BlockEntityRenderer<BowlBlockEntity> {
    private static final ResourceLocation FALLBACK = Helpers.identifier("block/powder/salt");
    private static final Map<Item, ResourceLocation> TEXTURES = RenderHelpers.mapOf(map -> {
        TFCItems.POWDERS.forEach((type, item) -> map.accept(item, item.getId().withPrefix("block/")));
        TFCItems.ORE_POWDERS.forEach((type, item) -> map.accept(item, item.getId().withPrefix("block/")));
        map.accept(() -> Items.REDSTONE, Helpers.identifier("block/powder/redstone"));
        map.accept(() -> Items.GLOWSTONE_DUST, Helpers.identifier("block/powder/glowstone"));
        map.accept(() -> Items.BLAZE_POWDER, Helpers.identifier("block/powder/blaze_powder"));
        map.accept(() -> Items.GUNPOWDER, Helpers.identifier("block/powder/gunpowder"));
    });

    public static synchronized void addPowderTexture(Item item, ResourceLocation texLoc) {
        TEXTURES.put(item, texLoc);
    }

    public void render(BowlBlockEntity bowl, float partialTicks, PoseStack poseStack, MultiBufferSource buffer, int combinedLight, int combinedOverlay) {
        ItemStack item = ((ItemStackHandler)bowl.getInventory()).getStackInSlot(0);
        if (item.isEmpty()) {
            return;
        }
        ResourceLocation texture = TEXTURES.getOrDefault(item.getItem(), FALLBACK);
        float y = Mth.map((float)item.getCount(), (float)0.0f, (float)16.0f, (float)0.5f, (float)2.0f);
        RenderHelpers.renderTexturedFace(poseStack, buffer, 0xFFFFFF, 0.125f, 0.125f, 0.875f, 0.875f, y / 16.0f, combinedOverlay, combinedLight, texture);
    }
}

