/*
 * Decompiled with CFR 0.152.
 */
package net.dries007.tfc.client.render.blockentity;

import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.math.Axis;
import net.dries007.tfc.client.RenderHelpers;
import net.dries007.tfc.client.model.entity.CalendarClockModel;
import net.dries007.tfc.common.blockentities.CalendarClockBlockEntity;
import net.dries007.tfc.common.blocks.TFCBlockStateProperties;
import net.dries007.tfc.util.Helpers;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.client.renderer.blockentity.BlockEntityRenderer;
import net.minecraft.client.renderer.blockentity.BlockEntityRendererProvider;
import net.minecraft.core.Direction;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.Property;

public class CalendarClockBlockEntityRenderer
implements BlockEntityRenderer<CalendarClockBlockEntity> {
    public static final ResourceLocation TEXTURE = Helpers.identifier("textures/entity/calendar_clock.png");
    public static final ResourceLocation TEXTURE_MONTH = Helpers.identifier("textures/entity/calendar_clock_month.png");
    private final CalendarClockModel model;

    public CalendarClockBlockEntityRenderer(BlockEntityRendererProvider.Context context) {
        this.model = new CalendarClockModel(context.bakeLayer(RenderHelpers.layerId("calendar_clock")));
    }

    public void render(CalendarClockBlockEntity clock, float partialTick, PoseStack stack, MultiBufferSource buffer, int packedLight, int packedOverlay) {
        if (clock.getLevel() == null) {
            return;
        }
        stack.pushPose();
        stack.translate(0.5f, -0.0f, 0.5f);
        stack.translate(0.0f, 1.5f, 0.0f);
        stack.scale(-1.0f, -1.0f, 1.0f);
        switch ((Direction)clock.getBlockState().getValue((Property)BlockStateProperties.FACING)) {
            case NORTH: {
                stack.translate(0.0f, 1.0f, -1.0f);
                stack.mulPose(Axis.XP.rotationDegrees(90.0f));
                break;
            }
            case SOUTH: {
                stack.translate(0.0f, 1.0f, 1.0f);
                stack.mulPose(Axis.XN.rotationDegrees(90.0f));
                stack.mulPose(Axis.YN.rotationDegrees(180.0f));
                break;
            }
            case EAST: {
                stack.translate(-1.0f, 1.0f, 0.0f);
                stack.mulPose(Axis.ZN.rotationDegrees(90.0f));
                stack.mulPose(Axis.YP.rotationDegrees(90.0f));
                break;
            }
            case WEST: {
                stack.translate(1.0f, 1.0f, 0.0f);
                stack.mulPose(Axis.ZP.rotationDegrees(90.0f));
                stack.mulPose(Axis.YN.rotationDegrees(90.0f));
                break;
            }
            case DOWN: {
                stack.translate(0.0f, 2.0f, 0.0f);
                stack.mulPose(Axis.ZP.rotationDegrees(180.0f));
            }
        }
        this.model.setupAnim(clock, partialTick);
        if (((Boolean)clock.getBlockState().getValue((Property)TFCBlockStateProperties.CLOCK_MONTH_MODE)).booleanValue()) {
            this.model.renderToBuffer(stack, buffer.getBuffer(RenderType.entityCutoutNoCull((ResourceLocation)TEXTURE_MONTH)), packedLight, packedOverlay, -1);
        } else {
            this.model.renderToBuffer(stack, buffer.getBuffer(RenderType.entityCutoutNoCull((ResourceLocation)TEXTURE)), packedLight, packedOverlay, -1);
        }
        stack.popPose();
    }
}

