/*
 * Decompiled with CFR 0.152.
 */
package net.dries007.tfc.client.render.blockentity;

import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.VertexConsumer;
import java.util.function.Function;
import net.dries007.tfc.client.RenderHelpers;
import net.dries007.tfc.common.blockentities.HotPouredGlassBlockEntity;
import net.dries007.tfc.util.Helpers;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.client.renderer.blockentity.BlockEntityRenderer;
import net.minecraft.client.renderer.texture.TextureAtlasSprite;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.Mth;

public class HotPouredGlassBlockEntityRenderer
implements BlockEntityRenderer<HotPouredGlassBlockEntity> {
    private static final ResourceLocation VERY_VERY_HOT = Helpers.identifier("block/glass/3");
    private static final ResourceLocation HOT = Helpers.identifier("block/glass/1");

    public void render(HotPouredGlassBlockEntity glass, float partialTicks, PoseStack poseStack, MultiBufferSource buffers, int combinedLight, int combinedOverlay) {
        float ticks = (40.0f - (float)glass.getAnimationTicks()) / 40.0f;
        Function textureAtlas = Minecraft.getInstance().getTextureAtlas(RenderHelpers.BLOCKS_ATLAS);
        VertexConsumer buffer = buffers.getBuffer(RenderType.cutout());
        if (glass.isInitialTransition()) {
            TextureAtlasSprite sprite = (TextureAtlasSprite)textureAtlas.apply(VERY_VERY_HOT);
            float hLerp = Mth.lerp((float)(!glass.isInitialized() ? 0.0f : ticks), (float)4.0f, (float)0.0f) / 16.0f;
            float yLerp = Mth.lerp((float)(!glass.isInitialized() ? 0.0f : ticks), (float)8.0f, (float)1.0f) / 16.0f;
            RenderHelpers.renderTexturedCuboid(poseStack, buffer, sprite, combinedLight, combinedOverlay, hLerp, 0.0f, hLerp, 1.0f - hLerp, yLerp, 1.0f - hLerp);
        } else if (ticks > 0.0f) {
            TextureAtlasSprite sprite = (TextureAtlasSprite)textureAtlas.apply(HOT);
            RenderHelpers.renderTexturedCuboid(poseStack, buffer, sprite, combinedLight, combinedOverlay, 0.0f, 0.0f, 0.0f, 1.0f, Mth.lerp((float)ticks, (float)0.025f, (float)0.0625f), 1.0f);
        }
    }
}

