/*
 * Decompiled with CFR 0.152.
 */
package net.dries007.tfc.client.render.blockentity;

import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.VertexConsumer;
import java.util.HashMap;
import java.util.IdentityHashMap;
import java.util.Map;
import java.util.Optional;
import net.dries007.tfc.TerraFirmaCraft;
import net.dries007.tfc.client.RenderHelpers;
import net.dries007.tfc.common.TFCTags;
import net.dries007.tfc.common.blockentities.MoldBlockEntity;
import net.dries007.tfc.common.component.TFCComponents;
import net.dries007.tfc.common.component.fluid.FluidComponent;
import net.dries007.tfc.common.component.mold.IMold;
import net.dries007.tfc.common.items.TFCItems;
import net.dries007.tfc.common.recipes.CastingRecipe;
import net.dries007.tfc.common.recipes.HeatingRecipe;
import net.dries007.tfc.util.MetalItem;
import net.dries007.tfc.util.collections.IndirectHashCollection;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.client.renderer.blockentity.BlockEntityRenderer;
import net.minecraft.client.renderer.texture.TextureAtlasSprite;
import net.minecraft.client.resources.model.BakedModel;
import net.minecraft.client.resources.model.ModelResourceLocation;
import net.minecraft.core.Direction;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.RecipeManager;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.material.Fluid;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.Vec3;
import net.neoforged.neoforge.client.extensions.common.IClientFluidTypeExtensions;
import net.neoforged.neoforge.fluids.FluidStack;
import net.neoforged.neoforge.fluids.FluidType;

public class MoldBlockEntityRenderer
implements BlockEntityRenderer<MoldBlockEntity> {
    private static final Map<Fluid, MetalItem> FLUID_TO_METAL_ITEM = new HashMap<Fluid, MetalItem>();
    private static final MoldModelCache MOLD_MODEL_CACHE = IndirectHashCollection.create(new MoldModelCache(new IdentityHashMap<Item, BakedModel>()));

    public void render(MoldBlockEntity mold, float partialTicks, PoseStack poseStack, MultiBufferSource buffer, int combinedLight, int combinedOverlay) {
        ItemStack moldStack;
        IMold moldItem;
        VertexConsumer builder = buffer.getBuffer(RenderType.cutout());
        if (mold.hasSource()) {
            ResourceLocation texture = IClientFluidTypeExtensions.of((FluidType)mold.getSourceFluid().getFluidType()).getStillTexture();
            int color = RenderHelpers.getFluidColor(mold.getSourceFluid());
            TextureAtlasSprite sprite = (TextureAtlasSprite)Minecraft.getInstance().getTextureAtlas(RenderHelpers.BLOCKS_ATLAS).apply(texture);
            RenderHelpers.renderChannelFlow(poseStack, builder, sprite, color, combinedLight, combinedOverlay, mold.getFlowSource(), true);
            if (mold.getFlowSource().getLeft() == Direction.UP) {
                RenderHelpers.renderChannelFlowCenter(poseStack, builder, sprite, color, combinedLight, combinedOverlay);
            }
        }
        if ((moldItem = IMold.get(moldStack = mold.getMoldStack())) != null) {
            FluidStack fluidInTank = moldItem.getFluidInTank(0);
            MetalItem solidMetal = MetalItem.unknown();
            float fillPercent = 0.0f;
            boolean shouldRenderSolid = false;
            if (!mold.getOutputStack().isEmpty()) {
                fillPercent = 1.0f;
                shouldRenderSolid = true;
                HeatingRecipe recipe = HeatingRecipe.getRecipe(mold.getOutputStack());
                if (recipe != null) {
                    solidMetal = MoldBlockEntityRenderer.getMetalItemFromFluidStack(recipe.getDisplayOutputFluid());
                }
            } else if (fluidInTank.getAmount() > 0) {
                fillPercent = (float)fluidInTank.getAmount() / (float)moldItem.getTankCapacity(0);
                if (moldItem.isMolten()) {
                    shouldRenderSolid = false;
                } else {
                    shouldRenderSolid = true;
                    solidMetal = MoldBlockEntityRenderer.getMetalItemFromFluidStack(fluidInTank);
                }
            }
            if (fillPercent > 0.0f) {
                if (shouldRenderSolid) {
                    TextureAtlasSprite metalSprite = RenderHelpers.blockTexture(solidMetal.softTextureId());
                    RenderHelpers.renderTexturedQuads(poseStack, builder, metalSprite, combinedLight, combinedOverlay, RenderHelpers.getYVertices(0.125f, 0.0625f, 0.125f, 0.875f, (1.0f + fillPercent * 0.95f) / 16.0f, 0.875f), 12.0f, 12.0f, 0.0f, 1.0f, 0.0f, true);
                } else {
                    RenderHelpers.renderFluidFace(poseStack, fluidInTank, buffer, 0.125f, 0.125f, 0.875f, 0.875f, (1.0f + fillPercent * 0.95f) / 16.0f, combinedOverlay, combinedLight);
                }
            }
            poseStack.pushPose();
            Optional.ofNullable(MoldBlockEntityRenderer.MOLD_MODEL_CACHE.values.get(moldStack.getItem())).ifPresent(model -> Minecraft.getInstance().getItemRenderer().renderModelLists(model, ItemStack.EMPTY, combinedLight, combinedOverlay, poseStack, builder));
            poseStack.popPose();
        }
    }

    public AABB getRenderBoundingBox(MoldBlockEntity mold) {
        if (mold.hasSource()) {
            Vec3 worldPosition = mold.getBlockPos().getCenter();
            if (mold.getFlowSource().getLeft() == Direction.UP) {
                return new AABB(worldPosition.add(-1.5, -0.5, -1.5), worldPosition.add(1.5, (double)(1 + (Byte)mold.getFlowSource().getRight()), 1.5));
            }
            return new AABB(worldPosition.add(-1.5, -0.5, -1.5), worldPosition.add(1.5, 1.5, 1.5));
        }
        return new AABB(mold.getBlockPos());
    }

    private static MetalItem getMetalItemFromFluidStack(FluidStack fluidStack) {
        return FLUID_TO_METAL_ITEM.computeIfAbsent(fluidStack.getFluid(), fluid -> {
            ItemStack ingotMold = new ItemStack((ItemLike)TFCItems.FIRE_INGOT_MOLD);
            ingotMold.set(TFCComponents.FLUID, (Object)new FluidComponent(new FluidStack(fluid, 9999)));
            CastingRecipe castingRecipe = CastingRecipe.get(IMold.get(ingotMold));
            if (castingRecipe == null) {
                return MetalItem.unknown();
            }
            ItemStack hopefullyIngot = castingRecipe.getResultItem();
            return MetalItem.getOrUnknown(hopefullyIngot);
        });
    }

    record MoldModelCache(Map<Item, BakedModel> values) implements IndirectHashCollection.Cache
    {
        @Override
        public void clear() {
            this.values.clear();
        }

        @Override
        public void reload(RecipeManager manager) {
            BuiltInRegistries.ITEM.getTagOrEmpty(TFCTags.Items.USABLE_IN_MOLD_TABLE).forEach(item -> {
                ResourceLocation moldLocation = BuiltInRegistries.ITEM.getKey((Object)((Item)item.value()));
                ModelResourceLocation modelLocation = RenderHelpers.modelId(ResourceLocation.fromNamespaceAndPath((String)moldLocation.getNamespace(), (String)("block/mold/" + moldLocation.getPath())));
                BakedModel model = Minecraft.getInstance().getModelManager().getModel(modelLocation);
                if (model != null && model != Minecraft.getInstance().getModelManager().getMissingModel()) {
                    this.values.put((Item)item.value(), model);
                } else {
                    TerraFirmaCraft.LOGGER.error("No mold model loaded for mold item {}", (Object)moldLocation);
                }
            });
        }
    }
}

