/*
 * Decompiled with CFR 0.152.
 */
package net.dries007.tfc.client.render.blockentity;

import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.VertexConsumer;
import com.mojang.math.Axis;
import java.util.Map;
import net.dries007.tfc.client.RenderHelpers;
import net.dries007.tfc.common.blockentities.InventoryBlockEntity;
import net.dries007.tfc.common.blockentities.PlacedItemBlockEntity;
import net.dries007.tfc.common.items.TFCItems;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.client.renderer.block.ModelBlockRenderer;
import net.minecraft.client.renderer.blockentity.BlockEntityRenderer;
import net.minecraft.client.resources.model.BakedModel;
import net.minecraft.client.resources.model.ModelResourceLocation;
import net.minecraft.util.RandomSource;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemDisplayContext;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.BlockAndTintGetter;
import net.neoforged.neoforge.client.model.data.ModelData;
import net.neoforged.neoforge.items.ItemStackHandler;
import org.jetbrains.annotations.Nullable;

public class PlacedItemBlockEntityRenderer<T extends PlacedItemBlockEntity>
implements BlockEntityRenderer<T> {
    public static final Map<Item, Provider> MODELS = RenderHelpers.mapOf(map -> {
        map.accept(TFCItems.WROUGHT_IRON_GRILL, PlacedItemBlockEntityRenderer.cutout("block/firepit_grill"));
        map.accept(TFCItems.POT, PlacedItemBlockEntityRenderer.cutout("block/firepit_pot_placed"));
        map.accept(TFCItems.UNFIRED_POT, PlacedItemBlockEntityRenderer.cutout("block/firepit_pot_placed_unfired"));
        map.accept(TFCItems.JUG, PlacedItemBlockEntityRenderer.cutout("block/ceramic/jug"));
        map.accept(TFCItems.UNFIRED_JUG, PlacedItemBlockEntityRenderer.cutout("block/ceramic/unfired_jug"));
        map.accept(TFCItems.VESSEL, PlacedItemBlockEntityRenderer.cutout("block/ceramic/small_vessel"));
        map.accept(TFCItems.UNFIRED_VESSEL, PlacedItemBlockEntityRenderer.cutout("block/ceramic/small_vessel_unfired"));
        TFCItems.GLAZED_VESSELS.forEach((color, item) -> map.accept(item, PlacedItemBlockEntityRenderer.cutout("block/ceramic/small_vessel/" + color.getSerializedName() + "/small_vessel")));
        TFCItems.UNFIRED_GLAZED_VESSELS.forEach((color, item) -> map.accept(item, PlacedItemBlockEntityRenderer.cutout("block/ceramic/small_vessel/" + color.getSerializedName() + "/small_vessel_unfired")));
        map.accept(TFCItems.EMPTY_JAR, PlacedItemBlockEntityRenderer.translucent("block/jar/empty"));
        map.accept(TFCItems.EMPTY_JAR_WITH_LID, PlacedItemBlockEntityRenderer.translucent("block/jar"));
        TFCItems.FRUIT_PRESERVES.forEach((fruit, item) -> map.accept(item, PlacedItemBlockEntityRenderer.translucent("block/jar/" + fruit.getSerializedName())));
        TFCItems.UNSEALED_FRUIT_PRESERVES.forEach((fruit, item) -> map.accept(item, PlacedItemBlockEntityRenderer.translucent("block/jar/" + fruit.getSerializedName() + "_unsealed")));
    });

    private static Provider translucent(String model) {
        return new Provider(RenderHelpers.modelId(model), RenderType.translucent());
    }

    private static Provider cutout(String model) {
        return new Provider(RenderHelpers.modelId(model), RenderType.cutout());
    }

    public void render(T placedItem, float partialTicks, PoseStack pose, MultiBufferSource buffers, int packedLight, int packedOverlay) {
        if (!placedItem.hasLevel()) {
            return;
        }
        ItemStackHandler inventory = (ItemStackHandler)((InventoryBlockEntity)placedItem).getInventory();
        RandomSource random = RandomSource.create();
        if (((PlacedItemBlockEntity)placedItem).holdingLargeItem()) {
            this.renderContent(placedItem, pose, buffers, packedLight, packedOverlay, random, 0);
        } else {
            for (int slot = 0; slot < inventory.getSlots(); ++slot) {
                this.renderContent(placedItem, pose, buffers, packedLight, packedOverlay, random, slot);
            }
        }
    }

    private void renderContent(T entity, PoseStack pose, MultiBufferSource buffers, int packedLight, int packedOverlay, RandomSource random, int slot) {
        assert (entity.getLevel() != null);
        ItemStack stack = ((ItemStackHandler)((InventoryBlockEntity)entity).getInventory()).getStackInSlot(slot);
        if (stack.isEmpty()) {
            return;
        }
        boolean isLarge = ((PlacedItemBlockEntity)entity).holdingLargeItem();
        Minecraft mc = Minecraft.getInstance();
        @Nullable Provider custom = MODELS.get(stack.getItem());
        boolean slotX = slot % 2 == 0;
        boolean slotZ = slot < 2;
        pose.pushPose();
        if (custom != null) {
            BakedModel baked = mc.getModelManager().getModel(custom.model);
            VertexConsumer buffer = buffers.getBuffer(custom.renderType);
            ModelBlockRenderer blockRenderer = mc.getBlockRenderer().getModelRenderer();
            if (!isLarge) {
                pose.translate((double)slotX * 0.5, 0.0, (double)slotZ * 0.5);
            }
            pose.translate(0.0, -1.0E-4, 0.0);
            blockRenderer.tesselateWithAO((BlockAndTintGetter)entity.getLevel(), baked, entity.getBlockState(), entity.getBlockPos(), pose, buffer, true, random, (long)packedLight, packedOverlay, ModelData.EMPTY, RenderType.translucent());
        } else {
            BakedModel model = mc.getItemRenderer().getModel(stack, entity.getLevel(), null, 0);
            if (isLarge) {
                pose.translate(0.5, model.isGui3d() ? 0.25 : 0.03125, 0.5);
            } else {
                pose.translate(0.25 + (double)slotX * 0.5, model.isGui3d() ? 0.125 : 0.03125, 0.25 + (double)slotZ * 0.5);
                pose.scale(0.5f, 0.5f, 0.5f);
            }
            if (model.isGui3d()) {
                pose.mulPose(Axis.YP.rotationDegrees(((PlacedItemBlockEntity)entity).getRotations(slot)));
            } else {
                pose.mulPose(Axis.XP.rotationDegrees(90.0f));
                pose.mulPose(Axis.ZP.rotationDegrees(((PlacedItemBlockEntity)entity).getRotations(slot)));
            }
            mc.getItemRenderer().render(stack, ItemDisplayContext.FIXED, false, pose, buffers, packedLight, packedOverlay, model);
        }
        pose.popPose();
    }

    public int getViewDistance() {
        return 24;
    }

    public record Provider(ModelResourceLocation model, RenderType renderType) {
    }
}

