/*
 * Decompiled with CFR 0.152.
 */
package net.dries007.tfc.client.render.blockentity;

import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.math.Axis;
import net.dries007.tfc.client.RenderHelpers;
import net.dries007.tfc.client.render.blockentity.FirepitBlockEntityRenderer;
import net.dries007.tfc.common.blockentities.PotBlockEntity;
import net.dries007.tfc.common.recipes.outputs.PotOutput;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.world.item.ItemDisplayContext;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.material.Fluid;
import net.minecraft.world.level.material.Fluids;
import net.neoforged.neoforge.fluids.FluidStack;

public class PotBlockEntityRenderer
extends FirepitBlockEntityRenderer<PotBlockEntity> {
    @Override
    public void render(PotBlockEntity pot, float partialTicks, PoseStack poseStack, MultiBufferSource buffer, int combinedLight, int combinedOverlay) {
        super.render(pot, partialTicks, poseStack, buffer, combinedLight, combinedOverlay);
        if (pot.getLevel() == null) {
            return;
        }
        PotOutput output = pot.getOutput();
        if (output != null && output.getRenderTexture() != null) {
            RenderHelpers.renderTexturedFace(poseStack, buffer, 0xFFFFFF, 0.3125f, 0.3125f, 0.6875f, 0.6875f, output.getFluidYLevel(), combinedOverlay, combinedLight, output.getRenderTexture());
        } else {
            boolean useDefaultFluid = output != null && output.getFluidColor() != -1;
            FluidStack fluidStack = ((PotBlockEntity.PotInventory)pot.getInventory()).getFluidInTank(0);
            if (fluidStack.isEmpty() && useDefaultFluid) {
                fluidStack = new FluidStack((Fluid)Fluids.WATER, 1000);
            }
            if (!fluidStack.isEmpty()) {
                int color = useDefaultFluid ? output.getFluidColor() : RenderHelpers.getFluidColor(fluidStack);
                RenderHelpers.renderFluidFace(poseStack, fluidStack, buffer, color, 0.3125f, 0.3125f, 0.6875f, 0.6875f, output == null ? 0.625f : output.getFluidYLevel(), combinedOverlay, combinedLight);
            }
        }
        int ordinal = 0;
        for (int slot = 4; slot <= 8; ++slot) {
            ItemStack item = ((PotBlockEntity.PotInventory)pot.getInventory()).getStackInSlot(slot);
            if (item.isEmpty()) continue;
            float yOffset = 0.46f;
            poseStack.pushPose();
            poseStack.translate(0.5, 0.003125 + (double)yOffset, 0.5);
            poseStack.scale(0.3f, 0.3f, 0.3f);
            poseStack.mulPose(Axis.XP.rotationDegrees(90.0f));
            poseStack.mulPose(Axis.ZP.rotationDegrees(180.0f));
            poseStack.translate(0.0f, 0.0f, -0.12f * (float)(++ordinal));
            Minecraft.getInstance().getItemRenderer().renderStatic(item, ItemDisplayContext.FIXED, combinedLight, combinedOverlay, poseStack, buffer, pot.getLevel(), 0);
            poseStack.popPose();
        }
    }
}

