/*
 * Decompiled with CFR 0.152.
 */
package net.dries007.tfc.client.render.blockentity;

import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.VertexConsumer;
import com.mojang.math.Axis;
import net.dries007.tfc.client.RenderHelpers;
import net.dries007.tfc.common.blockentities.QuernBlockEntity;
import net.dries007.tfc.common.blocks.rotation.ConnectedAxleBlock;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.client.renderer.blockentity.BlockEntityRenderer;
import net.minecraft.client.renderer.texture.TextureAtlasSprite;
import net.minecraft.world.item.ItemDisplayContext;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.neoforged.neoforge.items.ItemStackHandler;

public class QuernBlockEntityRenderer
implements BlockEntityRenderer<QuernBlockEntity> {
    public void render(QuernBlockEntity quern, float partialTicks, PoseStack stack, MultiBufferSource bufferSource, int packedLight, int packedOverlay) {
        Block degrees2;
        Level level = quern.getLevel();
        if (level == null) {
            return;
        }
        ItemStack input = ((ItemStackHandler)quern.getInventory()).getStackInSlot(1);
        ItemStack output = ((ItemStackHandler)quern.getInventory()).getStackInSlot(2);
        ItemStack handstone = ((ItemStackHandler)quern.getInventory()).getStackInSlot(0);
        if (!output.isEmpty()) {
            for (int i = 0; i < output.getCount(); ++i) {
                double yPos = 0.625;
                stack.pushPose();
                switch (Math.floorDiv(i, 16)) {
                    case 0: {
                        stack.translate(0.125, yPos, 0.125 + 0.046875 * (double)i);
                        stack.mulPose(Axis.XP.rotationDegrees(75.0f));
                        break;
                    }
                    case 1: {
                        stack.translate(0.125 + 0.046875 * (double)(i - 16), yPos, 0.875);
                        stack.mulPose(Axis.YP.rotationDegrees(90.0f));
                        stack.mulPose(Axis.XP.rotationDegrees(75.0f));
                        break;
                    }
                    case 2: {
                        stack.translate(0.875, yPos, 0.875 - 0.046875 * (double)(i - 32));
                        stack.mulPose(Axis.YP.rotationDegrees(180.0f));
                        stack.mulPose(Axis.XP.rotationDegrees(75.0f));
                        break;
                    }
                    case 3: {
                        stack.translate(0.875 - 0.046875 * (double)(i - 48), yPos, 0.125);
                        stack.mulPose(Axis.YP.rotationDegrees(270.0f));
                        stack.mulPose(Axis.XP.rotationDegrees(75.0f));
                        break;
                    }
                    default: {
                        stack.translate(0.5, 1.0, 0.5);
                        float degrees2 = ((float)level.getGameTime() + partialTicks) * 4.0f;
                        stack.mulPose(Axis.YP.rotationDegrees(degrees2));
                    }
                }
                stack.scale(0.125f, 0.125f, 0.125f);
                Minecraft.getInstance().getItemRenderer().renderStatic(output, ItemDisplayContext.FIXED, packedLight, packedOverlay, stack, bufferSource, quern.getLevel(), 0);
                stack.popPose();
            }
        }
        boolean isConnectedToNetwork = quern.isConnectedToNetwork();
        float rotationAngle = quern.getRotationAngle(partialTicks);
        if (isConnectedToNetwork && (degrees2 = level.getBlockState(quern.getBlockPos().above()).getBlock()) instanceof ConnectedAxleBlock) {
            ConnectedAxleBlock axleBlock = (ConnectedAxleBlock)degrees2;
            VertexConsumer buffer = bufferSource.getBuffer(RenderType.cutout());
            TextureAtlasSprite sprite = RenderHelpers.blockTexture(axleBlock.getAxleTextureLocation());
            stack.pushPose();
            stack.translate(0.5f, 0.5f, 0.5f);
            stack.mulPose(Axis.XN.rotationDegrees(90.0f));
            stack.mulPose(Axis.ZN.rotation(rotationAngle));
            stack.translate(-0.5f, -0.5f, -0.5f);
            RenderHelpers.renderTexturedCuboid(stack, buffer, sprite, packedLight, packedOverlay, 0.375f, 0.375f, 0.5f, 0.625f, 0.625f, 1.0f, false);
            stack.popPose();
        }
        if (!handstone.isEmpty()) {
            float center = !isConnectedToNetwork ? 0.498f + level.random.nextFloat() * 0.004f : 0.5f;
            stack.pushPose();
            stack.translate((double)center, 0.705, (double)center);
            stack.mulPose(Axis.YN.rotation(rotationAngle));
            stack.translate(0.5f - center, 0.0f, 0.5f - center);
            stack.scale(1.25f, 1.25f, 1.25f);
            Minecraft.getInstance().getItemRenderer().renderStatic(handstone, ItemDisplayContext.FIXED, packedLight, packedOverlay, stack, bufferSource, quern.getLevel(), 0);
            stack.popPose();
        }
        if (!input.isEmpty()) {
            float height = handstone.isEmpty() ? 0.75f : 0.875f;
            stack.pushPose();
            stack.translate(0.5f, height, 0.5f);
            if (quern.isConnectedToNetwork()) {
                stack.mulPose(Axis.ZP.rotationDegrees(90.0f));
                stack.scale(0.8f, 0.8f, 0.8f);
            } else {
                stack.mulPose(Axis.YP.rotationDegrees(45.0f));
                stack.scale(0.5f, 0.5f, 0.5f);
            }
            Minecraft.getInstance().getItemRenderer().renderStatic(input, ItemDisplayContext.FIXED, packedLight, packedOverlay, stack, bufferSource, quern.getLevel(), 0);
            stack.popPose();
        }
    }
}

