/*
 * Decompiled with CFR 0.152.
 */
package net.dries007.tfc.client.render.blockentity;

import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.VertexConsumer;
import com.mojang.math.Axis;
import net.dries007.tfc.client.RenderHelpers;
import net.dries007.tfc.client.TFCColors;
import net.dries007.tfc.common.TFCTags;
import net.dries007.tfc.common.blockentities.SluiceBlockEntity;
import net.dries007.tfc.common.blocks.devices.SluiceBlock;
import net.dries007.tfc.util.Helpers;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.client.renderer.blockentity.BlockEntityRenderer;
import net.minecraft.client.renderer.entity.ItemRenderer;
import net.minecraft.client.renderer.texture.TextureAtlasSprite;
import net.minecraft.core.Direction;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.Mth;
import net.minecraft.world.item.ItemDisplayContext;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.material.Fluid;
import net.neoforged.neoforge.client.extensions.common.IClientFluidTypeExtensions;
import net.neoforged.neoforge.fluids.FluidType;
import net.neoforged.neoforge.items.ItemStackHandler;
import org.jetbrains.annotations.Nullable;
import org.joml.Matrix4f;

public class SluiceBlockEntityRenderer
implements BlockEntityRenderer<SluiceBlockEntity> {
    private static void drawItem(ItemStack stack, float x, float y, float z, float rotation, ItemRenderer renderer, PoseStack poseStack, int combinedLight, int combinedOverlay, MultiBufferSource buffer, @Nullable Level level) {
        poseStack.pushPose();
        poseStack.translate(x, y, z);
        poseStack.scale(0.3f, 0.3f, 0.3f);
        poseStack.mulPose(Axis.YP.rotationDegrees(rotation));
        renderer.renderStatic(stack, ItemDisplayContext.FIXED, combinedLight, combinedOverlay, poseStack, buffer, level, 0);
        poseStack.popPose();
    }

    private static void vertex(QuadRenderInfo info, float x, float y, float z, int color, float u, float v) {
        info.buffer.addVertex(info.pose, x, y, z).setColor(color).setUv(u, v).setOverlay(info.packedOverlay).setLight(info.packedLight).setNormal(0.0f, 0.0f, 1.0f);
    }

    public void render(SluiceBlockEntity sluice, float partialTicks, PoseStack poseStack, MultiBufferSource buffers, int packedLight, int packedOverlay) {
        if (sluice.getLevel() == null) {
            return;
        }
        BlockState state = sluice.getBlockState();
        if (!((Boolean)state.getValue((Property)SluiceBlock.UPPER)).booleanValue()) {
            return;
        }
        poseStack.pushPose();
        Direction facing = (Direction)state.getValue((Property)SluiceBlock.FACING);
        if (facing == Direction.NORTH) {
            poseStack.translate(1.0f, 0.0f, 1.0f);
        } else if (facing == Direction.WEST) {
            poseStack.translate(1.0f, 0.0f, 0.0f);
            poseStack.mulPose(Axis.YP.rotationDegrees(180.0f));
        } else if (facing == Direction.EAST) {
            poseStack.translate(0.0f, 0.0f, 1.0f);
            poseStack.mulPose(Axis.YP.rotationDegrees(180.0f));
        }
        poseStack.mulPose(Axis.YP.rotationDegrees((float)((Direction)state.getValue((Property)SluiceBlock.FACING)).get2DDataValue() * 90.0f));
        float rotation = RenderHelpers.itemTimeRotation();
        ItemRenderer itemRenderer = Minecraft.getInstance().getItemRenderer();
        for (int i = 0; i < ((ItemStackHandler)sluice.getInventory()).getSlots(); ++i) {
            ItemStack stack = ((ItemStackHandler)sluice.getInventory()).getStackInSlot(i);
            if (stack.isEmpty()) continue;
            int step = Mth.floor((float)((float)i / 4.0f));
            int across = i % 4;
            float x = 0.125f + 0.25f * (float)across;
            float y = 0.95625f - 0.125f * (float)step;
            float z = 0.14375f + 0.25f * (float)step;
            SluiceBlockEntityRenderer.drawItem(stack, x, y, z, rotation, itemRenderer, poseStack, packedLight, packedOverlay, buffers, sluice.getLevel());
        }
        Fluid fluid = sluice.getFlow();
        if (fluid == null) {
            poseStack.popPose();
            return;
        }
        FluidType attributes = fluid.getFluidType();
        IClientFluidTypeExtensions extension = IClientFluidTypeExtensions.of((FluidType)attributes);
        ResourceLocation texture = extension.getStillTexture();
        TextureAtlasSprite sprite = (TextureAtlasSprite)Minecraft.getInstance().getTextureAtlas(RenderHelpers.BLOCKS_ATLAS).apply(texture);
        int color = Helpers.isFluid(fluid, TFCTags.Fluids.ANY_INFINITE_WATER) ? TFCColors.getWaterColor(sluice.getBlockPos()) : RenderHelpers.getFluidColor(fluid);
        VertexConsumer buffer = buffers.getBuffer(RenderType.entityTranslucentCull((ResourceLocation)RenderHelpers.BLOCKS_ATLAS));
        Matrix4f pose = poseStack.last().pose();
        QuadRenderInfo info = new QuadRenderInfo(buffer, pose, packedOverlay, packedLight);
        SluiceBlockEntityRenderer.vertex(info, 0.05f, 1.033f, 0.0f, color, sprite.getU0(), sprite.getV0());
        SluiceBlockEntityRenderer.vertex(info, 0.05f, -0.15f, 2.45f, color, sprite.getU0(), sprite.getV1());
        SluiceBlockEntityRenderer.vertex(info, 0.95f, -0.15f, 2.45f, color, sprite.getU1(), sprite.getV1());
        SluiceBlockEntityRenderer.vertex(info, 0.95f, 1.033f, 0.0f, color, sprite.getU1(), sprite.getV0());
        SluiceBlockEntityRenderer.vertex(info, 0.05f, 0.833f, 0.0f, color, sprite.getU0(), sprite.getV0());
        SluiceBlockEntityRenderer.vertex(info, 0.05f, -0.3f, 2.45f, color, sprite.getU0(), sprite.getV1());
        SluiceBlockEntityRenderer.vertex(info, 0.95f, -0.3f, 2.45f, color, sprite.getU1(), sprite.getV1());
        SluiceBlockEntityRenderer.vertex(info, 0.95f, 0.833f, 0.0f, color, sprite.getU1(), sprite.getV0());
        SluiceBlockEntityRenderer.vertex(info, 0.05f, -0.15f, 2.45f, color, sprite.getU0(), sprite.getV0());
        SluiceBlockEntityRenderer.vertex(info, 0.05f, 1.033f, 0.0f, color, sprite.getU0(), sprite.getV1());
        SluiceBlockEntityRenderer.vertex(info, 0.05f, 0.833f, 0.0f, color, sprite.getU1(), sprite.getV1());
        SluiceBlockEntityRenderer.vertex(info, 0.05f, -0.3f, 2.45f, color, sprite.getU1(), sprite.getV0());
        SluiceBlockEntityRenderer.vertex(info, 0.95f, 1.033f, 0.0f, color, sprite.getU0(), sprite.getV0());
        SluiceBlockEntityRenderer.vertex(info, 0.95f, -0.15f, 2.45f, color, sprite.getU0(), sprite.getV1());
        SluiceBlockEntityRenderer.vertex(info, 0.95f, -0.3f, 2.45f, color, sprite.getU1(), sprite.getV1());
        SluiceBlockEntityRenderer.vertex(info, 0.95f, 0.833f, 0.0f, color, sprite.getU1(), sprite.getV0());
        poseStack.popPose();
    }

    private record QuadRenderInfo(VertexConsumer buffer, Matrix4f pose, int packedOverlay, int packedLight) {
    }
}

