/*
 * Decompiled with CFR 0.152.
 */
package net.dries007.tfc.client.render.blockentity;

import com.mojang.blaze3d.vertex.PoseStack;
import net.dries007.tfc.common.blockentities.TFCChestBlockEntity;
import net.dries007.tfc.common.blockentities.TFCTrappedChestBlockEntity;
import net.dries007.tfc.common.blocks.wood.TFCChestBlock;
import net.dries007.tfc.util.Helpers;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.Sheets;
import net.minecraft.client.renderer.blockentity.BlockEntityRendererProvider;
import net.minecraft.client.renderer.blockentity.ChestRenderer;
import net.minecraft.client.resources.model.Material;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.properties.ChestType;

public class TFCChestBlockEntityRenderer
extends ChestRenderer<TFCChestBlockEntity> {
    private String wood = "oak";

    private static String getFolder(BlockEntity blockEntity, ChestType type) {
        String prefix = blockEntity instanceof TFCTrappedChestBlockEntity ? "trapped" : "normal";
        return TFCChestBlockEntityRenderer.chooseForType(type, prefix, prefix + "_left", prefix + "_right");
    }

    private static String chooseForType(ChestType type, String single, String left, String right) {
        return switch (type) {
            default -> throw new MatchException(null, null);
            case ChestType.LEFT -> left;
            case ChestType.RIGHT -> right;
            case ChestType.SINGLE -> single;
        };
    }

    public TFCChestBlockEntityRenderer(BlockEntityRendererProvider.Context context) {
        super(context);
    }

    public void render(TFCChestBlockEntity be, float partialTicks, PoseStack poseStack, MultiBufferSource buffer, int combinedLight, int combinedOverlay) {
        Block block = be.getBlockState().getBlock();
        if (block instanceof TFCChestBlock) {
            TFCChestBlock chestBlock = (TFCChestBlock)block;
            this.wood = chestBlock.getTextureLocation();
        }
        super.render((BlockEntity)be, partialTicks, poseStack, buffer, combinedLight, combinedOverlay);
    }

    protected Material getMaterial(TFCChestBlockEntity blockEntity, ChestType chestType) {
        return new Material(Sheets.CHEST_SHEET, Helpers.identifier("entity/chest/" + TFCChestBlockEntityRenderer.getFolder((BlockEntity)blockEntity, chestType) + "/" + this.wood));
    }
}

