/*
 * Decompiled with CFR 0.152.
 */
package net.dries007.tfc.client.render.blockentity;

import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.VertexConsumer;
import java.util.Map;
import java.util.function.Function;
import java.util.function.Supplier;
import net.dries007.tfc.client.RenderHelpers;
import net.dries007.tfc.common.blocks.TFCBlocks;
import net.dries007.tfc.mixin.client.accessor.SignRendererAccessor;
import net.dries007.tfc.util.Helpers;
import net.minecraft.client.model.Model;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.Sheets;
import net.minecraft.client.renderer.blockentity.BlockEntityRendererProvider;
import net.minecraft.client.renderer.blockentity.HangingSignRenderer;
import net.minecraft.client.resources.model.Material;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.SignBlock;
import net.minecraft.world.level.block.entity.SignBlockEntity;
import net.minecraft.world.level.block.state.BlockState;
import org.jetbrains.annotations.Nullable;

public class TFCHangingSignBlockEntityRenderer
extends HangingSignRenderer {
    public static final Map<Block, Provider<Function<BlockEntityRendererProvider.Context, HangingSignRenderer.HangingSignModel>>> MODELS = RenderHelpers.mapOf(map -> TFCBlocks.CEILING_HANGING_SIGNS.forEach((wood, m) -> m.forEach((metal, block) -> {
        Provider<Function<BlockEntityRendererProvider.Context, HangingSignRenderer.HangingSignModel>> model = new Provider<Function<BlockEntityRendererProvider.Context, HangingSignRenderer.HangingSignModel>>(new Material(Sheets.SIGN_SHEET, Helpers.identifier("entity/signs/hanging/" + metal.getSerializedName() + "/" + wood.getSerializedName())), Helpers.resourceLocation(wood.getSerializedName() + ".png").withPrefix("textures/gui/hanging_signs/" + metal.getSerializedName() + "/"), context -> new HangingSignRenderer.HangingSignModel(context.bakeLayer(RenderHelpers.layerId("hanging_sign/" + wood.getSerializedName()))));
        map.accept(block, model);
        map.accept((Supplier)TFCBlocks.WALL_HANGING_SIGNS.get(wood).get(metal), model);
    })));
    private final Map<Block, Provider<HangingSignRenderer.HangingSignModel>> hangingSignModels = Helpers.mapValue(MODELS, v -> new Provider<HangingSignRenderer.HangingSignModel>(v.modelMaterial, v.textureLocation, (HangingSignRenderer.HangingSignModel)((Function)v.model).apply(context)));

    public TFCHangingSignBlockEntityRenderer(BlockEntityRendererProvider.Context context) {
        super(context);
    }

    public void render(SignBlockEntity sign, float partialTick, PoseStack poseStack, MultiBufferSource buffer, int light, int overlay) {
        BlockState state = sign.getBlockState();
        SignBlock signBlock = (SignBlock)state.getBlock();
        @Nullable Provider<// Could not load outer class - annotation placement on inner may be incorrect
        HangingSignRenderer.HangingSignModel> model = this.hangingSignModels.get(state.getBlock());
        if (model == null) {
            return;
        }
        ((HangingSignRenderer.HangingSignModel)model.model).evaluateVisibleParts(state);
        this.renderSignWithText(sign, poseStack, buffer, light, overlay, state, signBlock, model.modelMaterial(), (Model)model.model);
    }

    void renderSignWithText(SignBlockEntity sign, PoseStack poseStack, MultiBufferSource buffer, int light, int overlay, BlockState blockstate, SignBlock signblock, Material modelMaterial, Model model) {
        poseStack.pushPose();
        ((SignRendererAccessor)((Object)this)).invoke$translateSign(poseStack, -signblock.getYRotationDegrees(blockstate), blockstate);
        this.renderSign(poseStack, buffer, light, overlay, modelMaterial, model);
        ((SignRendererAccessor)((Object)this)).invoke$renderSignText(sign.getBlockPos(), sign.getFrontText(), poseStack, buffer, light, sign.getTextLineHeight(), sign.getMaxTextLineWidth(), true);
        ((SignRendererAccessor)((Object)this)).invoke$renderSignText(sign.getBlockPos(), sign.getBackText(), poseStack, buffer, light, sign.getTextLineHeight(), sign.getMaxTextLineWidth(), false);
        poseStack.popPose();
    }

    void renderSign(PoseStack poseStack, MultiBufferSource buffer, int light, int overlay, Material modelMaterial, Model model) {
        poseStack.pushPose();
        float f = this.getSignModelRenderScale();
        poseStack.scale(f, -f, -f);
        VertexConsumer vertexconsumer = modelMaterial.buffer(buffer, arg_0 -> ((Model)model).renderType(arg_0));
        ((SignRendererAccessor)((Object)this)).invoke$renderSignModel(poseStack, light, overlay, model, vertexconsumer);
        poseStack.popPose();
    }

    public record Provider<T>(Material modelMaterial, ResourceLocation textureLocation, T model) {
    }
}

