/*
 * Decompiled with CFR 0.152.
 */
package net.dries007.tfc.client.render.blockentity;

import com.mojang.blaze3d.vertex.PoseStack;
import java.util.Map;
import java.util.function.Function;
import net.dries007.tfc.client.RenderHelpers;
import net.dries007.tfc.common.blocks.wood.Wood;
import net.dries007.tfc.mixin.client.accessor.SignRendererAccessor;
import net.dries007.tfc.util.Helpers;
import net.minecraft.client.model.Model;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.blockentity.BlockEntityRendererProvider;
import net.minecraft.client.renderer.blockentity.SignRenderer;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.SignBlock;
import net.minecraft.world.level.block.StandingSignBlock;
import net.minecraft.world.level.block.entity.SignBlockEntity;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.WoodType;

public class TFCSignBlockEntityRenderer
extends SignRenderer {
    public static final Map<WoodType, Function<BlockEntityRendererProvider.Context, SignRenderer.SignModel>> MODELS = RenderHelpers.mapOf(map -> {
        for (Wood wood : Wood.values()) {
            map.accept(wood::getVanillaWoodType, context -> new SignRenderer.SignModel(context.bakeLayer(RenderHelpers.layerId("sign/" + wood.getSerializedName()))));
        }
    });
    private final Map<WoodType, SignRenderer.SignModel> signModels = Helpers.mapValue(MODELS, f -> (SignRenderer.SignModel)f.apply(context));

    public TFCSignBlockEntityRenderer(BlockEntityRendererProvider.Context context) {
        super(context);
    }

    public void render(SignBlockEntity sign, float partialTicks, PoseStack poseStack, MultiBufferSource source, int packedLight, int overlay) {
        BlockState blockstate = sign.getBlockState();
        SignBlock signblock = (SignBlock)blockstate.getBlock();
        WoodType woodType = SignBlock.getWoodType((Block)signblock);
        SignRenderer.SignModel model = this.signModels.get(woodType);
        model.stick.visible = blockstate.getBlock() instanceof StandingSignBlock;
        ((SignRendererAccessor)((Object)this)).invoke$renderSignWithText(sign, poseStack, source, packedLight, overlay, blockstate, signblock, woodType, (Model)model);
    }
}

