/*
 * Decompiled with CFR 0.152.
 */
package net.dries007.tfc.client.render.blockentity;

import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.VertexConsumer;
import com.mojang.math.Axis;
import java.util.Map;
import java.util.function.Supplier;
import net.dries007.tfc.client.RenderHelpers;
import net.dries007.tfc.common.blockentities.rotation.TripHammerBlockEntity;
import net.dries007.tfc.common.blocks.TripHammerBlock;
import net.dries007.tfc.common.items.TFCItems;
import net.dries007.tfc.util.Helpers;
import net.dries007.tfc.util.Metal;
import net.dries007.tfc.util.rotation.Rotation;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.client.renderer.blockentity.BlockEntityRenderer;
import net.minecraft.core.Direction;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.Mth;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;
import net.neoforged.neoforge.items.ItemStackHandler;

public class TripHammerBlockEntityRenderer
implements BlockEntityRenderer<TripHammerBlockEntity> {
    public static final ResourceLocation ROD_TEXTURE = Helpers.identifier("block/wood/planks/oak");
    public static final Map<Item, ResourceLocation> HAMMER_TEXTURES = RenderHelpers.mapOf(map -> TFCItems.METAL_ITEMS.entrySet().stream().filter(e -> ((Map)e.getValue()).containsKey((Object)Metal.ItemType.HAMMER)).forEach(e -> map.accept((Supplier)((Map)e.getValue()).get((Object)Metal.ItemType.HAMMER), Helpers.identifier("block/metal/smooth/" + ((Metal)e.getKey()).getSerializedName()))));

    public void render(TripHammerBlockEntity hammer, float partialTick, PoseStack stack, MultiBufferSource buffers, int packedLight, int packedOverlay) {
        BlockState state = hammer.getBlockState();
        Level level = hammer.getLevel();
        Rotation rotation = hammer.getRotation();
        if (level == null || !(state.getBlock() instanceof TripHammerBlock)) {
            return;
        }
        ItemStack item = ((ItemStackHandler)hammer.getInventory()).getStackInSlot(0);
        ResourceLocation hammerTexture = HAMMER_TEXTURES.get(item.getItem());
        if (hammerTexture == null) {
            return;
        }
        VertexConsumer buffer = buffers.getBuffer(RenderType.cutout());
        float px = 0.0625f;
        stack.pushPose();
        stack.translate(0.5f, 0.5f, 0.5f);
        stack.mulPose(Axis.YP.rotationDegrees(180.0f - 90.0f * (float)((Direction)state.getValue((Property)TripHammerBlock.FACING)).get2DDataValue()));
        stack.translate(-0.5f, -0.5f, -0.5f);
        float angle = rotation == null ? 0.0f : hammer.getRealRotationDegrees(rotation, partialTick);
        float pivotStart = 130.0f;
        float pivotMiddle = 180.0f;
        float pivotEnd = 183.0f;
        float pivotAngle = 0.0f;
        if (angle > 130.0f && angle < 180.0f) {
            pivotAngle = Mth.map((float)angle, (float)130.0f, (float)180.0f, (float)0.0f, (float)45.0f);
        } else if (angle > 180.0f && angle < 183.0f) {
            pivotAngle = 45.0f - Mth.map((float)angle, (float)180.0f, (float)183.0f, (float)0.0f, (float)45.0f);
        }
        float pivotX = 0.5f;
        float pivotY = 0.875f;
        float pivotZ = 0.1875f;
        if (pivotAngle != 0.0f && rotation.positiveDirection() == ((Direction)state.getValue((Property)TripHammerBlock.FACING)).getClockWise()) {
            stack.translate(0.5f, 0.875f, 0.1875f);
            stack.mulPose(Axis.XN.rotationDegrees(-pivotAngle));
            stack.translate(-0.5f, -0.875f, -0.1875f);
        }
        RenderHelpers.renderTexturedCuboid(stack, buffer, RenderHelpers.blockTexture(ROD_TEXTURE), packedLight, packedOverlay, 0.40625f, 0.78125f, -0.375f, 0.59375f, 0.96875f, 0.625f, false);
        RenderHelpers.renderTexturedCuboid(stack, buffer, RenderHelpers.blockTexture(hammerTexture), packedLight, packedOverlay, 0.34375f, 0.6875f, -0.6875f, 0.65625f, 1.0625f, -0.375f, false);
        stack.popPose();
    }
}

