/*
 * Decompiled with CFR 0.152.
 */
package net.dries007.tfc.client.render.blockentity;

import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.datafixers.util.Pair;
import com.mojang.math.Axis;
import java.util.Map;
import java.util.function.Function;
import net.dries007.tfc.client.RenderHelpers;
import net.dries007.tfc.client.model.entity.WindmillBladeLatticeModel;
import net.dries007.tfc.client.model.entity.WindmillBladeModel;
import net.dries007.tfc.client.model.entity.WindmillBladeRusticModel;
import net.dries007.tfc.client.render.blockentity.AxleBlockEntityRenderer;
import net.dries007.tfc.common.blockentities.rotation.WindmillBlockEntity;
import net.dries007.tfc.common.blocks.rotation.WindmillBlock;
import net.dries007.tfc.common.items.TFCItems;
import net.dries007.tfc.util.Helpers;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.client.renderer.blockentity.BlockEntityRenderer;
import net.minecraft.client.renderer.blockentity.BlockEntityRendererProvider;
import net.minecraft.core.Direction;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.DyeColor;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.phys.AABB;
import net.neoforged.neoforge.items.ItemStackHandler;
import org.apache.commons.lang3.mutable.Mutable;
import org.apache.commons.lang3.mutable.MutableObject;

public class WindmillBlockEntityRenderer
implements BlockEntityRenderer<WindmillBlockEntity> {
    public static final Map<Item, Provider<Function<BlockEntityRendererProvider.Context, WindmillBladeModel>>> BLADE_MODELS = RenderHelpers.mapOf(map -> {
        ResourceLocation defaultTexture = Helpers.identifier("textures/entity/misc/windmill_blade.png");
        Function<BlockEntityRendererProvider.Context, WindmillBladeModel> defaultModel = WindmillBlockEntityRenderer.defaultModelFactory();
        TFCItems.WINDMILL_BLADES.forEach((color, item) -> map.accept(item, new Provider<Function>(defaultTexture, (DyeColor)color, defaultModel)));
        map.accept(TFCItems.LATTICE_WINDMILL_BLADE, new Provider<Function<BlockEntityRendererProvider.Context, WindmillBladeModel>>(Helpers.identifier("textures/entity/misc/windmill_blade_lattice.png"), DyeColor.WHITE, context -> new WindmillBladeLatticeModel(context.bakeLayer(RenderHelpers.layerId("windmill_blade_lattice")))));
        map.accept(TFCItems.RUSTIC_WINDMILL_BLADE, new Provider<Function<BlockEntityRendererProvider.Context, WindmillBladeModel>>(Helpers.identifier("textures/entity/misc/windmill_blade_rustic.png"), DyeColor.WHITE, context -> new WindmillBladeRusticModel(context.bakeLayer(RenderHelpers.layerId("windmill_blade_rustic")))));
    });
    private final Map<Item, Provider<WindmillBladeModel>> bladeModels = Helpers.mapValue(BLADE_MODELS, v -> new Provider<WindmillBladeModel>(v.texture, v.color, (WindmillBladeModel)((Object)((Object)((Function)v.model).apply(context)))));

    private static Function<BlockEntityRendererProvider.Context, WindmillBladeModel> defaultModelFactory() {
        MutableObject cache = new MutableObject(null);
        return arg_0 -> WindmillBlockEntityRenderer.lambda$defaultModelFactory$4((Mutable)cache, arg_0);
    }

    public WindmillBlockEntityRenderer(BlockEntityRendererProvider.Context context) {
    }

    public void render(WindmillBlockEntity windmill, float partialTick, PoseStack stack, MultiBufferSource bufferSource, int packedLight, int packedOverlay) {
        Provider<WindmillBladeModel> provider;
        ItemStack item;
        int i;
        boolean hasFullIdenticalSet;
        boolean axisX;
        WindmillBlock windmillBlock;
        BlockState state;
        block11: {
            block10: {
                Level level = windmill.getLevel();
                state = windmill.getBlockState();
                Block block = state.getBlock();
                if (!(block instanceof WindmillBlock)) break block10;
                windmillBlock = (WindmillBlock)block;
                if (level != null) break block11;
            }
            return;
        }
        Direction.Axis axis = (Direction.Axis)state.getValue(WindmillBlock.AXIS);
        int bladeCount = (Integer)state.getValue((Property)WindmillBlock.COUNT);
        AxleBlockEntityRenderer.renderAxle(stack, bufferSource, windmillBlock, axis, packedLight, packedOverlay, -windmill.getRotationAngle(partialTick));
        stack.pushPose();
        boolean bl = axisX = state.getValue(WindmillBlock.AXIS) == Direction.Axis.X;
        if (!axisX) {
            stack.mulPose(Axis.YN.rotationDegrees(90.0f));
            stack.mulPose(Axis.XN.rotationDegrees(90.0f));
        } else {
            stack.mulPose(Axis.XN.rotationDegrees(90.0f));
        }
        stack.translate(0.5f, axisX ? -2.0f : -1.0f, 0.5f);
        boolean bl2 = hasFullIdenticalSet = bladeCount == 5;
        if (hasFullIdenticalSet) {
            WindmillBladeModel model = null;
            for (i = 0; i < bladeCount; ++i) {
                item = ((ItemStackHandler)windmill.getInventory()).getStackInSlot(i);
                provider = this.bladeModels.get(item.getItem());
                if (item.isEmpty() || provider == null || model != null && model != provider.model) {
                    hasFullIdenticalSet = false;
                    break;
                }
                model = (WindmillBladeModel)((Object)provider.model);
            }
        }
        float offsetAngle = (float)Math.PI * 2 / (float)bladeCount;
        for (i = 0; i < bladeCount; ++i) {
            item = ((ItemStackHandler)windmill.getInventory()).getStackInSlot(i);
            provider = this.bladeModels.get(item.getItem());
            if (provider == null) continue;
            int color = provider.color == DyeColor.WHITE ? -1 : provider.color.getTextureDiffuseColor();
            WindmillBladeModel bladeModel = (WindmillBladeModel)((Object)provider.model);
            ResourceLocation bladeTexture = provider.texture;
            stack.pushPose();
            stack.translate(1.0E-4f * (float)i, 1.0E-4f * (float)i, 1.0E-4f * (float)i);
            bladeModel.setupAnim(windmill, partialTick, offsetAngle * (float)i);
            bladeModel.renderToBuffer(stack, bufferSource.getBuffer(RenderType.entityCutoutNoCull((ResourceLocation)bladeTexture)), packedLight, packedOverlay, color);
            if (hasFullIdenticalSet) {
                bladeModel.renderWindmillExtras(stack, bufferSource.getBuffer(RenderType.entityCutoutNoCull((ResourceLocation)bladeTexture)), packedLight, packedOverlay, color);
            }
            stack.popPose();
        }
        stack.popPose();
    }

    public boolean shouldRenderOffScreen(WindmillBlockEntity windmill) {
        return true;
    }

    public AABB getRenderBoundingBox(WindmillBlockEntity blockEntity) {
        return AABB.INFINITE;
    }

    private static /* synthetic */ WindmillBladeModel lambda$defaultModelFactory$4(Mutable cache, BlockEntityRendererProvider.Context context) {
        if (cache.getValue() != null && ((Pair)cache.getValue()).getFirst() != context) {
            cache.setValue(null);
        }
        if (cache.getValue() == null) {
            cache.setValue((Object)Pair.of((Object)context, (Object)((Object)new WindmillBladeModel(context.bakeLayer(RenderHelpers.layerId("windmill_blade"))))));
        }
        return (WindmillBladeModel)((Object)((Pair)cache.getValue()).getSecond());
    }

    public record Provider<T>(ResourceLocation texture, DyeColor color, T model) {
    }
}

