/*
 * Decompiled with CFR 0.152.
 */
package net.dries007.tfc.client.screen;

import java.util.ArrayList;
import java.util.List;
import net.dries007.tfc.client.ClientHelpers;
import net.dries007.tfc.client.screen.BlockEntityScreen;
import net.dries007.tfc.client.screen.button.AnvilPlanSelectButton;
import net.dries007.tfc.client.screen.button.NextPageButton;
import net.dries007.tfc.common.blockentities.AnvilBlockEntity;
import net.dries007.tfc.common.container.AnvilPlanContainer;
import net.dries007.tfc.common.recipes.AnvilRecipe;
import net.dries007.tfc.util.Helpers;
import net.minecraft.client.gui.components.Button;
import net.minecraft.client.gui.components.events.GuiEventListener;
import net.minecraft.core.HolderLookup;
import net.minecraft.core.RegistryAccess;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.RecipeHolder;
import org.jetbrains.annotations.Nullable;

public class AnvilPlanScreen
extends BlockEntityScreen<AnvilBlockEntity, AnvilPlanContainer> {
    public static final ResourceLocation BACKGROUND = Helpers.identifier("textures/gui/anvil_plan.png");
    @Nullable
    private Button leftButton;
    @Nullable
    private Button rightButton;
    @Nullable
    private List<AnvilPlanSelectButton> recipeButtons;
    private int maxPageInclusive = 0;
    private int currentPage = 0;

    public AnvilPlanScreen(AnvilPlanContainer container, Inventory playerInventory, Component name) {
        super(container, playerInventory, name, BACKGROUND);
    }

    protected void init() {
        super.init();
        int recipesPerPage = 18;
        int guiLeft = this.getGuiLeft();
        int guiTop = this.getGuiTop();
        ItemStack inputStack = ((AnvilBlockEntity.AnvilInventory)((AnvilBlockEntity)this.blockEntity).getInventory()).getStackInSlot(0);
        List<RecipeHolder<AnvilRecipe>> recipes = AnvilRecipe.getAll(this.playerInventory.player.level(), inputStack, ((AnvilBlockEntity)this.blockEntity).getTier());
        this.recipeButtons = new ArrayList<AnvilPlanSelectButton>();
        for (int i = 0; i < recipes.size(); ++i) {
            int page = i / 18;
            int index = i % 18;
            int posX = 7 + index % 9 * 18;
            int posY = 17 + index % 18 / 9 * 18;
            RecipeHolder<AnvilRecipe> recipe = recipes.get(i);
            RegistryAccess access = ClientHelpers.getLevelOrThrow().registryAccess();
            AnvilPlanSelectButton button2 = new AnvilPlanSelectButton(guiLeft + posX, guiTop + posY, page, recipe, ((AnvilRecipe)recipe.value()).getResultItem((HolderLookup.Provider)access).getHoverName());
            button2.setCurrentPage(0);
            this.recipeButtons.add(button2);
            this.addRenderableWidget((GuiEventListener)button2);
        }
        this.maxPageInclusive = (recipes.size() - 1) / 18;
        this.leftButton = NextPageButton.left(guiLeft + 7, guiTop + 56, button -> {
            if (this.currentPage > 0) {
                --this.currentPage;
                this.updateCurrentPage();
            }
        });
        this.addRenderableWidget((GuiEventListener)this.leftButton);
        this.rightButton = NextPageButton.right(guiLeft + 160, guiTop + 56, button -> {
            if (this.currentPage < this.maxPageInclusive) {
                ++this.currentPage;
                this.updateCurrentPage();
            }
        });
        this.addRenderableWidget((GuiEventListener)this.rightButton);
        this.updateCurrentPage();
    }

    private void updateCurrentPage() {
        assert (this.recipeButtons != null && this.leftButton != null && this.rightButton != null);
        for (AnvilPlanSelectButton button : this.recipeButtons) {
            button.setCurrentPage(this.currentPage);
        }
        this.leftButton.visible = this.currentPage > 0;
        this.leftButton.active = this.leftButton.visible;
        this.rightButton.visible = this.currentPage < this.maxPageInclusive;
        this.rightButton.active = this.rightButton.visible;
    }
}

