/*
 * Decompiled with CFR 0.152.
 */
package net.dries007.tfc.client.screen;

import net.dries007.tfc.client.RenderHelpers;
import net.dries007.tfc.client.screen.BlockEntityScreen;
import net.dries007.tfc.common.blockentities.BlastFurnaceBlockEntity;
import net.dries007.tfc.common.blocks.devices.BlastFurnaceBlock;
import net.dries007.tfc.common.component.heat.Heat;
import net.dries007.tfc.common.container.BlastFurnaceContainer;
import net.dries007.tfc.config.TFCConfig;
import net.dries007.tfc.util.Helpers;
import net.dries007.tfc.util.tooltip.Tooltips;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.renderer.texture.TextureAtlasSprite;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.level.block.state.properties.Property;
import net.neoforged.neoforge.fluids.FluidStack;

public class BlastFurnaceScreen
extends BlockEntityScreen<BlastFurnaceBlockEntity, BlastFurnaceContainer> {
    private static final ResourceLocation BLAST_FURNACE = Helpers.identifier("textures/gui/blast_furnace.png");

    public BlastFurnaceScreen(BlastFurnaceContainer container, Inventory playerInventory, Component name) {
        super(container, playerInventory, name, BLAST_FURNACE);
        this.inventoryLabelY += 20;
        this.imageHeight += 20;
    }

    @Override
    protected void renderBg(GuiGraphics graphics, float partialTicks, int mouseX, int mouseY) {
        FluidStack fluid;
        super.renderBg(graphics, partialTicks, mouseX, mouseY);
        int capacity = ((BlastFurnaceBlockEntity)this.blockEntity).getCapacity();
        int fuelCount = ((BlastFurnaceBlockEntity)this.blockEntity).getFuelCount();
        int inputCount = ((BlastFurnaceBlockEntity)this.blockEntity).getInputCount();
        int maximumCapacity = TFCConfig.SERVER.blastFurnaceCapacity.get() * TFCConfig.SERVER.blastFurnaceMaxChimneyHeight.get();
        boolean lit = (Boolean)((BlastFurnaceBlockEntity)this.blockEntity).getBlockState().getValue((Property)BlastFurnaceBlock.LIT);
        this.renderCapacityLimitedFillMeter(graphics, 42, 22, lit ? 216 : 226, maximumCapacity, capacity, inputCount);
        this.renderCapacityLimitedFillMeter(graphics, 124, 22, 206, maximumCapacity, capacity, fuelCount);
        int temperature = Heat.scaleTemperatureForGui(((BlastFurnaceBlockEntity)this.blockEntity).getTemperature());
        if (temperature > 0) {
            graphics.blit(this.texture, this.leftPos + 8, this.topPos + 76 - Math.min(51, temperature), 176, 0, 15, 5);
        }
        if (!(fluid = ((BlastFurnaceBlockEntity.BlastFurnaceInventory)((BlastFurnaceBlockEntity)this.blockEntity).getInventory()).getFluidInTank(0)).isEmpty()) {
            TextureAtlasSprite sprite = RenderHelpers.getAndBindFluidSprite(fluid);
            int fillHeight = (int)Math.ceil(31.0f * (float)fluid.getAmount() / (float)TFCConfig.SERVER.blastFurnaceFluidCapacity.get().intValue());
            RenderHelpers.fillAreaWithSprite(graphics, sprite, this.leftPos + 70, this.topPos + 84 - fillHeight, 36, fillHeight, 16, 16);
        }
        this.resetToBackgroundSprite();
    }

    protected void renderTooltip(GuiGraphics graphics, int mouseX, int mouseY) {
        MutableComponent text;
        super.renderTooltip(graphics, mouseX, mouseY);
        int capacity = ((BlastFurnaceBlockEntity)this.blockEntity).getCapacity();
        int fuelCount = ((BlastFurnaceBlockEntity)this.blockEntity).getFuelCount();
        int inputCount = ((BlastFurnaceBlockEntity)this.blockEntity).getInputCount();
        FluidStack fluid = ((BlastFurnaceBlockEntity.BlastFurnaceInventory)((BlastFurnaceBlockEntity)this.blockEntity).getInventory()).getFluidInTank(0);
        if (RenderHelpers.isInside(mouseX, mouseY, this.leftPos + 42, this.topPos + 22, 10, 66)) {
            graphics.renderTooltip(this.font, (Component)Component.translatable((String)"tfc.tooltip.blast_furnace_ore", (Object[])new Object[]{inputCount, capacity}), mouseX, mouseY);
        }
        if (RenderHelpers.isInside(mouseX, mouseY, this.leftPos + 124, this.topPos + 22, 10, 66)) {
            graphics.renderTooltip(this.font, (Component)Component.translatable((String)"tfc.tooltip.blast_furnace_fuel", (Object[])new Object[]{fuelCount, capacity}), mouseX, mouseY);
        }
        if (RenderHelpers.isInside(mouseX, mouseY, this.leftPos + 70, this.topPos + 54, 36, 31) && !fluid.isEmpty()) {
            graphics.renderTooltip(this.font, (Component)Tooltips.fluidUnitsOf(fluid), mouseX, mouseY);
        }
        if (RenderHelpers.isInside(mouseX, mouseY, this.leftPos + 8, this.topPos + 76 - 51, 15, 51) && (text = TFCConfig.CLIENT.heatTooltipStyle.get().formatColored(((BlastFurnaceBlockEntity)this.blockEntity).getTemperature())) != null) {
            graphics.renderTooltip(this.font, (Component)text, mouseX, mouseY);
        }
    }

    private void renderCapacityLimitedFillMeter(GuiGraphics graphics, int x, int y, int fillU, int maximum, int capacity, int content) {
        if (capacity == 0) {
            graphics.blit(this.texture, this.leftPos + x, this.topPos + y, 246, 0, 10, 66);
        } else if (content == 0) {
            int emptyHeight = 64 * capacity / maximum;
            graphics.blit(this.texture, this.leftPos + x, this.topPos + y + 64 - emptyHeight, 236, 0, 10, 1 + emptyHeight);
        } else {
            int emptyHeight = 64 * capacity / maximum;
            int fillHeight = 64 * content / maximum;
            graphics.blit(this.texture, this.leftPos + x, this.topPos + y + 64 - emptyHeight, 236, 0, 10, 1 + emptyHeight - fillHeight);
            graphics.blit(this.texture, this.leftPos + x, this.topPos + y + 65 - fillHeight, fillU, 1, 10, fillHeight);
        }
    }
}

