/*
 * Decompiled with CFR 0.152.
 */
package net.dries007.tfc.client.screen;

import net.dries007.tfc.client.ClientHelpers;
import net.dries007.tfc.client.screen.TFCContainerScreen;
import net.dries007.tfc.client.screen.button.PlayerInventoryTabButton;
import net.dries007.tfc.common.container.Container;
import net.dries007.tfc.compat.patchouli.PatchouliIntegration;
import net.dries007.tfc.network.SwitchInventoryTabPacket;
import net.dries007.tfc.util.Helpers;
import net.dries007.tfc.util.calendar.Calendars;
import net.dries007.tfc.util.calendar.Month;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.components.events.GuiEventListener;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.client.gui.screens.inventory.InventoryScreen;
import net.minecraft.client.resources.language.I18n;
import net.minecraft.network.chat.Component;
import net.minecraft.network.protocol.common.custom.CustomPacketPayload;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.player.Inventory;
import net.neoforged.neoforge.network.PacketDistributor;

public class CalendarScreen
extends TFCContainerScreen<Container> {
    public static final ResourceLocation BACKGROUND = Helpers.identifier("textures/gui/player_calendar.png");

    public CalendarScreen(Container container, Inventory playerInv, Component name) {
        super(container, playerInv, name, BACKGROUND);
    }

    public void init() {
        super.init();
        this.addRenderableWidget((GuiEventListener)new PlayerInventoryTabButton(this.leftPos, this.topPos, 176, 4, 20, 22, 128, 0, 1, 3, 0, 0, button -> {
            this.playerInventory.player.containerMenu = this.playerInventory.player.inventoryMenu;
            Minecraft.getInstance().setScreen((Screen)new InventoryScreen(this.playerInventory.player));
            PacketDistributor.sendToServer((CustomPacketPayload)new SwitchInventoryTabPacket(SwitchInventoryTabPacket.Tab.INVENTORY), (CustomPacketPayload[])new CustomPacketPayload[0]);
        }));
        this.addRenderableWidget((GuiEventListener)new PlayerInventoryTabButton(this.leftPos, this.topPos, 173, 27, 23, 22, 148, 0, 1, 3, 32, 0, button -> {}));
        this.addRenderableWidget((GuiEventListener)new PlayerInventoryTabButton(this.leftPos, this.topPos, 176, 50, 20, 22, 128, 0, 1, 3, 64, 0, SwitchInventoryTabPacket.Tab.NUTRITION));
        this.addRenderableWidget((GuiEventListener)new PlayerInventoryTabButton(this.leftPos, this.topPos, 176, 73, 20, 22, 128, 0, 1, 3, 96, 0, SwitchInventoryTabPacket.Tab.CLIMATE));
        PatchouliIntegration.ifEnabled(() -> this.addRenderableWidget((GuiEventListener)new PlayerInventoryTabButton(this.leftPos, this.topPos, 176, 96, 20, 22, 128, 0, 1, 3, 0, 32, SwitchInventoryTabPacket.Tab.BOOK)));
    }

    protected void renderLabels(GuiGraphics graphics, int mouseX, int mouseY) {
        super.renderLabels(graphics, mouseX, mouseY);
        String date = Calendars.CLIENT.getCalendarDayOfYear().getString() + ", " + I18n.get((String)Calendars.CLIENT.getAbsoluteCalendarMonthOfYear().getTranslationKey(Month.Style.LONG_MONTH), (Object[])new Object[0]) + " " + Calendars.CLIENT.getCalendarDayOfMonth() + ", " + Calendars.CLIENT.getCalendarYear();
        this.drawLine(graphics, (Component)Component.literal((String)":"), TFCContainerScreen.TextAlignment.CENTER, 22);
        this.drawLine(graphics, (Component)Component.literal((String)String.format("%02d", Calendars.CLIENT.getHourOfDay())), TFCContainerScreen.TextAlignment.RIGHT, -1, 83, 22);
        this.drawLine(graphics, (Component)Component.literal((String)String.format("%02d", Calendars.CLIENT.getMinuteOfHour())), TFCContainerScreen.TextAlignment.LEFT, -1, 83, 22);
        this.drawLine(graphics, (Component)Component.translatable((String)date), TFCContainerScreen.TextAlignment.CENTER, 33);
        if (Calendars.CLIENT.getBirthday().equals((Object)Component.empty())) {
            int daysLeft = Calendars.CLIENT.getCalendarDaysInMonth() - Calendars.CLIENT.getCalendarDayOfMonth();
            String daysLeftKey = "tfc.tooltip.calendar_days_left_in_month";
            if (daysLeft == 1) {
                daysLeftKey = "tfc.tooltip.calendar_second_last_day_in_month";
            }
            if (daysLeft == 0) {
                daysLeftKey = "tfc.tooltip.calendar_last_day_in_month";
                this.drawLine(graphics, (Component)Component.translatable((String)daysLeftKey, (Object[])new Object[]{I18n.get((String)Calendars.CLIENT.getAbsoluteCalendarMonthOfYear().getTranslationKey(Month.Style.LONG_MONTH), (Object[])new Object[0])}), TFCContainerScreen.TextAlignment.CENTER, 44);
            } else {
                this.drawLine(graphics, (Component)Component.translatable((String)daysLeftKey, (Object[])new Object[]{daysLeft, I18n.get((String)Calendars.CLIENT.getAbsoluteCalendarMonthOfYear().getTranslationKey(Month.Style.LONG_MONTH), (Object[])new Object[0])}), TFCContainerScreen.TextAlignment.CENTER, 44);
            }
        } else {
            this.drawLine(graphics, (Component)Calendars.CLIENT.getBirthday(), TFCContainerScreen.TextAlignment.CENTER, 44);
        }
        this.drawLine(graphics, (Component)Component.translatable((String)Calendars.CLIENT.getHemispheralCalendarMonthOfYear(ClientHelpers.inNorthernHemisphere()).getTranslationKey(Month.Style.SEASON)), TFCContainerScreen.TextAlignment.CENTER, 55);
    }
}

