/*
 * Decompiled with CFR 0.152.
 */
package net.dries007.tfc.client.screen;

import net.dries007.tfc.world.ChunkGeneratorExtension;
import net.dries007.tfc.world.settings.Settings;
import net.minecraft.client.Minecraft;
import net.minecraft.client.OptionInstance;
import net.minecraft.client.Options;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.components.AbstractWidget;
import net.minecraft.client.gui.components.Button;
import net.minecraft.client.gui.components.events.GuiEventListener;
import net.minecraft.client.gui.layouts.FrameLayout;
import net.minecraft.client.gui.layouts.GridLayout;
import net.minecraft.client.gui.layouts.LayoutElement;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.client.gui.screens.worldselection.CreateWorldScreen;
import net.minecraft.client.gui.screens.worldselection.WorldCreationContext;
import net.minecraft.network.chat.CommonComponents;
import net.minecraft.network.chat.Component;
import net.minecraft.world.level.chunk.ChunkGenerator;

public class CreateTFCWorldScreen
extends Screen {
    private final CreateWorldScreen parent;
    private final WorldCreationContext context;
    private OptionInstance<Boolean> flatBedrock;
    private OptionInstance<Boolean> finiteContinents;
    private OptionInstance<Integer> spawnDistance;
    private OptionInstance<Integer> spawnCenterX;
    private OptionInstance<Integer> spawnCenterZ;
    private OptionInstance<Integer> temperatureScale;
    private OptionInstance<Integer> rainfallScale;
    private OptionInstance<Double> temperatureConstant;
    private OptionInstance<Double> rainfallConstant;
    private OptionInstance<Double> continentalness;
    private OptionInstance<Double> grassDensity;

    private static OptionInstance<Double> constOption(String caption, double defaultValue) {
        return new OptionInstance(caption, OptionInstance.noTooltip(), (text, value) -> value > 0.49 && value < 0.51 ? Options.genericValueLabel((Component)text, (Component)CommonComponents.OPTION_OFF) : Component.translatable((String)"options.percent_value", (Object[])new Object[]{text, (int)((value - 0.5) * 200.0)}), (OptionInstance.ValueSet)OptionInstance.UnitDouble.INSTANCE, (Object)((1.0 + defaultValue) * 0.5), value -> {});
    }

    private static OptionInstance<Double> pctOption(String caption, double defaultValue) {
        return new OptionInstance(caption, OptionInstance.noTooltip(), (text, value) -> Component.translatable((String)"options.percent_value", (Object[])new Object[]{text, (int)((value - 0.5) * 200.0)}), (OptionInstance.ValueSet)OptionInstance.UnitDouble.INSTANCE, (Object)defaultValue, value -> {});
    }

    private static OptionInstance<Integer> kmOption(String caption, int min, int max, int defaultValue) {
        return new OptionInstance(caption, OptionInstance.cachedConstantTooltip((Component)Component.translatable((String)(caption + ".tooltip"))), (text, value) -> Options.genericValueLabel((Component)text, (Component)Component.translatable((String)"tfc.settings.km", (Object[])new Object[]{String.format("%.1f", (double)value.intValue() / 1000.0)})), (OptionInstance.ValueSet)new OptionInstance.IntRange(min, max), (Object)defaultValue, value -> {});
    }

    public CreateTFCWorldScreen(CreateWorldScreen parent, WorldCreationContext context) {
        super((Component)Component.translatable((String)"tfc.tooltip.create_world.title"));
        this.parent = parent;
        this.context = context;
    }

    public void onClose() {
        assert (this.minecraft != null);
        this.minecraft.setScreen((Screen)this.parent);
    }

    public void render(GuiGraphics graphics, int mouseX, int mouseY, float partialTick) {
        this.renderBackground(graphics, mouseX, mouseY, partialTick);
        super.render(graphics, mouseX, mouseY, partialTick);
        graphics.drawCenteredString(this.font, this.title, this.width / 2, 4, 0xFFFFFF);
    }

    protected void init() {
        assert (this.minecraft != null);
        ChunkGenerator generator = this.context.selectedDimensions().overworld();
        Settings settings = ((ChunkGeneratorExtension)generator).settings();
        GridLayout grid = new GridLayout();
        grid.defaultCellSetting().padding(4, 4, 4, 0);
        GridLayout.RowHelper builder = grid.createRowHelper(2);
        this.flatBedrock = OptionInstance.createBoolean((String)"tfc.create_world.flat_bedrock", (boolean)settings.flatBedrock(), value -> {});
        this.spawnDistance = CreateTFCWorldScreen.kmOption("tfc.create_world.spawn_distance", 100, 20000, settings.spawnDistance());
        this.spawnCenterX = CreateTFCWorldScreen.kmOption("tfc.create_world.spawn_center_x", -20000, 20000, settings.spawnCenterX());
        this.spawnCenterZ = CreateTFCWorldScreen.kmOption("tfc.create_world.spawn_center_z", -20000, 20000, settings.spawnCenterZ());
        this.temperatureScale = CreateTFCWorldScreen.kmOption("tfc.create_world.temperature_scale", 0, 40000, settings.temperatureScale());
        this.rainfallScale = CreateTFCWorldScreen.kmOption("tfc.create_world.rainfall_scale", 0, 40000, settings.rainfallScale());
        this.temperatureConstant = CreateTFCWorldScreen.constOption("tfc.create_world.temperature_constant", settings.temperatureConstant());
        this.rainfallConstant = CreateTFCWorldScreen.constOption("tfc.create_world.rainfall_constant", settings.rainfallConstant());
        this.continentalness = CreateTFCWorldScreen.pctOption("tfc.create_world.continentalness", settings.continentalness());
        this.grassDensity = CreateTFCWorldScreen.pctOption("tfc.create_world.grass_density", settings.continentalness());
        this.finiteContinents = OptionInstance.createBoolean((String)"tfc.create_world.finite_continents", (boolean)settings.finiteContinents(), value -> {});
        builder.addChild((LayoutElement)this.smallButton(this.flatBedrock));
        builder.addChild((LayoutElement)this.smallButton(this.spawnDistance));
        builder.addChild((LayoutElement)this.smallButton(this.spawnCenterX));
        builder.addChild((LayoutElement)this.smallButton(this.spawnCenterZ));
        builder.addChild((LayoutElement)this.smallButton(this.temperatureScale));
        builder.addChild((LayoutElement)this.smallButton(this.rainfallScale));
        builder.addChild((LayoutElement)this.smallButton(this.temperatureConstant));
        builder.addChild((LayoutElement)this.smallButton(this.rainfallConstant));
        builder.addChild((LayoutElement)this.smallButton(this.continentalness));
        builder.addChild((LayoutElement)this.smallButton(this.grassDensity));
        builder.addChild((LayoutElement)this.smallButton(this.finiteContinents));
        builder.addChild((LayoutElement)Button.builder((Component)CommonComponents.GUI_DONE, button -> {
            this.applySettings();
            this.minecraft.setScreen((Screen)this.parent);
        }).width(400).build(), 2);
        builder.addChild((LayoutElement)Button.builder((Component)CommonComponents.GUI_CANCEL, button -> this.minecraft.setScreen((Screen)this.parent)).width(400).build(), 2);
        grid.arrangeElements();
        FrameLayout.alignInRectangle((LayoutElement)grid, (int)0, (int)0, (int)this.width, (int)this.height, (float)0.5f, (float)0.25f);
        grid.visitWidgets(x$0 -> {
            AbstractWidget cfr_ignored_0 = (AbstractWidget)this.addRenderableWidget((GuiEventListener)x$0);
        });
    }

    private AbstractWidget smallButton(OptionInstance<?> option) {
        AbstractWidget widget = option.createButton(Minecraft.getInstance().options);
        widget.setWidth(200);
        return widget;
    }

    private void applySettings() {
        ChunkGenerator generator = this.context.selectedDimensions().overworld();
        if (generator instanceof ChunkGeneratorExtension) {
            ChunkGeneratorExtension extension = (ChunkGeneratorExtension)generator;
            extension.applySettings(old -> new Settings((Boolean)this.flatBedrock.get(), (Integer)this.spawnDistance.get(), (Integer)this.spawnCenterX.get(), (Integer)this.spawnCenterZ.get(), 0.49 < (Double)this.temperatureConstant.get() && (Double)this.temperatureConstant.get() < 0.51 ? (Integer)this.temperatureScale.get() : 0, (float)((Double)this.temperatureConstant.get() * 2.0 - 1.0), 0.49 < (Double)this.rainfallConstant.get() && (Double)this.rainfallConstant.get() < 0.51 ? (Integer)this.rainfallScale.get() : 0, (float)((Double)this.rainfallConstant.get() * 2.0 - 1.0), old.rockLayerSettings(), ((Double)this.continentalness.get()).floatValue(), ((Double)this.grassDensity.get()).floatValue(), (Boolean)this.finiteContinents.get()));
        }
    }
}

