/*
 * Decompiled with CFR 0.152.
 */
package net.dries007.tfc.client.screen;

import com.mojang.blaze3d.platform.InputConstants;
import it.unimi.dsi.fastutil.objects.Object2DoubleMap;
import net.dries007.tfc.client.RenderHelpers;
import net.dries007.tfc.client.screen.BlockEntityScreen;
import net.dries007.tfc.common.blockentities.CrucibleBlockEntity;
import net.dries007.tfc.common.component.heat.Heat;
import net.dries007.tfc.common.component.mold.IMold;
import net.dries007.tfc.common.container.CrucibleContainer;
import net.dries007.tfc.config.TFCConfig;
import net.dries007.tfc.network.PourFasterPacket;
import net.dries007.tfc.util.FluidAlloy;
import net.dries007.tfc.util.Helpers;
import net.dries007.tfc.util.tooltip.Tooltips;
import net.minecraft.ChatFormatting;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.renderer.texture.TextureAtlasSprite;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.network.protocol.common.custom.CustomPacketPayload;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.level.material.Fluid;
import net.neoforged.neoforge.fluids.FluidStack;
import net.neoforged.neoforge.network.PacketDistributor;

public class CrucibleScreen
extends BlockEntityScreen<CrucibleBlockEntity, CrucibleContainer> {
    private static final ResourceLocation BACKGROUND = Helpers.identifier("textures/gui/crucible.png");
    private static final int MAX_ELEMENTS = 3;
    private int scrollPos;
    private boolean scrollPress;
    private int pourFasterDecayTicks = 0;

    public CrucibleScreen(CrucibleContainer container, Inventory playerInventory, Component name) {
        super(container, playerInventory, name, BACKGROUND);
        this.inventoryLabelY += 55;
        this.imageHeight += 55;
        this.scrollPos = 0;
        this.scrollPress = false;
    }

    protected void containerTick() {
        if (this.pourFasterDecayTicks <= 0 && InputConstants.isKeyDown((long)Minecraft.getInstance().getWindow().getWindow(), (int)340)) {
            IMold mold;
            if (this.hoveredSlot != null && (mold = IMold.get(this.hoveredSlot.getItem())) != null) {
                PacketDistributor.sendToServer((CustomPacketPayload)new PourFasterPacket(((CrucibleBlockEntity)this.blockEntity).getBlockPos(), this.hoveredSlot.index), (CustomPacketPayload[])new CustomPacketPayload[0]);
                this.pourFasterDecayTicks = 10;
            }
        } else {
            --this.pourFasterDecayTicks;
        }
        super.containerTick();
    }

    protected void renderLabels(GuiGraphics stack, int mouseX, int mouseY) {
    }

    public boolean mouseClicked(double mouseX, double mouseY, int button) {
        if (mouseX >= (double)(this.leftPos + 154) && mouseX <= (double)(this.leftPos + 165) && mouseY >= (double)(this.topPos + 11 + this.scrollPos) && mouseY <= (double)(this.topPos + 26 + this.scrollPos)) {
            this.scrollPress = true;
        }
        return super.mouseClicked(mouseX, mouseY, button);
    }

    public boolean mouseDragged(double mouseX, double mouseY, int button, double dragX, double dragY) {
        if (this.scrollPress) {
            this.scrollPos = Math.min(Math.max((int)mouseY - this.topPos - 18, 0), 49);
        }
        return super.mouseDragged(mouseX, mouseY, button, dragX, dragY);
    }

    public boolean mouseReleased(double mouseX, double mouseY, int button) {
        if (this.scrollPress && button == 0) {
            this.scrollPress = false;
        }
        return super.mouseReleased(mouseX, mouseY, button);
    }

    @Override
    protected void renderBg(GuiGraphics graphics, float partialTicks, int mouseX, int mouseY) {
        super.renderBg(graphics, partialTicks, mouseX, mouseY);
        int temperature = Heat.scaleTemperatureForGui(((CrucibleBlockEntity)this.blockEntity).getTemperature());
        if (temperature > 0) {
            graphics.blit(this.texture, this.leftPos + 7, this.topPos + 131 - Math.min(temperature, 51), 176, 0, 15, 5);
        }
        graphics.blit(this.texture, this.leftPos + 154, this.topPos + 11 + this.scrollPos, 176, 7, 12, 15);
        FluidAlloy alloy = ((CrucibleBlockEntity)this.blockEntity).getAlloy();
        FluidStack alloyResult = ((CrucibleBlockEntity)this.blockEntity).getAlloyResult();
        if (alloy.getAmount() > 0 && !alloyResult.isEmpty()) {
            TextureAtlasSprite sprite = RenderHelpers.getAndBindFluidSprite(alloyResult);
            int fillHeight = (int)Math.ceil(31.0f * (float)alloy.getAmount() / (float)((CrucibleBlockEntity)this.blockEntity).containerInfo().fluidCapacity());
            RenderHelpers.fillAreaWithSprite(graphics, sprite, this.leftPos + 97, this.topPos + 124 - fillHeight, 36, fillHeight, 16, 16);
            this.resetToBackgroundSprite();
            MutableComponent resultText = alloyResult.getFluidType().getDescription().copy().withStyle(ChatFormatting.UNDERLINE);
            graphics.drawString(this.font, (Component)resultText, this.leftPos + 10, this.topPos + 11, 0, false);
            int startElement = Math.max(0, (int)Math.floor((double)(alloy.getContent().size() - 3) / 49.0 * (double)(this.scrollPos + 1)));
            int yPos = this.topPos + 22;
            int index = -1;
            for (Object2DoubleMap.Entry entry : alloy.getContent().object2DoubleEntrySet()) {
                if (++index < startElement) continue;
                if (index > startElement - 1 + 3) break;
                String metalName = this.font.plainSubstrByWidth(((Fluid)entry.getKey()).getFluidType().getDescription().getString(), 141) + ":";
                MutableComponent content = Component.translatable((String)"tfc.tooltip.crucible_content_line", (Object[])new Object[]{Tooltips.fluidUnits(entry.getDoubleValue()), String.format("%2.1f", Float.valueOf((float)Math.round(1000.0 * entry.getDoubleValue() / (double)alloy.getAmount()) / 10.0f))});
                graphics.drawString(this.font, metalName, this.leftPos + 10, yPos, 0x404040, false);
                graphics.drawString(this.font, (Component)content, this.leftPos + 10, yPos + 9, 0x404040, false);
                yPos += 18;
            }
        }
    }

    protected void renderTooltip(GuiGraphics graphics, int mouseX, int mouseY) {
        MutableComponent text;
        super.renderTooltip(graphics, mouseX, mouseY);
        if (RenderHelpers.isInside(mouseX, mouseY, this.leftPos + 7, this.topPos + 131 - 51, 15, 51) && (text = TFCConfig.CLIENT.heatTooltipStyle.get().formatColored(((CrucibleBlockEntity)this.blockEntity).getTemperature())) != null) {
            graphics.renderTooltip(this.font, (Component)text, mouseX, mouseY);
        }
    }
}

