/*
 * Decompiled with CFR 0.152.
 */
package net.dries007.tfc.client.screen;

import net.dries007.tfc.client.RenderHelpers;
import net.dries007.tfc.client.screen.BlockEntityScreen;
import net.dries007.tfc.common.blockentities.FireboxBlockEntity;
import net.dries007.tfc.common.component.heat.Heat;
import net.dries007.tfc.common.container.FireboxContainer;
import net.dries007.tfc.config.TFCConfig;
import net.dries007.tfc.util.Helpers;
import net.dries007.tfc.util.calendar.Calendars;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.player.Inventory;

public class FireboxScreen
extends BlockEntityScreen<FireboxBlockEntity, FireboxContainer> {
    private static final ResourceLocation TEXTURE = Helpers.identifier("textures/gui/firebox.png");
    private static final ResourceLocation THERMOMETER = Helpers.identifier("container/thermometer");
    private static final ResourceLocation THERMOMETER_INDICATOR = Helpers.identifier("container/thermometer_indicator");

    public FireboxScreen(FireboxContainer container, Inventory playerInventory, Component name) {
        super(container, playerInventory, name, TEXTURE);
        this.inventoryLabelY += 36;
        this.imageHeight += 36;
    }

    @Override
    protected void renderBg(GuiGraphics graphics, float partialTicks, int mouseX, int mouseY) {
        super.renderBg(graphics, partialTicks, mouseX, mouseY);
        graphics.blitSprite(THERMOMETER, this.leftPos + 7, this.topPos + 16, 17, 74);
        int temperature = Heat.scaleTemperatureForGui(((FireboxBlockEntity)this.blockEntity).getTemperature());
        if (temperature > 0) {
            graphics.blitSprite(THERMOMETER_INDICATOR, this.leftPos + 8, this.topPos + 76 - temperature, 15, 5);
            long left = ((FireboxBlockEntity)this.blockEntity).getTimeLeft();
            if (left == -1L || ((FireboxBlockEntity)this.blockEntity).getHeatingCount() == 0) {
                graphics.drawString(this.font, (Component)Component.translatable((String)"tfc.tooltip.firebox.no_heat"), this.leftPos + 20, this.topPos + 95, 0x404040, false);
                return;
            }
            if (left > 0L) {
                graphics.drawString(this.font, (Component)Component.translatable((String)"tfc.tooltip.firebox.time_to_heat", (Object[])new Object[]{((FireboxBlockEntity)this.blockEntity).getHeatingCount(), Calendars.CLIENT.getTimeDelta(left)}), this.leftPos + 20, this.topPos + 95, 0x404040, false);
            } else {
                graphics.drawString(this.font, (Component)Component.translatable((String)"tfc.tooltip.firebox.heated", (Object[])new Object[]{((FireboxBlockEntity)this.blockEntity).getHeatingCount()}), this.leftPos + 20, this.topPos + 95, 0x404040, false);
            }
        }
    }

    protected void renderTooltip(GuiGraphics graphics, int mouseX, int mouseY) {
        super.renderTooltip(graphics, mouseX, mouseY);
        MutableComponent text = TFCConfig.CLIENT.heatTooltipStyle.get().formatColored(((FireboxBlockEntity)this.blockEntity).getTemperature());
        if (text != null && RenderHelpers.isInside(mouseX, mouseY, this.leftPos + 8, this.topPos + 76 - 51, 15, 51)) {
            graphics.renderTooltip(this.font, (Component)text, mouseX, mouseY);
        }
    }
}

