/*
 * Decompiled with CFR 0.152.
 */
package net.dries007.tfc.client.screen;

import net.dries007.tfc.client.RenderHelpers;
import net.dries007.tfc.client.screen.BlockEntityScreen;
import net.dries007.tfc.common.blockentities.FirepitBlockEntity;
import net.dries007.tfc.common.component.heat.Heat;
import net.dries007.tfc.common.container.FirepitContainer;
import net.dries007.tfc.config.TFCConfig;
import net.dries007.tfc.util.Helpers;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.player.Inventory;

public class FirepitScreen
extends BlockEntityScreen<FirepitBlockEntity, FirepitContainer> {
    private static final ResourceLocation FIREPIT = Helpers.identifier("textures/gui/fire_pit.png");

    public FirepitScreen(FirepitContainer container, Inventory playerInventory, Component name) {
        super(container, playerInventory, name, FIREPIT);
        this.inventoryLabelY += 20;
        this.imageHeight += 20;
    }

    @Override
    protected void renderBg(GuiGraphics graphics, float partialTicks, int mouseX, int mouseY) {
        super.renderBg(graphics, partialTicks, mouseX, mouseY);
        int temp = Heat.scaleTemperatureForGui(((FirepitBlockEntity)this.blockEntity).getTemperature());
        if (temp > 0) {
            graphics.blit(this.texture, this.leftPos + 30, this.topPos + 76 - Math.min(51, temp), 176, 0, 15, 5);
        }
    }

    protected void renderTooltip(GuiGraphics graphics, int mouseX, int mouseY) {
        MutableComponent text;
        super.renderTooltip(graphics, mouseX, mouseY);
        if (RenderHelpers.isInside(mouseX, mouseY, this.leftPos + 30, this.topPos + 76 - 51, 15, 51) && (text = TFCConfig.CLIENT.heatTooltipStyle.get().formatColored(((FirepitBlockEntity)this.blockEntity).getTemperature())) != null) {
            graphics.renderTooltip(this.font, (Component)text, mouseX, mouseY);
        }
    }
}

