/*
 * Decompiled with CFR 0.152.
 */
package net.dries007.tfc.client.screen;

import net.dries007.tfc.util.Helpers;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.screens.inventory.AbstractContainerScreen;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.FormattedText;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.inventory.AbstractContainerMenu;

public class TFCContainerScreen<C extends AbstractContainerMenu>
extends AbstractContainerScreen<C> {
    public static final ResourceLocation INVENTORY_1x1 = Helpers.identifier("textures/gui/single_inventory.png");
    public static final ResourceLocation INVENTORY_2x2 = Helpers.identifier("textures/gui/small_inventory.png");
    protected final ResourceLocation texture;
    protected final Inventory playerInventory;

    public TFCContainerScreen(C container, Inventory playerInventory, Component name, ResourceLocation texture) {
        super(container, playerInventory, name);
        this.texture = texture;
        this.playerInventory = playerInventory;
    }

    public void render(GuiGraphics graphics, int mouseX, int mouseY, float partialTick) {
        this.renderBackground(graphics, mouseX, mouseY, partialTick);
        super.render(graphics, mouseX, mouseY, partialTick);
        this.renderTooltip(graphics, mouseX, mouseY);
    }

    protected void renderBg(GuiGraphics poseStack, float partialTicks, int mouseX, int mouseY) {
        this.drawDefaultBackground(poseStack);
    }

    protected void drawDefaultBackground(GuiGraphics graphics) {
        graphics.blit(this.texture, this.leftPos, this.topPos, 0, 0.0f, 0.0f, this.imageWidth, this.imageHeight, 256, 256);
    }

    protected void drawLine(GuiGraphics graphics, Component text, TextAlignment alignment, int y) {
        this.drawLine(graphics, text, alignment, 0x404040, y);
    }

    protected void drawLine(GuiGraphics graphics, Component text, TextAlignment alignment, int color, int y) {
        this.drawLine(graphics, text, alignment, color, 0, y);
    }

    protected void drawLine(GuiGraphics graphics, Component text, TextAlignment alignment, int color, int x, int y) {
        if (alignment == TextAlignment.RIGHT) {
            x *= -1;
        }
        if (color == -1) {
            color = 0x404040;
        }
        switch (alignment.ordinal()) {
            case 0: {
                x += 8;
                break;
            }
            case 1: {
                x += (this.imageWidth - this.font.width((FormattedText)text)) / 2;
                break;
            }
            default: {
                x += this.imageWidth - this.font.width((FormattedText)text) - 8;
            }
        }
        graphics.drawString(this.font, text, x, y, color, false);
    }

    public Inventory getPlayerInventory() {
        return this.playerInventory;
    }

    public static enum TextAlignment {
        LEFT,
        CENTER,
        RIGHT;

    }
}

