/*
 * Decompiled with CFR 0.152.
 */
package net.dries007.tfc.client.screen.button;

import net.dries007.tfc.client.ClientHelpers;
import net.dries007.tfc.client.RenderHelpers;
import net.dries007.tfc.client.screen.AnvilPlanScreen;
import net.dries007.tfc.common.recipes.AnvilRecipe;
import net.dries007.tfc.network.ScreenButtonPacket;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.components.Button;
import net.minecraft.client.gui.components.Tooltip;
import net.minecraft.core.HolderLookup;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.chat.Component;
import net.minecraft.network.protocol.common.custom.CustomPacketPayload;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.RecipeHolder;
import net.neoforged.neoforge.network.PacketDistributor;

public class AnvilPlanSelectButton
extends Button {
    private final ItemStack result;
    private final int page;
    private final Component component;
    private int currentPage;

    public AnvilPlanSelectButton(int x, int y, int page, RecipeHolder<AnvilRecipe> recipe, Component tooltip) {
        super(x, y, 18, 18, tooltip, button -> {
            if (button.active) {
                CompoundTag tag = new CompoundTag();
                tag.putString("recipe", recipe.id().toString());
                PacketDistributor.sendToServer((CustomPacketPayload)new ScreenButtonPacket(0, tag), (CustomPacketPayload[])new CustomPacketPayload[0]);
            }
        }, RenderHelpers.NARRATION);
        this.component = tooltip;
        this.setTooltip(Tooltip.create((Component)tooltip));
        this.result = ((AnvilRecipe)recipe.value()).getResultItem((HolderLookup.Provider)ClientHelpers.getLevelOrThrow().registryAccess());
        this.page = page;
        this.currentPage = 0;
    }

    public void setCurrentPage(int currentPage) {
        this.currentPage = currentPage;
        this.active = this.currentPage == this.page;
        this.visible = this.active;
    }

    public Component getComponent() {
        return this.component;
    }

    public void renderWidget(GuiGraphics graphics, int mouseX, int mouseY, float partialTick) {
        if (this.visible) {
            int x = this.getX();
            int y = this.getY();
            graphics.blit(AnvilPlanScreen.BACKGROUND, x, y, 176.0f, 0.0f, this.width, this.height, 256, 256);
            graphics.renderItem(this.result, x + 1, y + 1);
            graphics.renderItemDecorations(Minecraft.getInstance().font, this.result, x + 1, y + 1);
        }
    }
}

