/*
 * Decompiled with CFR 0.152.
 */
package net.dries007.tfc.client.screen.button;

import com.mojang.blaze3d.systems.RenderSystem;
import net.dries007.tfc.client.RenderHelpers;
import net.dries007.tfc.network.ScreenButtonPacket;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.components.Button;
import net.minecraft.client.resources.sounds.SimpleSoundInstance;
import net.minecraft.client.resources.sounds.SoundInstance;
import net.minecraft.client.sounds.SoundManager;
import net.minecraft.core.Holder;
import net.minecraft.network.chat.Component;
import net.minecraft.network.protocol.common.custom.CustomPacketPayload;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.sounds.SoundEvent;
import net.neoforged.neoforge.network.PacketDistributor;

public class KnappingButton
extends Button {
    public int id;
    private final ResourceLocation texture;
    private final Holder<SoundEvent> sound;

    public KnappingButton(int id, int x, int y, int width, int height, ResourceLocation texture, Holder<SoundEvent> sound) {
        this(id, x, y, width, height, texture, sound, button -> {});
    }

    public KnappingButton(int id, int x, int y, int width, int height, ResourceLocation texture, Holder<SoundEvent> sound, Button.OnPress onPress) {
        super(x, y, width, height, (Component)Component.empty(), onPress, RenderHelpers.NARRATION);
        this.id = id;
        this.texture = texture;
        this.sound = sound;
    }

    public void onPress() {
        this.onPress.onPress((Button)this);
        if (this.active) {
            this.visible = false;
            PacketDistributor.sendToServer((CustomPacketPayload)new ScreenButtonPacket(this.id), (CustomPacketPayload[])new CustomPacketPayload[0]);
            this.playDownSound(Minecraft.getInstance().getSoundManager());
        }
    }

    public void playDownSound(SoundManager handler) {
        handler.play((SoundInstance)SimpleSoundInstance.forUI(this.sound, (float)1.0f));
    }

    public void renderWidget(GuiGraphics graphics, int mouseX, int mouseY, float partialTicks) {
        if (this.visible) {
            int x = this.getX();
            int y = this.getY();
            RenderSystem.setShaderTexture((int)0, (ResourceLocation)this.texture);
            this.isHovered = mouseX >= x && mouseY >= y && mouseX < x + this.width && mouseY < y + this.height;
            graphics.blit(this.texture, x, y, 0.0f, 0.0f, 16, 16, 16, 16);
        }
    }

    public ResourceLocation getTexture() {
        return this.texture;
    }
}

