/*
 * Decompiled with CFR 0.152.
 */
package net.dries007.tfc.client.screen.button;

import com.mojang.blaze3d.systems.RenderSystem;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.components.Button;
import net.minecraft.client.sounds.SoundManager;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;

public class LegacyImageButton
extends Button {
    public static final int SIZE = 256;
    protected final ResourceLocation texture;
    protected final int xTexStart;
    protected final int yTexStart;
    protected final int yDiffTex;
    private final boolean silent;

    public LegacyImageButton(int x, int y, int width, int height, int xTexStart, int yTexStart, int yDiffTex, boolean silent, ResourceLocation texture, Button.OnPress onPress, Component label) {
        super(x, y, width, height, label, onPress, DEFAULT_NARRATION);
        this.xTexStart = xTexStart;
        this.yTexStart = yTexStart;
        this.yDiffTex = yDiffTex;
        this.texture = texture;
        this.silent = silent;
    }

    public void renderWidget(GuiGraphics graphics, int mouseX, int mouseY, float partialTick) {
        int vOffset = this.yTexStart;
        if (!this.isActive()) {
            vOffset = this.yTexStart + this.yDiffTex * 2;
        } else if (this.isHoveredOrFocused()) {
            vOffset = this.yTexStart + this.yDiffTex;
        }
        RenderSystem.enableDepthTest();
        graphics.blit(this.texture, this.getX(), this.getY(), (float)this.xTexStart, (float)vOffset, this.width, this.height, 256, 256);
    }

    public void playDownSound(SoundManager handler) {
        if (!this.silent) {
            super.playDownSound(handler);
        }
    }
}

