/*
 * Decompiled with CFR 0.152.
 */
package net.dries007.tfc.client.screen.button;

import net.dries007.tfc.client.ClientHelpers;
import net.dries007.tfc.client.RenderHelpers;
import net.dries007.tfc.network.SwitchInventoryTabPacket;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.components.Button;
import net.minecraft.client.gui.screens.inventory.InventoryScreen;
import net.minecraft.network.chat.Component;
import net.minecraft.network.protocol.common.custom.CustomPacketPayload;
import net.neoforged.neoforge.network.PacketDistributor;

public class PlayerInventoryTabButton
extends Button {
    private final int textureU;
    private final int textureV;
    private final int iconU;
    private final int iconV;
    private int iconX;
    private int iconY;
    private int prevGuiLeft;
    private int prevGuiTop;
    private Runnable tickCallback;

    public PlayerInventoryTabButton(int guiLeft, int guiTop, int xIn, int yIn, int widthIn, int heightIn, int textureU, int textureV, int iconX, int iconY, int iconU, int iconV, SwitchInventoryTabPacket.Tab tab) {
        this(guiLeft, guiTop, xIn, yIn, widthIn, heightIn, textureU, textureV, iconX, iconY, iconU, iconV, button -> PacketDistributor.sendToServer((CustomPacketPayload)new SwitchInventoryTabPacket(tab), (CustomPacketPayload[])new CustomPacketPayload[0]));
    }

    public PlayerInventoryTabButton(int guiLeft, int guiTop, int xIn, int yIn, int widthIn, int heightIn, int textureU, int textureV, int iconX, int iconY, int iconU, int iconV, Button.OnPress onPressIn) {
        super(guiLeft + xIn, guiTop + yIn, widthIn, heightIn, (Component)Component.empty(), onPressIn, RenderHelpers.NARRATION);
        this.prevGuiLeft = guiLeft;
        this.prevGuiTop = guiTop;
        this.textureU = textureU;
        this.textureV = textureV;
        this.iconX = guiLeft + xIn + iconX;
        this.iconY = guiTop + yIn + iconY;
        this.iconU = iconU;
        this.iconV = iconV;
        this.tickCallback = () -> {};
    }

    public PlayerInventoryTabButton setRecipeBookCallback(final InventoryScreen screen) {
        this.tickCallback = new Runnable(){
            boolean recipeBookVisible;
            {
                this.recipeBookVisible = screen.getRecipeBookComponent().isVisible();
            }

            @Override
            public void run() {
                boolean newRecipeBookVisible = screen.getRecipeBookComponent().isVisible();
                if (newRecipeBookVisible != this.recipeBookVisible) {
                    this.recipeBookVisible = newRecipeBookVisible;
                    PlayerInventoryTabButton.this.updateGuiSize(screen.getGuiLeft(), screen.getGuiTop());
                }
            }
        };
        return this;
    }

    public void renderWidget(GuiGraphics graphics, int mouseX, int mouseY, float partialTicks) {
        this.tickCallback.run();
        graphics.blit(ClientHelpers.GUI_ICONS, this.getX(), this.getY(), 0, (float)this.textureU, (float)this.textureV, this.width, this.height, 256, 256);
        graphics.blit(ClientHelpers.GUI_ICONS, this.iconX, this.iconY, 16, 16, (float)this.iconU, (float)this.iconV, 32, 32, 256, 256);
    }

    public void updateGuiSize(int guiLeft, int guiTop) {
        this.setX(this.getX() + guiLeft - this.prevGuiLeft);
        this.setY(this.getY() + guiTop - this.prevGuiTop);
        this.iconX += guiLeft - this.prevGuiLeft;
        this.iconY += guiTop - this.prevGuiTop;
        this.prevGuiLeft = guiLeft;
        this.prevGuiTop = guiTop;
    }
}

