/*
 * Decompiled with CFR 0.152.
 */
package net.dries007.tfc.common;

import java.util.EnumMap;
import java.util.List;
import java.util.Map;
import net.dries007.tfc.client.TFCSounds;
import net.dries007.tfc.util.Helpers;
import net.dries007.tfc.util.registry.HolderHolder;
import net.minecraft.Util;
import net.minecraft.core.Holder;
import net.minecraft.core.registries.Registries;
import net.minecraft.resources.ResourceKey;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.world.item.ArmorItem;
import net.minecraft.world.item.ArmorMaterial;
import net.minecraft.world.item.crafting.Ingredient;
import net.neoforged.neoforge.registries.DeferredRegister;

public final class TFCArmorMaterials {
    public static final DeferredRegister<ArmorMaterial> ARMOR_MATERIALS = DeferredRegister.create((ResourceKey)Registries.ARMOR_MATERIAL, (String)"tfc");
    public static final Id COPPER = TFCArmorMaterials.register("copper", TFCSounds.COPPER_EQUIP, 160, 200, 215, 150, 1, 3, 4, 1, 9, 0.0f, 0.0f);
    public static final Id BISMUTH_BRONZE = TFCArmorMaterials.register("bismuth_bronze", TFCSounds.BISMUTH_BRONZE_EQUIP, 250, 288, 311, 240, 1, 4, 4, 1, 9, 0.0f, 0.0f);
    public static final Id BLACK_BRONZE = TFCArmorMaterials.register("black_bronze", TFCSounds.BLACK_BRONZE_EQUIP, 285, 340, 336, 262, 1, 4, 4, 1, 9, 0.0f, 0.0f);
    public static final Id BRONZE = TFCArmorMaterials.register("bronze", TFCSounds.BRONZE_EQUIP, 270, 315, 323, 251, 1, 4, 4, 1, 9, 0.0f, 0.0f);
    public static final Id WROUGHT_IRON = TFCArmorMaterials.register("wrought_iron", TFCSounds.WROUGHT_IRON_EQUIP, 429, 495, 528, 370, 1, 4, 5, 2, 12, 0.0f, 0.0f);
    public static final Id STEEL = TFCArmorMaterials.register("steel", TFCSounds.STEEL_EQUIP, 520, 600, 640, 440, 2, 5, 6, 2, 12, 1.0f, 0.0f);
    public static final Id BLACK_STEEL = TFCArmorMaterials.register("black_steel", TFCSounds.BLACK_STEEL_EQUIP, 650, 750, 800, 550, 2, 5, 6, 2, 17, 2.0f, 0.05f);
    public static final Id BLUE_STEEL = TFCArmorMaterials.register("blue_steel", TFCSounds.BLUE_STEEL_EQUIP, 860, 960, 1088, 748, 3, 6, 8, 3, 23, 3.0f, 0.1f);
    public static final Id RED_STEEL = TFCArmorMaterials.register("red_steel", TFCSounds.RED_STEEL_EQUIP, 884, 1020, 1010, 715, 3, 6, 8, 3, 23, 3.0f, 0.1f);

    private static Id register(String name, HolderHolder<SoundEvent> equipSound, int feetDamage, int legDamage, int chestDamage, int headDamage, int feetReduction, int legReduction, int chestReduction, int headReduction, int enchantability, float toughness, float knockbackResistance) {
        return new Id((Holder<ArmorMaterial>)ARMOR_MATERIALS.register(name, () -> new ArmorMaterial((Map)Util.make(new EnumMap(ArmorItem.Type.class), map -> {
            map.put(ArmorItem.Type.BOOTS, feetReduction);
            map.put(ArmorItem.Type.LEGGINGS, legReduction);
            map.put(ArmorItem.Type.CHESTPLATE, chestReduction);
            map.put(ArmorItem.Type.HELMET, headReduction);
            map.put(ArmorItem.Type.BODY, chestReduction);
        }), enchantability, equipSound.holder(), () -> Ingredient.EMPTY, List.of(new ArmorMaterial.Layer(Helpers.identifier(name))), toughness, knockbackResistance)), feetDamage, legDamage, chestDamage, headDamage);
    }

    public record Id(Holder<ArmorMaterial> holder, int feetDamage, int legDamage, int chestDamage, int headDamage) {
    }
}

