/*
 * Decompiled with CFR 0.152.
 */
package net.dries007.tfc.common;

import java.util.function.Supplier;
import net.dries007.tfc.mixin.accessor.ChunkAccessAccessor;
import net.dries007.tfc.util.registry.RegistryHolder;
import net.dries007.tfc.util.tracker.WorldTracker;
import net.dries007.tfc.world.ChunkGeneratorExtension;
import net.dries007.tfc.world.chunkdata.ChunkData;
import net.dries007.tfc.world.chunkdata.ChunkDataGenerator;
import net.minecraft.core.HolderLookup;
import net.minecraft.core.Registry;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelHeightAccessor;
import net.minecraft.world.level.chunk.ChunkAccess;
import net.minecraft.world.level.chunk.ChunkGenerator;
import net.neoforged.neoforge.attachment.AttachmentType;
import net.neoforged.neoforge.attachment.IAttachmentHolder;
import net.neoforged.neoforge.attachment.IAttachmentSerializer;
import net.neoforged.neoforge.registries.DeferredHolder;
import net.neoforged.neoforge.registries.DeferredRegister;
import net.neoforged.neoforge.registries.NeoForgeRegistries;

public final class TFCAttachments {
    public static final DeferredRegister<AttachmentType<?>> TYPES = DeferredRegister.create((Registry)NeoForgeRegistries.ATTACHMENT_TYPES, (String)"tfc");
    public static final Id<ChunkData> CHUNK_DATA = TFCAttachments.register("chunk_data", () -> AttachmentType.builder(holder -> {
        ChunkDataGenerator chunkDataGenerator;
        ServerLevel level;
        ChunkGenerator patt1$temp;
        ChunkAccess chunk = (ChunkAccess)holder;
        LevelHeightAccessor patt0$temp = ((ChunkAccessAccessor)chunk).accessor$getLevelHeightAccessor();
        if (patt0$temp instanceof ServerLevel && (patt1$temp = (level = (ServerLevel)patt0$temp).getChunkSource().getGenerator()) instanceof ChunkGeneratorExtension) {
            ChunkGeneratorExtension ex = (ChunkGeneratorExtension)patt1$temp;
            chunkDataGenerator = ex.chunkDataGenerator();
        } else {
            chunkDataGenerator = null;
        }
        ChunkDataGenerator generator = chunkDataGenerator;
        return new ChunkData(generator, chunk.getPos());
    }).serialize((IAttachmentSerializer)new IAttachmentSerializer<CompoundTag, ChunkData>(){

        public ChunkData read(IAttachmentHolder holder, CompoundTag tag, HolderLookup.Provider provider) {
            ChunkData data = (ChunkData)holder.getData(CHUNK_DATA);
            data.deserializeNBT(tag);
            return data;
        }

        public CompoundTag write(ChunkData data, HolderLookup.Provider provider) {
            return data.serializeNBT();
        }
    }).build());
    public static final Id<WorldTracker> WORLD_TRACKER = TFCAttachments.register("world", () -> AttachmentType.builder(holder -> new WorldTracker((Level)holder)).serialize((IAttachmentSerializer)new IAttachmentSerializer<CompoundTag, WorldTracker>(){

        public WorldTracker read(IAttachmentHolder holder, CompoundTag tag, HolderLookup.Provider provider) {
            WorldTracker tracker = (WorldTracker)holder.getData(WORLD_TRACKER);
            tracker.deserializeNBT(tag);
            return tracker;
        }

        public CompoundTag write(WorldTracker tracker, HolderLookup.Provider provider) {
            return tracker.serializeNBT();
        }
    }).build());

    private static <T> Id<T> register(String name, Supplier<AttachmentType<T>> type) {
        return new Id(TYPES.register(name, type));
    }

    public record Id<T>(DeferredHolder<AttachmentType<?>, AttachmentType<T>> holder) implements RegistryHolder<AttachmentType<?>, AttachmentType<T>>
    {
    }
}

