/*
 * Decompiled with CFR 0.152.
 */
package net.dries007.tfc.common;

import java.util.Map;
import java.util.function.Supplier;
import java.util.stream.Stream;
import net.dries007.tfc.common.blocks.DecorationBlockHolder;
import net.dries007.tfc.common.blocks.OreDeposit;
import net.dries007.tfc.common.blocks.TFCBlocks;
import net.dries007.tfc.common.blocks.crop.Crop;
import net.dries007.tfc.common.blocks.plant.Plant;
import net.dries007.tfc.common.blocks.plant.coral.Coral;
import net.dries007.tfc.common.blocks.plant.fruit.FruitBlocks;
import net.dries007.tfc.common.blocks.rock.Ore;
import net.dries007.tfc.common.blocks.rock.Rock;
import net.dries007.tfc.common.blocks.rock.RockCategory;
import net.dries007.tfc.common.blocks.soil.SandBlockType;
import net.dries007.tfc.common.blocks.soil.SoilBlockType;
import net.dries007.tfc.common.blocks.wood.Wood;
import net.dries007.tfc.common.component.food.FoodCapability;
import net.dries007.tfc.common.entities.TFCEntities;
import net.dries007.tfc.common.fluids.TFCFluids;
import net.dries007.tfc.common.items.Food;
import net.dries007.tfc.common.items.HideItemType;
import net.dries007.tfc.common.items.TFCItems;
import net.dries007.tfc.util.Metal;
import net.minecraft.core.registries.Registries;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceKey;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.item.CreativeModeTab;
import net.minecraft.world.item.DyeColor;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.SpawnEggItem;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.material.Fluid;
import net.neoforged.fml.loading.FMLEnvironment;
import net.neoforged.neoforge.event.BuildCreativeModeTabContentsEvent;
import net.neoforged.neoforge.registries.DeferredHolder;
import net.neoforged.neoforge.registries.DeferredRegister;

public final class TFCCreativeTabs {
    public static final DeferredRegister<CreativeModeTab> CREATIVE_TABS = DeferredRegister.create((ResourceKey)Registries.CREATIVE_MODE_TAB, (String)"tfc");
    public static final Id EARTH = TFCCreativeTabs.register("earth", () -> new ItemStack((ItemLike)TFCBlocks.ROCK_BLOCKS.get(Rock.QUARTZITE).get((Object)Rock.BlockType.RAW)), TFCCreativeTabs::fillEarthTab);
    public static final Id ORES = TFCCreativeTabs.register("ores", () -> new ItemStack((ItemLike)TFCItems.GRADED_ORES.get((Object)Ore.NATIVE_COPPER).get((Object)Ore.Grade.NORMAL)), TFCCreativeTabs::fillOresTab);
    public static final Id ROCKS = TFCCreativeTabs.register("rock", () -> new ItemStack((ItemLike)TFCBlocks.ROCK_BLOCKS.get(Rock.ANDESITE).get((Object)Rock.BlockType.RAW)), TFCCreativeTabs::fillRocksTab);
    public static final Id METAL = TFCCreativeTabs.register("metals", () -> new ItemStack((ItemLike)TFCItems.METAL_ITEMS.get(Metal.WROUGHT_IRON).get((Object)Metal.ItemType.INGOT)), TFCCreativeTabs::fillMetalTab);
    public static final Id WOOD = TFCCreativeTabs.register("wood", () -> new ItemStack((ItemLike)TFCBlocks.WOODS.get(Wood.DOUGLAS_FIR).get((Object)Wood.BlockType.LOG)), TFCCreativeTabs::fillWoodTab);
    public static final Id FOOD = TFCCreativeTabs.register("food", () -> new ItemStack((ItemLike)TFCItems.FOOD.get((Object)Food.RED_APPLE)), TFCCreativeTabs::fillFoodTab);
    public static final Id FLORA = TFCCreativeTabs.register("flora", () -> new ItemStack((ItemLike)TFCBlocks.PLANTS.get(Plant.GOLDENROD)), TFCCreativeTabs::fillPlantsTab);
    public static final Id DECORATIONS = TFCCreativeTabs.register("decorations", () -> new ItemStack((ItemLike)TFCBlocks.ALABASTER_BRICKS.get(DyeColor.CYAN)), TFCCreativeTabs::fillDecorationsTab);
    public static final Id MISC = TFCCreativeTabs.register("misc", () -> new ItemStack((ItemLike)TFCItems.FIRESTARTER), TFCCreativeTabs::fillMiscTab);

    public static Stream<CreativeModeTab.DisplayItemsGenerator> generators() {
        return Stream.of(EARTH, ORES, ROCKS, METAL, WOOD, FOOD, FLORA, DECORATIONS, MISC).map(holder -> holder.generator);
    }

    public static void setAllTabContentAsNonDecaying(BuildCreativeModeTabContentsEvent event) {
        FoodCapability.setTransientNonDecaying(event.getTab().getIconItem());
        event.getParentEntries().forEach(FoodCapability::setTransientNonDecaying);
        event.getSearchEntries().forEach(FoodCapability::setTransientNonDecaying);
    }

    private static void fillEarthTab(CreativeModeTab.ItemDisplayParameters parameters, CreativeModeTab.Output out) {
        for (SoilBlockType.Variant variant : SoilBlockType.Variant.values()) {
            for (SoilBlockType type2 : SoilBlockType.VALUES) {
                TFCCreativeTabs.accept(out, TFCBlocks.SOIL, type2, variant);
                if (type2 != SoilBlockType.MUD_BRICKS) continue;
                TFCCreativeTabs.accept(out, TFCBlocks.MUD_BRICK_DECORATIONS.get(variant));
            }
        }
        out.accept(TFCBlocks.SMOOTH_MUD_BRICKS);
        out.accept(TFCBlocks.TREE_ROOTS);
        out.accept(TFCBlocks.PEAT);
        out.accept(TFCBlocks.PEAT_GRASS);
        out.accept(TFCBlocks.WHITE_KAOLIN_CLAY);
        out.accept(TFCBlocks.PINK_KAOLIN_CLAY);
        out.accept(TFCBlocks.RED_KAOLIN_CLAY);
        out.accept(TFCBlocks.KAOLIN_CLAY_GRASS);
        out.accept(TFCBlocks.HARDENED_CLAY);
        TFCBlocks.GROUNDCOVER.forEach((type, reg) -> {
            if (type.getVanillaItem() == null) {
                out.accept((ItemLike)reg);
            } else {
                out.accept(type.getVanillaItem());
            }
        });
        TFCBlocks.SMALL_ORES.values().forEach(arg_0 -> ((CreativeModeTab.Output)out).accept(arg_0));
        TFCItems.GEMS.values().forEach(arg_0 -> ((CreativeModeTab.Output)out).accept(arg_0));
        for (Enum enum_ : SandBlockType.values()) {
            TFCCreativeTabs.accept(out, TFCBlocks.SAND, enum_);
            TFCBlocks.SANDSTONE.get(enum_).values().forEach(arg_0 -> ((CreativeModeTab.Output)out).accept(arg_0));
            TFCBlocks.SANDSTONE_DECORATIONS.get(enum_).values().forEach(reg -> TFCCreativeTabs.accept(out, reg));
        }
        out.accept((ItemLike)Blocks.ICE);
        out.accept(TFCBlocks.SEA_ICE);
        out.accept((ItemLike)Blocks.PACKED_ICE);
        out.accept((ItemLike)Blocks.BLUE_ICE);
        TFCBlocks.MAGMA_BLOCKS.values().forEach(arg_0 -> ((CreativeModeTab.Output)out).accept(arg_0));
        for (Enum enum_ : Crop.values()) {
            TFCCreativeTabs.accept(out, TFCBlocks.WILD_CROPS, enum_);
            if (enum_ == Crop.PUMPKIN) {
                out.accept(TFCBlocks.PUMPKIN);
            } else if (enum_ == Crop.MELON) {
                out.accept(TFCBlocks.MELON);
            }
            TFCCreativeTabs.accept(out, TFCItems.CROP_SEEDS, enum_);
        }
        TFCBlocks.SPREADING_BUSHES.values().forEach(arg_0 -> ((CreativeModeTab.Output)out).accept(arg_0));
        TFCBlocks.STATIONARY_BUSHES.values().forEach(arg_0 -> ((CreativeModeTab.Output)out).accept(arg_0));
        out.accept(TFCBlocks.CRANBERRY_BUSH);
        for (Enum enum_ : FruitBlocks.Tree.values()) {
            TFCCreativeTabs.accept(out, TFCBlocks.FRUIT_TREE_SAPLINGS, enum_);
            TFCCreativeTabs.accept(out, TFCBlocks.FRUIT_TREE_LEAVES, enum_);
        }
        out.accept(TFCBlocks.BANANA_SAPLING);
        out.accept(TFCBlocks.CALCITE);
        out.accept(TFCBlocks.ICICLE);
        for (Enum enum_ : Coral.values()) {
            TFCBlocks.CORAL.get(enum_).values().forEach(arg_0 -> ((CreativeModeTab.Output)out).accept(arg_0));
            TFCCreativeTabs.accept(out, TFCItems.CORAL_FANS, enum_);
            TFCCreativeTabs.accept(out, TFCItems.DEAD_CORAL_FANS, enum_);
        }
    }

    private static void fillMetalTab(CreativeModeTab.ItemDisplayParameters parameters, CreativeModeTab.Output out) {
        for (Metal metal : Metal.values()) {
            for (Metal.BlockType blockType : new Metal.BlockType[]{Metal.BlockType.ANVIL, Metal.BlockType.BLOCK, Metal.BlockType.EXPOSED_BLOCK, Metal.BlockType.WEATHERED_BLOCK, Metal.BlockType.OXIDIZED_BLOCK, Metal.BlockType.BLOCK_SLAB, Metal.BlockType.EXPOSED_BLOCK_SLAB, Metal.BlockType.WEATHERED_BLOCK_SLAB, Metal.BlockType.OXIDIZED_BLOCK_SLAB, Metal.BlockType.BLOCK_STAIRS, Metal.BlockType.EXPOSED_BLOCK_STAIRS, Metal.BlockType.WEATHERED_BLOCK_STAIRS, Metal.BlockType.OXIDIZED_BLOCK_STAIRS, Metal.BlockType.GRATE, Metal.BlockType.EXPOSED_GRATE, Metal.BlockType.WEATHERED_GRATE, Metal.BlockType.OXIDIZED_GRATE, Metal.BlockType.BARS, Metal.BlockType.CHAIN, Metal.BlockType.TRAPDOOR, Metal.BlockType.LAMP}) {
                TFCCreativeTabs.accept(out, TFCBlocks.METALS, metal, blockType);
            }
            TFCCreativeTabs.accept(out, TFCItems.METAL_ITEMS, metal, Metal.ItemType.UNFINISHED_LAMP);
            if (metal == Metal.BRONZE) {
                out.accept(TFCBlocks.BRONZE_BELL);
            } else if (metal == Metal.BRASS) {
                out.accept(TFCBlocks.BRASS_BELL);
                out.accept((ItemLike)TFCItems.BRASS_MECHANISMS);
                out.accept((ItemLike)TFCItems.JACKS);
            } else if (metal == Metal.GOLD) {
                out.accept((ItemLike)Blocks.BELL);
            } else if (metal == Metal.RED_STEEL) {
                out.accept((ItemLike)TFCItems.RED_STEEL_BUCKET);
            } else if (metal == Metal.BLUE_STEEL) {
                out.accept((ItemLike)TFCItems.BLUE_STEEL_BUCKET);
            } else if (metal == Metal.WROUGHT_IRON) {
                out.accept((ItemLike)TFCItems.WROUGHT_IRON_GRILL);
            } else if (metal == Metal.STEEL) {
                out.accept(TFCBlocks.STEEL_PIPE);
                out.accept(TFCBlocks.STEEL_PUMP);
            }
            for (Enum enum_ : new Metal.ItemType[]{Metal.ItemType.INGOT, Metal.ItemType.DOUBLE_INGOT, Metal.ItemType.SHEET, Metal.ItemType.DOUBLE_SHEET, Metal.ItemType.ROD, Metal.ItemType.TUYERE, Metal.ItemType.PICKAXE, Metal.ItemType.PROPICK, Metal.ItemType.AXE, Metal.ItemType.SHOVEL, Metal.ItemType.HOE, Metal.ItemType.CHISEL, Metal.ItemType.HAMMER, Metal.ItemType.SAW, Metal.ItemType.KNIFE, Metal.ItemType.SCYTHE, Metal.ItemType.JAVELIN, Metal.ItemType.SWORD, Metal.ItemType.MACE, Metal.ItemType.FISHING_ROD, Metal.ItemType.SHEARS, Metal.ItemType.HELMET, Metal.ItemType.CHESTPLATE, Metal.ItemType.GREAVES, Metal.ItemType.BOOTS, Metal.ItemType.SHIELD, Metal.ItemType.HORSE_ARMOR, Metal.ItemType.PICKAXE_HEAD, Metal.ItemType.PROPICK_HEAD, Metal.ItemType.AXE_HEAD, Metal.ItemType.SHOVEL_HEAD, Metal.ItemType.HOE_HEAD, Metal.ItemType.CHISEL_HEAD, Metal.ItemType.HAMMER_HEAD, Metal.ItemType.SAW_BLADE, Metal.ItemType.KNIFE_BLADE, Metal.ItemType.SCYTHE_BLADE, Metal.ItemType.JAVELIN_HEAD, Metal.ItemType.SWORD_BLADE, Metal.ItemType.MACE_HEAD, Metal.ItemType.FISH_HOOK, Metal.ItemType.UNFINISHED_HELMET, Metal.ItemType.UNFINISHED_CHESTPLATE, Metal.ItemType.UNFINISHED_GREAVES, Metal.ItemType.UNFINISHED_BOOTS}) {
                TFCCreativeTabs.accept(out, TFCItems.METAL_ITEMS, metal, enum_);
            }
        }
    }

    private static void fillOresTab(CreativeModeTab.ItemDisplayParameters parameters, CreativeModeTab.Output out) {
        out.accept((ItemLike)TFCItems.RAW_IRON_BLOOM);
        out.accept((ItemLike)TFCItems.REFINED_IRON_BLOOM);
        out.accept(TFCBlocks.LIGNITE);
        out.accept(TFCBlocks.BITUMINOUS_COAL);
        out.accept(TFCBlocks.HALITE);
        for (Ore ore : Ore.values()) {
            if (!ore.isGraded()) continue;
            TFCCreativeTabs.accept(out, TFCItems.GRADED_ORES, ore, Ore.Grade.POOR);
            TFCCreativeTabs.accept(out, TFCBlocks.SMALL_ORES, ore);
            TFCCreativeTabs.accept(out, TFCItems.GRADED_ORES, ore, Ore.Grade.NORMAL);
            TFCCreativeTabs.accept(out, TFCItems.GRADED_ORES, ore, Ore.Grade.RICH);
        }
        for (Ore ore : Ore.values()) {
            if (ore.isGraded()) continue;
            TFCCreativeTabs.accept(out, TFCItems.ORES, ore);
        }
        for (Enum enum_ : OreDeposit.values()) {
            TFCBlocks.ORE_DEPOSITS.values().forEach(arg_0 -> TFCCreativeTabs.lambda$fillOresTab$12(out, (OreDeposit)enum_, arg_0));
        }
        for (Enum enum_ : Ore.values()) {
            if (((Ore)enum_).isGraded()) {
                TFCBlocks.GRADED_ORES.values().forEach(arg_0 -> TFCCreativeTabs.lambda$fillOresTab$13((Ore)enum_, out, arg_0));
                continue;
            }
            TFCBlocks.ORES.values().forEach(arg_0 -> TFCCreativeTabs.lambda$fillOresTab$14(out, (Ore)enum_, arg_0));
        }
    }

    private static void fillRocksTab(CreativeModeTab.ItemDisplayParameters parameters, CreativeModeTab.Output out) {
        for (Rock rock : Rock.VALUES) {
            for (Enum enum_ : new Rock.BlockType[]{Rock.BlockType.HARDENED, Rock.BlockType.RAW, Rock.BlockType.PRESSURE_PLATE, Rock.BlockType.BUTTON, Rock.BlockType.SPIKE, Rock.BlockType.COBBLE, Rock.BlockType.MOSSY_COBBLE, Rock.BlockType.BRICKS, Rock.BlockType.CRACKED_BRICKS, Rock.BlockType.MOSSY_BRICKS, Rock.BlockType.SMOOTH, Rock.BlockType.CHISELED, Rock.BlockType.AQUEDUCT, Rock.BlockType.GRAVEL, Rock.BlockType.LOOSE, Rock.BlockType.MOSSY_LOOSE}) {
                TFCCreativeTabs.accept(out, TFCBlocks.ROCK_BLOCKS, rock, enum_);
                if (!((Rock.BlockType)enum_).hasVariants()) continue;
                TFCCreativeTabs.accept(out, TFCBlocks.ROCK_DECORATIONS.get(rock).get(enum_));
            }
            TFCCreativeTabs.accept(out, TFCItems.BRICKS, rock);
        }
        for (Enum enum_ : RockCategory.ItemType.values()) {
            for (RockCategory rockCategory : RockCategory.values()) {
                TFCCreativeTabs.accept(out, TFCItems.ROCK_TOOLS, rockCategory, enum_);
            }
        }
    }

    private static void fillFoodTab(CreativeModeTab.ItemDisplayParameters parameters, CreativeModeTab.Output out) {
        TFCItems.FOOD.values().forEach(arg_0 -> ((CreativeModeTab.Output)out).accept(arg_0));
        TFCItems.SOUPS.values().forEach(arg_0 -> ((CreativeModeTab.Output)out).accept(arg_0));
        TFCItems.SALADS.values().forEach(arg_0 -> ((CreativeModeTab.Output)out).accept(arg_0));
        out.accept((ItemLike)TFCItems.EMPTY_JAR);
        out.accept((ItemLike)TFCItems.EMPTY_JAR_WITH_LID);
        for (Food food : Food.values()) {
            TFCCreativeTabs.accept(out, TFCItems.FRUIT_PRESERVES, food);
            TFCCreativeTabs.accept(out, TFCItems.UNSEALED_FRUIT_PRESERVES, food);
            TFCCreativeTabs.accept(out, TFCItems.JAM, food);
        }
    }

    private static void fillMiscTab(CreativeModeTab.ItemDisplayParameters parameters, CreativeModeTab.Output out) {
        if (!FMLEnvironment.production) {
            // empty if block
        }
        out.accept((ItemLike)TFCItems.FIRESTARTER);
        out.accept((ItemLike)TFCItems.FLINT_AND_PYRITE);
        out.accept((ItemLike)Items.FLINT_AND_STEEL);
        out.accept((ItemLike)TFCItems.SOOT);
        out.accept((ItemLike)TFCItems.SANDPAPER);
        out.accept((ItemLike)TFCItems.BONE_NEEDLE);
        out.accept((ItemLike)TFCItems.BLANK_DISC);
        out.accept((ItemLike)TFCItems.BRASS_MECHANISMS);
        out.accept((ItemLike)TFCItems.BURLAP_CLOTH);
        out.accept((ItemLike)TFCItems.SILK_CLOTH);
        out.accept((ItemLike)TFCItems.WOOL_CLOTH);
        out.accept((ItemLike)TFCItems.WOOL);
        out.accept((ItemLike)TFCItems.WOOL_YARN);
        out.accept((ItemLike)TFCItems.SPINDLE);
        out.accept((ItemLike)TFCItems.COMPOST);
        out.accept((ItemLike)TFCItems.ROTTEN_COMPOST);
        out.accept((ItemLike)TFCItems.PURE_NITROGEN);
        out.accept((ItemLike)TFCItems.PURE_POTASSIUM);
        out.accept((ItemLike)TFCItems.PURE_PHOSPHORUS);
        out.accept((ItemLike)TFCItems.DAUB);
        out.accept((ItemLike)TFCItems.DIRTY_JUTE_NET);
        out.accept((ItemLike)TFCItems.CACTUS_WOOD);
        out.accept((ItemLike)TFCItems.DRIED_CACTUS_WOOD);
        out.accept((ItemLike)TFCItems.FIRE_CLAY);
        out.accept((ItemLike)TFCItems.KAOLIN_CLAY);
        out.accept((ItemLike)TFCItems.GLUE);
        out.accept((ItemLike)TFCItems.GOAT_HORN);
        out.accept((ItemLike)TFCItems.ALFALFA);
        out.accept((ItemLike)TFCItems.CANOLA);
        out.accept((ItemLike)TFCItems.JUTE);
        out.accept((ItemLike)TFCItems.JUTE_FIBER);
        out.accept((ItemLike)TFCItems.OLIVE_PASTE);
        out.accept((ItemLike)TFCItems.CANOLA_PASTE);
        out.accept((ItemLike)TFCItems.JUTE_NET);
        out.accept((ItemLike)TFCItems.HANDSTONE);
        out.accept((ItemLike)TFCItems.MORTAR);
        out.accept((ItemLike)TFCItems.PAPYRUS);
        out.accept((ItemLike)TFCItems.PAPYRUS_STRIP);
        out.accept((ItemLike)TFCItems.SOAKED_PAPYRUS_STRIP);
        out.accept((ItemLike)TFCItems.UNREFINED_PAPER);
        out.accept((ItemLike)TFCItems.STICK_BUNCH);
        out.accept((ItemLike)TFCItems.STICK_BUNDLE);
        out.accept((ItemLike)Items.BOWL);
        out.accept((ItemLike)TFCItems.STRAW);
        out.accept((ItemLike)TFCItems.WROUGHT_IRON_GRILL);
        out.accept((ItemLike)TFCItems.ARIDISOL_MUD_BRICK);
        out.accept((ItemLike)TFCItems.OXISOL_MUD_BRICK);
        out.accept((ItemLike)TFCItems.FLUVISOL_MUD_BRICK);
        out.accept((ItemLike)TFCItems.ENTISOL_MUD_BRICK);
        out.accept((ItemLike)TFCItems.ANDISOL_MUD_BRICK);
        out.accept((ItemLike)TFCItems.MOLLISOL_MUD_BRICK);
        out.accept((ItemLike)TFCItems.ALFISOL_MUD_BRICK);
        out.accept((ItemLike)TFCItems.PODZOL_MUD_BRICK);
        TFCItems.POWDERS.values().forEach(arg_0 -> ((CreativeModeTab.Output)out).accept(arg_0));
        TFCItems.ORE_POWDERS.values().forEach(arg_0 -> ((CreativeModeTab.Output)out).accept(arg_0));
        out.accept((ItemLike)TFCItems.BLUBBER);
        for (HideItemType hideItemType : HideItemType.values()) {
            TFCItems.HIDES.get((Object)hideItemType).values().forEach(arg_0 -> ((CreativeModeTab.Output)out).accept(arg_0));
        }
        out.accept((ItemLike)TFCItems.TREATED_HIDE);
        out.accept((ItemLike)Items.INK_SAC);
        out.accept((ItemLike)Items.GLOW_INK_SAC);
        out.accept((ItemLike)TFCItems.GLOW_ARROW);
        out.accept((ItemLike)TFCItems.ALABASTER_BRICK);
        out.accept((ItemLike)TFCItems.UNFIRED_BRICK);
        out.accept((ItemLike)Items.BRICK);
        out.accept((ItemLike)TFCItems.UNFIRED_FIRE_BRICK);
        out.accept((ItemLike)TFCItems.FIRE_BRICK);
        out.accept((ItemLike)TFCItems.UNFIRED_CRUCIBLE);
        out.accept(TFCBlocks.CRUCIBLE);
        out.accept((ItemLike)TFCItems.UNFIRED_FLOWER_POT);
        out.accept((ItemLike)Items.FLOWER_POT);
        out.accept((ItemLike)TFCItems.UNFIRED_BOWL);
        out.accept(TFCBlocks.CERAMIC_BOWL);
        out.accept((ItemLike)TFCItems.UNFIRED_PAN);
        out.accept((ItemLike)TFCItems.EMPTY_PAN);
        out.accept((ItemLike)TFCItems.UNFIRED_SPINDLE_HEAD);
        out.accept((ItemLike)TFCItems.SPINDLE_HEAD);
        out.accept((ItemLike)TFCItems.UNFIRED_POT);
        out.accept((ItemLike)TFCItems.POT);
        out.accept((ItemLike)TFCItems.UNFIRED_VESSEL);
        out.accept((ItemLike)TFCItems.VESSEL);
        out.accept((ItemLike)TFCItems.UNFIRED_LARGE_VESSEL);
        out.accept(TFCBlocks.LARGE_VESSEL);
        out.accept((ItemLike)TFCItems.UNFIRED_JUG);
        for (HideItemType hideItemType : DyeColor.values()) {
            TFCCreativeTabs.accept(out, TFCItems.UNFIRED_GLAZED_VESSELS, hideItemType);
            TFCCreativeTabs.accept(out, TFCItems.GLAZED_VESSELS, hideItemType);
            TFCCreativeTabs.accept(out, TFCItems.UNFIRED_GLAZED_LARGE_VESSELS, hideItemType);
            TFCCreativeTabs.accept(out, TFCBlocks.GLAZED_LARGE_VESSELS, hideItemType);
        }
        for (Enum enum_ : Metal.ItemType.values()) {
            TFCCreativeTabs.accept(out, TFCItems.UNFIRED_MOLDS, enum_);
            TFCCreativeTabs.accept(out, TFCItems.MOLDS, enum_);
            if (enum_ != Metal.ItemType.INGOT) continue;
            out.accept((ItemLike)TFCItems.UNFIRED_FIRE_INGOT_MOLD);
            out.accept((ItemLike)TFCItems.FIRE_INGOT_MOLD);
        }
        out.accept((ItemLike)TFCItems.UNFIRED_BELL_MOLD);
        out.accept((ItemLike)TFCItems.BELL_MOLD);
        out.accept((ItemLike)TFCItems.UNFIRED_CHANNEL);
        out.accept((ItemLike)TFCItems.UNFIRED_MOLD_TABLE);
        out.accept(TFCBlocks.CHANNEL);
        out.accept(TFCBlocks.MOLD_TABLE);
        out.accept((ItemLike)TFCItems.WOODEN_BUCKET);
        out.accept((ItemLike)TFCItems.JUG);
        out.accept((ItemLike)TFCItems.UNFIRED_BLOWPIPE);
        out.accept((ItemLike)TFCItems.CERAMIC_BLOWPIPE);
        out.accept((ItemLike)TFCItems.CERAMIC_BLOWPIPE_WITH_GLASS);
        out.accept((ItemLike)TFCItems.BLOWPIPE);
        out.accept((ItemLike)TFCItems.BLOWPIPE_WITH_GLASS);
        out.accept((ItemLike)TFCItems.GEM_SAW);
        out.accept((ItemLike)TFCItems.JACKS);
        out.accept((ItemLike)TFCItems.PADDLE);
        out.accept((ItemLike)TFCItems.SILICA_GLASS_BATCH);
        out.accept((ItemLike)TFCItems.HEMATITIC_GLASS_BATCH);
        out.accept((ItemLike)TFCItems.OLIVINE_GLASS_BATCH);
        out.accept((ItemLike)TFCItems.VOLCANIC_GLASS_BATCH);
        out.accept((ItemLike)TFCItems.LAMP_GLASS);
        out.accept((ItemLike)TFCItems.LENS);
        out.accept((ItemLike)TFCItems.SILICA_GLASS_BOTTLE);
        out.accept((ItemLike)TFCItems.HEMATITIC_GLASS_BOTTLE);
        out.accept((ItemLike)TFCItems.OLIVINE_GLASS_BOTTLE);
        out.accept((ItemLike)TFCItems.VOLCANIC_GLASS_BOTTLE);
        out.accept((ItemLike)TFCItems.EMPTY_JAR);
        out.accept((ItemLike)TFCItems.EMPTY_JAR_WITH_LID);
        out.accept((ItemLike)TFCItems.JAR_LID);
        TFCItems.WINDMILL_BLADES.values().forEach(arg_0 -> ((CreativeModeTab.Output)out).accept(arg_0));
        out.accept((ItemLike)TFCItems.RUSTIC_WINDMILL_BLADE);
        out.accept((ItemLike)TFCItems.LATTICE_WINDMILL_BLADE);
        TFCFluids.FLUIDS.getEntries().forEach(fluid -> out.accept((ItemLike)((Fluid)fluid.value()).getBucket()));
        TFCItems.FRESHWATER_FISH_BUCKETS.values().forEach(arg_0 -> ((CreativeModeTab.Output)out).accept(arg_0));
        out.accept((ItemLike)TFCItems.COD_BUCKET);
        out.accept((ItemLike)TFCItems.JELLYFISH_BUCKET);
        out.accept((ItemLike)TFCItems.TROPICAL_FISH_BUCKET);
        out.accept((ItemLike)TFCItems.PUFFERFISH_BUCKET);
        TFCEntities.ENTITIES.getEntries().forEach(entity -> {
            SpawnEggItem item = SpawnEggItem.byId((EntityType)((EntityType)entity.value()));
            if (item != null) {
                out.accept((ItemLike)item);
            }
        });
    }

    private static void fillDecorationsTab(CreativeModeTab.ItemDisplayParameters parameters, CreativeModeTab.Output out) {
        out.accept(TFCBlocks.WATTLE);
        out.accept(TFCBlocks.UNSTAINED_WATTLE);
        TFCBlocks.STAINED_WATTLE.values().forEach(arg_0 -> ((CreativeModeTab.Output)out).accept(arg_0));
        out.accept(TFCBlocks.THATCH);
        out.accept(TFCBlocks.THATCH_BED);
        out.accept(TFCBlocks.FIREPIT);
        out.accept(TFCBlocks.GRILL);
        out.accept(TFCBlocks.POT);
        out.accept(TFCBlocks.BELLOWS);
        out.accept(TFCBlocks.POWDERKEG);
        out.accept(TFCBlocks.BARREL_RACK);
        out.accept(TFCBlocks.CERAMIC_BOWL);
        out.accept(TFCBlocks.QUERN);
        out.accept((ItemLike)TFCItems.HANDSTONE);
        out.accept(TFCBlocks.CRANKSHAFT);
        out.accept(TFCBlocks.TRIP_HAMMER);
        out.accept(TFCBlocks.CRUCIBLE);
        out.accept(TFCBlocks.COMPOSTER);
        out.accept(TFCBlocks.BLOOMERY);
        out.accept(TFCBlocks.BLAST_FURNACE);
        out.accept(TFCBlocks.NEST_BOX);
        out.accept(TFCBlocks.MELON);
        out.accept(TFCBlocks.PUMPKIN);
        out.accept((ItemLike)Blocks.CARVED_PUMPKIN);
        out.accept(TFCBlocks.JACK_O_LANTERN);
        out.accept((ItemLike)TFCItems.TORCH);
        out.accept((ItemLike)TFCItems.DEAD_TORCH);
        out.accept(TFCBlocks.BARREL_RACK);
        out.accept(TFCBlocks.FIRE_BRICKS);
        out.accept(TFCBlocks.REINFORCED_FIRE_BRICKS);
        out.accept(TFCBlocks.FIRE_BRICK_SHELF);
        out.accept(TFCBlocks.FIREPROOF_DOOR);
        out.accept(TFCBlocks.FIREBOX);
        out.accept(TFCBlocks.FIRE_CLAY_BLOCK);
        out.accept(TFCBlocks.VANE);
        out.accept(TFCBlocks.ANEMOMETER);
        out.accept(TFCBlocks.CALENDAR_CLOCK);
        out.accept(TFCBlocks.THERMOMETER);
        out.accept(TFCBlocks.AGGREGATE);
        out.accept(TFCBlocks.PLAIN_ALABASTER);
        out.accept(TFCBlocks.PLAIN_ALABASTER_BRICKS);
        out.accept(TFCBlocks.PLAIN_POLISHED_ALABASTER);
        for (DyeColor color : DyeColor.values()) {
            TFCCreativeTabs.accept(out, TFCBlocks.RAW_ALABASTER, color);
            TFCCreativeTabs.accept(out, TFCBlocks.ALABASTER_BRICKS, color);
            TFCCreativeTabs.accept(out, TFCBlocks.ALABASTER_BRICK_DECORATIONS.get(color));
            TFCCreativeTabs.accept(out, TFCBlocks.POLISHED_ALABASTER, color);
            TFCCreativeTabs.accept(out, TFCBlocks.ALABASTER_POLISHED_DECORATIONS.get(color));
        }
        out.accept(TFCBlocks.LARGE_VESSEL);
        TFCBlocks.GLAZED_LARGE_VESSELS.values().forEach(arg_0 -> ((CreativeModeTab.Output)out).accept(arg_0));
        out.accept(TFCBlocks.CANDLE);
        out.accept(TFCBlocks.CAKE);
        for (DyeColor color : DyeColor.values()) {
            TFCCreativeTabs.accept(out, TFCBlocks.DYED_CANDLE, color);
        }
    }

    private static void fillWoodTab(CreativeModeTab.ItemDisplayParameters parameters, CreativeModeTab.Output out) {
        for (Wood wood : Wood.VALUES) {
            TFCBlocks.WOODS.get(wood).forEach((type, reg) -> {
                if (type.needsItem()) {
                    out.accept((ItemLike)reg);
                }
                if (type == Wood.BlockType.SAPLING) {
                    switch (wood) {
                        case PINE: {
                            out.accept(TFCBlocks.PINE_KRUMMHOLZ);
                            break;
                        }
                        case SPRUCE: {
                            out.accept(TFCBlocks.SPRUCE_KRUMMHOLZ);
                            break;
                        }
                        case WHITE_CEDAR: {
                            out.accept(TFCBlocks.WHITE_CEDAR_KRUMMHOLZ);
                            break;
                        }
                        case DOUGLAS_FIR: {
                            out.accept(TFCBlocks.DOUGLAS_FIR_KRUMMHOLZ);
                            break;
                        }
                        case ASPEN: {
                            out.accept(TFCBlocks.ASPEN_KRUMMHOLZ);
                        }
                    }
                }
            });
            if (wood == Wood.PALM) {
                out.accept(TFCBlocks.PALM_MOSAIC);
                out.accept(TFCBlocks.PALM_MOSAIC_STAIRS);
                out.accept(TFCBlocks.PALM_MOSAIC_SLAB);
            }
            out.accept(TFCBlocks.GOLDEN_BAMBOO_BLOCK);
            TFCCreativeTabs.accept(out, TFCItems.LUMBER, wood);
            TFCCreativeTabs.accept(out, TFCItems.BOATS, wood);
            TFCCreativeTabs.accept(out, TFCItems.SUPPORTS, wood);
            TFCCreativeTabs.accept(out, TFCItems.CHEST_MINECARTS, wood);
            TFCCreativeTabs.accept(out, TFCItems.SIGNS, wood);
            for (Metal metal : Metal.values()) {
                TFCCreativeTabs.accept(out, TFCItems.HANGING_SIGNS.get(wood), metal);
            }
        }
    }

    private static void fillPlantsTab(CreativeModeTab.ItemDisplayParameters parameters, CreativeModeTab.Output out) {
        TFCBlocks.PLANTS.forEach((plant, reg) -> {
            if (plant.needsItem()) {
                out.accept((ItemLike)reg);
            }
        });
        out.accept(TFCBlocks.SEA_PICKLE);
    }

    private static Id register(String name, Supplier<ItemStack> icon, CreativeModeTab.DisplayItemsGenerator displayItems) {
        DeferredHolder holder = CREATIVE_TABS.register(name, () -> CreativeModeTab.builder().icon(icon).title((Component)Component.translatable((String)("tfc.creative_tab." + name))).displayItems(displayItems).build());
        return new Id((DeferredHolder<CreativeModeTab, CreativeModeTab>)holder, displayItems);
    }

    private static <R extends ItemLike, K1, K2> void accept(CreativeModeTab.Output out, Map<K1, Map<K2, R>> map, K1 key1, K2 key2) {
        if (map.containsKey(key1)) {
            TFCCreativeTabs.accept(out, map.get(key1), key2);
        }
    }

    private static <R extends ItemLike, K> void accept(CreativeModeTab.Output out, Map<K, R> map, K key) {
        if (map.containsKey(key)) {
            out.accept((ItemLike)map.get(key));
        }
    }

    private static void accept(CreativeModeTab.Output out, DecorationBlockHolder decoration) {
        out.accept(decoration.stair());
        out.accept(decoration.slab());
        out.accept(decoration.wall());
    }

    private static /* synthetic */ void lambda$fillOresTab$14(CreativeModeTab.Output out, Ore ore, Map map) {
        TFCCreativeTabs.accept(out, map, ore);
    }

    private static /* synthetic */ void lambda$fillOresTab$13(Ore ore, CreativeModeTab.Output out, Map map) {
        ((Map)map.get((Object)ore)).values().forEach(arg_0 -> ((CreativeModeTab.Output)out).accept(arg_0));
    }

    private static /* synthetic */ void lambda$fillOresTab$12(CreativeModeTab.Output out, OreDeposit deposit, Map map) {
        TFCCreativeTabs.accept(out, map, deposit);
    }

    public record Id(DeferredHolder<CreativeModeTab, CreativeModeTab> tab, CreativeModeTab.DisplayItemsGenerator generator) {
    }
}

