/*
 * Decompiled with CFR 0.152.
 */
package net.dries007.tfc.common;

import net.dries007.tfc.util.Helpers;
import net.minecraft.core.Holder;
import net.minecraft.core.registries.Registries;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.damagesource.DamageType;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.level.Level;
import org.jetbrains.annotations.Nullable;

public class TFCDamageTypes {
    public static final ResourceKey<DamageType> GRILL = ResourceKey.create((ResourceKey)Registries.DAMAGE_TYPE, (ResourceLocation)Helpers.identifier("grill"));
    public static final ResourceKey<DamageType> POT = ResourceKey.create((ResourceKey)Registries.DAMAGE_TYPE, (ResourceLocation)Helpers.identifier("pot"));
    public static final ResourceKey<DamageType> DEHYDRATION = ResourceKey.create((ResourceKey)Registries.DAMAGE_TYPE, (ResourceLocation)Helpers.identifier("dehydration"));
    public static final ResourceKey<DamageType> CORAL = ResourceKey.create((ResourceKey)Registries.DAMAGE_TYPE, (ResourceLocation)Helpers.identifier("coral"));
    public static final ResourceKey<DamageType> PLUCK = ResourceKey.create((ResourceKey)Registries.DAMAGE_TYPE, (ResourceLocation)Helpers.identifier("pluck"));

    public static void grill(Entity entity, float amount) {
        entity.hurt(new DamageSource(TFCDamageTypes.fetch(GRILL, entity.level())), amount);
    }

    public static void pot(Entity entity, float amount) {
        entity.hurt(new DamageSource(TFCDamageTypes.fetch(POT, entity.level())), amount);
    }

    public static void coral(Entity entity, float amount) {
        entity.hurt(new DamageSource(TFCDamageTypes.fetch(CORAL, entity.level())), amount);
    }

    public static void pluck(Entity entity, float amount, @Nullable Entity plucker) {
        entity.hurt(new DamageSource(TFCDamageTypes.fetch(PLUCK, entity.level()), plucker), amount);
    }

    public static void dehydration(Entity entity, float amount) {
        entity.hurt(new DamageSource(TFCDamageTypes.fetch(DEHYDRATION, entity.level())), amount);
    }

    private static Holder<DamageType> fetch(ResourceKey<DamageType> type, Level level) {
        return level.registryAccess().registryOrThrow(Registries.DAMAGE_TYPE).getHolderOrThrow(type);
    }
}

