/*
 * Decompiled with CFR 0.152.
 */
package net.dries007.tfc.common;

import java.util.Map;
import net.dries007.tfc.common.blocks.rock.RockCategory;
import net.dries007.tfc.util.Helpers;
import net.minecraft.core.registries.Registries;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.tags.FluidTags;
import net.minecraft.tags.TagKey;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.item.Item;
import net.minecraft.world.level.biome.Biome;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.material.Fluid;
import net.neoforged.neoforge.common.Tags;

public class TFCTags {

    public static class Biomes {
        public static final TagKey<Biome> HAS_PREDICTABLE_WINDS = Biomes.create("has_predictable_winds");

        private static TagKey<Biome> create(String id) {
            return TagKey.create((ResourceKey)Registries.BIOME, (ResourceLocation)Helpers.identifier(id));
        }
    }

    public static class Entities {
        public static final TagKey<EntityType<?>> HUNTS_LAND_PREY = Entities.tag("hunts_land_prey");
        public static final TagKey<EntityType<?>> HUNTED_BY_LAND_PREDATORS = Entities.tag("hunted_by_land_predators");
        public static final TagKey<EntityType<?>> OCEAN_PREDATORS = Entities.tag("ocean_predators");
        public static final TagKey<EntityType<?>> HUNTED_BY_OCEAN_PREDATORS = Entities.tag("hunted_by_ocean_predators");
        public static final TagKey<EntityType<?>> DEALS_SLASHING_DAMAGE = Entities.tag("deals_slashing_damage");
        public static final TagKey<EntityType<?>> DEALS_PIERCING_DAMAGE = Entities.tag("deals_piercing_damage");
        public static final TagKey<EntityType<?>> DEALS_CRUSHING_DAMAGE = Entities.tag("deals_crushing_damage");
        public static final TagKey<EntityType<?>> HORSES = Entities.tag("horses");
        public static final TagKey<EntityType<?>> DESTROYED_BY_LEAVES = Entities.tag("destroyed_by_leaves");
        public static final TagKey<EntityType<?>> LEASHABLE_WILD_ANIMALS = Entities.tag("leashable_wild_animals");
        public static final TagKey<EntityType<?>> PESTS = Entities.tag("pests");
        public static final TagKey<EntityType<?>> UNIVERSAL_PESTS = Entities.tag("universal_pests");
        public static final TagKey<EntityType<?>> COLD_PESTS = Entities.tag("cold_pests");
        public static final TagKey<EntityType<?>> DESERT_PESTS = Entities.tag("desert_pests");
        public static final TagKey<EntityType<?>> TROPICAL_PESTS = Entities.tag("tropical_pests");
        public static final TagKey<EntityType<?>> HUNTED_BY_CATS = Entities.tag("hunted_by_cats");
        public static final TagKey<EntityType<?>> HUNTED_BY_DOGS = Entities.tag("hunted_by_dogs");
        public static final TagKey<EntityType<?>> SMALL_FISH = Entities.tag("small_fish");
        public static final TagKey<EntityType<?>> RAMMING_ANIMALS = Entities.tag("ramming_animals");
        public static final TagKey<EntityType<?>> BIRD_PREY = Entities.tag("bird_prey");
        public static final TagKey<EntityType<?>> LARGE_PREY = Entities.tag("large_prey");
        public static final TagKey<EntityType<?>> NOT_RAMMED_BY_RAMMERS = Entities.tag("not_rammed_by_rammers");
        public static final TagKey<EntityType<?>> WATER_AMBIENT = Entities.tag("water_ambient");
        public static final TagKey<EntityType<?>> BEARS = Entities.tag("bears");
        public static final TagKey<EntityType<?>> CANINE_PREDATORS = Entities.tag("canine_predators");
        public static final TagKey<EntityType<?>> BIG_CATS = Entities.tag("big_cats");
        public static final TagKey<EntityType<?>> LAND_PREDATORS = Entities.tag("land_predators");
        public static final TagKey<EntityType<?>> WATER_CREATURES = Entities.tag("water_creatures");
        public static final TagKey<EntityType<?>> AMPHIBIOUS_CREATURES = Entities.tag("water_creatures");
        public static final TagKey<EntityType<?>> DAIRY_ANIMALS = Entities.tag("dairy_animals");
        public static final TagKey<EntityType<?>> OVIPAROUS_ANIMALS = Entities.tag("oviparous_animals");
        public static final TagKey<EntityType<?>> SHEARABLE_ANIMALS = Entities.tag("shearable_animals");
        public static final TagKey<EntityType<?>> RIDEABLE_ANIMALS = Entities.tag("rideable_animals");
        public static final TagKey<EntityType<?>> WILD_PREY_ANIMALS = Entities.tag("wild_prey_animals");
        public static final TagKey<EntityType<?>> PETS = Entities.tag("pets");
        public static final TagKey<EntityType<?>> FARM_ANIMALS = Entities.tag("farm_animals");
        public static final TagKey<EntityType<?>> ANIMALS = Entities.tag("animals");
        public static final TagKey<EntityType<?>> MONSTERS = Entities.tag("monsters");
        public static final TagKey<EntityType<?>> SPAWNS_ON_COLD_BLOCKS = Entities.tag("spawns_on_cold_blocks");
        public static final TagKey<EntityType<?>> TURTLE_FRIENDS = Entities.tag("turtle_friends");
        public static final TagKey<EntityType<?>> BUBBLE_COLUMN_IMMUNE = Entities.tag("bubble_column_immune");
        public static final TagKey<EntityType<?>> NEEDS_LARGE_FISHING_BAIT = Entities.tag("needs_large_fishing_bait");

        private static TagKey<EntityType<?>> tag(String id) {
            return TagKey.create((ResourceKey)Registries.ENTITY_TYPE, (ResourceLocation)Helpers.identifier(id));
        }
    }

    public static class Items {
        public static final TagKey<Item> FOODS = Tags.Items.FOODS;
        public static final TagKey<Item> FRUITS = Tags.Items.FOODS_FRUIT;
        public static final TagKey<Item> VEGETABLES = Tags.Items.FOODS_VEGETABLE;
        public static final TagKey<Item> RAW_MEATS = Tags.Items.FOODS_RAW_MEAT;
        public static final TagKey<Item> COOKED_MEATS = Tags.Items.FOODS_COOKED_MEAT;
        public static final TagKey<Item> MEATS = Items.commonTag("foods/meat");
        public static final TagKey<Item> RAW_FISH = Tags.Items.FOODS_RAW_FISH;
        public static final TagKey<Item> COOKED_FISH = Tags.Items.FOODS_COOKED_FISH;
        public static final TagKey<Item> FISH = Items.commonTag("foods/fish");
        public static final TagKey<Item> FLOUR = Items.commonTag("foods/flour");
        public static final TagKey<Item> DOUGH = Items.commonTag("foods/dough");
        public static final TagKey<Item> GRAINS = Items.commonTag("foods/grain");
        public static final TagKey<Item> BREAD = Items.commonTag("foods/bread");
        public static final TagKey<Item> DAIRY = Items.commonTag("foods/dairy");
        public static final TagKey<Item> SALADS = Items.commonTag("foods/salad");
        public static final TagKey<Item> SOUPS = Tags.Items.FOODS_SOUP;
        public static final TagKey<Item> SANDWICHES = Items.commonTag("foods/sandwiches");
        public static final TagKey<Item> PRESERVES = Items.tag("foods/preserves");
        public static final TagKey<Item> SEALED_PRESERVES = Items.tag("foods/sealed_preserves");
        public static final TagKey<Item> JAM = Items.tag("foods/jam");
        public static final TagKey<Item> JARRED_FOOD = Items.tag("foods/jarred_food");
        public static final TagKey<Item> SEALED_JARRED_FOOD = Items.tag("foods/sealed_jarred_food");
        public static final TagKey<Item> EMPTY_JARS = Items.tag("foods/empty_jars");
        public static final TagKey<Item> FILLED_JARS = Items.tag("foods/filled_jars");
        public static final TagKey<Item> JARS = Items.tag("foods/jars");
        public static final TagKey<Item> SWEETENERS = Items.tag("foods/sweeteners");
        public static final TagKey<Item> BOWLS = Items.commonTag("bowls");
        public static final TagKey<Item> SOUP_BOWLS = Items.tag("soup_bowls");
        public static final TagKey<Item> SALAD_BOWLS = Items.tag("salad_bowls");
        public static final TagKey<Item> USABLE_IN_SALAD = Items.tag("usable_in_salad");
        public static final TagKey<Item> USABLE_IN_SOUP = Items.tag("usable_in_soup");
        public static final TagKey<Item> USABLE_IN_SANDWICH = Items.tag("usable_in_sandwich");
        public static final TagKey<Item> USABLE_IN_JAM_SANDWICH = Items.tag("usable_in_jam_sandwich");
        public static final TagKey<Item> CAN_BE_SALTED = Items.tag("foods/can_be_salted");
        public static final TagKey<Item> PIG_FOOD = Items.tag("pig_food");
        public static final TagKey<Item> COW_FOOD = Items.tag("cow_food");
        public static final TagKey<Item> YAK_FOOD = Items.tag("yak_food");
        public static final TagKey<Item> GOAT_FOOD = Items.tag("goat_food");
        public static final TagKey<Item> ALPACA_FOOD = Items.tag("alpaca_food");
        public static final TagKey<Item> SHEEP_FOOD = Items.tag("sheep_food");
        public static final TagKey<Item> MUSK_OX_FOOD = Items.tag("musk_ox_food");
        public static final TagKey<Item> CHICKEN_FOOD = Items.tag("chicken_food");
        public static final TagKey<Item> DUCK_FOOD = Items.tag("duck_food");
        public static final TagKey<Item> QUAIL_FOOD = Items.tag("quail_food");
        public static final TagKey<Item> DONKEY_FOOD = Items.tag("donkey_food");
        public static final TagKey<Item> MULE_FOOD = Items.tag("mule_food");
        public static final TagKey<Item> HORSE_FOOD = Items.tag("horse_food");
        public static final TagKey<Item> CAT_FOOD = Items.tag("cat_food");
        public static final TagKey<Item> DOG_FOOD = Items.tag("dog_food");
        public static final TagKey<Item> PENGUIN_FOOD = Items.tag("penguin_food");
        public static final TagKey<Item> TURTLE_FOOD = Items.tag("turtle_food");
        public static final TagKey<Item> FROG_FOOD = Items.tag("frog_food");
        public static final TagKey<Item> SEAL_FOOD = Items.tag("seal_food");
        public static final TagKey<Item> RABBIT_FOOD = Items.tag("rabbit_food");
        public static final TagKey<Item> COMPOST_GREENS = Items.tag("compost_greens");
        public static final TagKey<Item> COMPOST_GREENS_LOW = Items.tag("compost_greens/low");
        public static final TagKey<Item> COMPOST_GREENS_MEDIUM = Items.tag("compost_greens/medium");
        public static final TagKey<Item> COMPOST_GREENS_HIGH = Items.tag("compost_greens/high");
        public static final TagKey<Item> COMPOST_BROWNS = Items.tag("compost_browns");
        public static final TagKey<Item> COMPOST_BROWNS_LOW = Items.tag("compost_browns/low");
        public static final TagKey<Item> COMPOST_BROWNS_MEDIUM = Items.tag("compost_browns/medium");
        public static final TagKey<Item> COMPOST_BROWNS_HIGH = Items.tag("compost_browns/high");
        public static final TagKey<Item> COMPOST_POISONS = Items.tag("compost_poisons");
        public static final TagKey<Item> SMALL_FISHING_BAIT = Items.tag("small_fishing_bait");
        public static final TagKey<Item> LARGE_FISHING_BAIT = Items.tag("large_fishing_bait");
        public static final TagKey<Item> HOLDS_SMALL_FISHING_BAIT = Items.tag("holds_small_fishing_bait");
        public static final TagKey<Item> HOLDS_LARGE_FISHING_BAIT = Items.tag("holds_large_fishing_bait");
        public static final TagKey<Item> PLANTS = Items.tag("plants");
        public static final TagKey<Item> WILD_CROPS = Items.tag("wild_crops");
        public static final TagKey<Item> BAMBOO = Items.tag("bamboo");
        public static final TagKey<Item> COLORED_WOOL = Items.tag("colored_wool");
        public static final TagKey<Item> COLORED_CARPETS = Items.tag("colored_carpets");
        public static final TagKey<Item> COLORED_BEDS = Items.tag("colored_beds");
        public static final TagKey<Item> COLORED_BANNERS = Items.tag("colored_banners");
        public static final TagKey<Item> COLORED_TERRACOTTA = Items.tag("colored_terracotta");
        public static final TagKey<Item> COLORED_GLAZED_TERRACOTTA = Items.tag("colored_glazed_terracotta");
        public static final TagKey<Item> COLORED_SHULKER_BOXES = Items.tag("colored_shulker_boxes");
        public static final TagKey<Item> COLORED_CONCRETE_POWDER = Items.tag("colored_concrete_powder");
        public static final TagKey<Item> COLORED_CANDLES = Items.tag("colored_candles");
        public static final TagKey<Item> COLORED_WINDMILL_BLADES = Items.tag("colored_windmill_blades");
        public static final TagKey<Item> COLORED_RAW_ALABASTER = Items.tag("colored_raw_alabaster");
        public static final TagKey<Item> COLORED_ALABASTER_BRICKS = Items.tag("colored_alabaster_bricks");
        public static final TagKey<Item> COLORED_POLISHED_ALABASTER = Items.tag("colored_polished_alabaster");
        public static final TagKey<Item> COLORED_VESSELS = Items.tag("colored_vessels");
        public static final TagKey<Item> COLORED_LARGE_VESSELS = Items.tag("colored_large_vessels");
        public static final TagKey<Item> TOOL_RACKS = Items.tag("tool_racks");
        public static final TagKey<Item> SCRIBING_TABLES = Items.tag("scribing_tables");
        public static final TagKey<Item> SEWING_TABLES = Items.tag("sewing_tables");
        public static final TagKey<Item> SLUICES = Items.tag("sluices");
        public static final TagKey<Item> LOOMS = Items.tag("looms");
        public static final TagKey<Item> BARRELS = Items.tag("barrels");
        public static final TagKey<Item> TWIGS = Items.tag("twigs");
        public static final TagKey<Item> VESSELS = Items.tag("vessels");
        public static final TagKey<Item> UNFIRED_VESSELS = Items.tag("unfired_vessels");
        public static final TagKey<Item> FIRED_VESSELS = Items.tag("fired_vessels");
        public static final TagKey<Item> LARGE_VESSELS = Items.tag("large_vessels");
        public static final TagKey<Item> UNFIRED_LARGE_VESSELS = Items.tag("unfired_large_vessels");
        public static final TagKey<Item> FIRED_LARGE_VESSELS = Items.tag("fired_large_vessels");
        public static final TagKey<Item> MOLDS = Items.tag("molds");
        public static final TagKey<Item> UNFIRED_MOLDS = Items.tag("unfired_molds");
        public static final TagKey<Item> FIRED_MOLDS = Items.tag("fired_molds");
        public static final TagKey<Item> LAMPS = Items.tag(Blocks.LAMPS);
        public static final TagKey<Item> MINECARTS = Items.commonTag("minecarts");
        public static final TagKey<Item> ORE_PIECES = Items.tag("ore_pieces");
        public static final TagKey<Item> SMALL_ORE_PIECES = Items.tag("small_ore_pieces");
        public static final TagKey<Item> WATER_WHEELS = Items.tag("water_wheels");
        public static final TagKey<Item> WINDMILL_BLADES = Items.tag("windmill_blades");
        public static final TagKey<Item> AXLES = Items.tag("axles");
        public static final TagKey<Item> GEAR_BOXES = Items.tag("gear_boxes");
        public static final TagKey<Item> CLUTCHES = Items.tag("clutches");
        public static final TagKey<Item> SUPPORT_BEAMS = Items.tag("support_beams");
        public static final TagKey<Item> LUMBER = Items.tag("lumber");
        public static final TagKey<Item> DOUBLE_INGOTS = Items.commonTag("double_ingots");
        public static final TagKey<Item> SHEETS = Items.commonTag("sheets");
        public static final TagKey<Item> DOUBLE_SHEETS = Items.commonTag("double_sheets");
        public static final TagKey<Item> DOUBLE_SHEETS_ANY_BRONZE = Items.tag("double_sheets/any_bronze");
        public static final TagKey<Item> TOOLS_HAMMER = Items.commonTag("tools/hammer");
        public static final TagKey<Item> TOOLS_SAW = Items.commonTag("tools/saw");
        public static final TagKey<Item> TOOLS_SCYTHE = Items.commonTag("tools/scythe");
        public static final TagKey<Item> TOOLS_PROPICK = Items.commonTag("tools/propick");
        public static final TagKey<Item> TOOLS_KNIFE = Items.commonTag("tools/knife");
        public static final TagKey<Item> TOOLS_CHISEL = Items.commonTag("tools/chisel");
        public static final TagKey<Item> TOOLS_GLASSWORKING = Items.commonTag("tools/glassworking");
        public static final TagKey<Item> TOOLS_BLOWPIPE = Items.commonTag("tools/blowpipe");
        public static final TagKey<Item> TOOLS_SHARP = Items.tag("tools/sharp");
        public static final TagKey<Item> TOOLS_LARGE = Items.tag("tools/large");
        public static final TagKey<Item> SCRAPED_HIDES = Items.tag("scraped_hide");
        public static final TagKey<Item> TOOLS_STONE = Items.tag("tools/stone");
        public static final TagKey<Item> TOOLS_COPPER = Items.tag("tools/copper");
        public static final TagKey<Item> TOOLS_BISMUTH_BRONZE = Items.tag("tools/bismuth_bronze");
        public static final TagKey<Item> TOOLS_BLACK_BRONZE = Items.tag("tools/black_bronze");
        public static final TagKey<Item> TOOLS_BRONZE = Items.tag("tools/bronze");
        public static final TagKey<Item> TOOLS_WROUGHT_IRON = Items.tag("tools/wrought_iron");
        public static final TagKey<Item> TOOLS_STEEL = Items.tag("tools/steel");
        public static final TagKey<Item> TOOLS_BLACK_STEEL = Items.tag("tools/black_steel");
        public static final TagKey<Item> TOOLS_RED_STEEL = Items.tag("tools/red_steel");
        public static final TagKey<Item> TOOLS_BLUE_STEEL = Items.tag("tools/blue_steel");
        public static final TagKey<Item> METAL_ORES = Items.tag("metal_ores");
        public static final TagKey<Item> MUD_BRICK_ITEMS = Items.tag("mud_brick_items");
        public static final TagKey<Item> DEALS_SLASHING_DAMAGE = Items.tag("deals_slashing_damage");
        public static final TagKey<Item> DEALS_PIERCING_DAMAGE = Items.tag("deals_piercing_damage");
        public static final TagKey<Item> DEALS_CRUSHING_DAMAGE = Items.tag("deals_crushing_damage");
        public static final TagKey<Item> GLASS_BATCHES = Items.tag("glass_batches");
        public static final TagKey<Item> GLASS_BATCHES_T2 = Items.tag("glass_batches_tier_2");
        public static final TagKey<Item> GLASS_BATCHES_T3 = Items.tag("glass_batches_tier_3");
        public static final TagKey<Item> GLASS_BATCHES_NOT_T1 = Items.tag("glass_batches_not_tier_1");
        public static final TagKey<Item> GLASS_BLOWPIPES = Items.tag("glass_blowpipes");
        public static final TagKey<Item> BLOWPIPES = Items.tag("all_blowpipes");
        public static final TagKey<Item> GLASS_POWDERS = Items.tag("glass_powders");
        public static final TagKey<Item> GLASS_BOTTLES = Items.tag("glass_bottles");
        public static final TagKey<Item> GLASS_POTASH = Items.tag("glass_potash");
        public static final TagKey<Item> SILICA_SAND = Items.commonTag("sands/silica");
        public static final TagKey<Item> OLIVINE_SAND = Items.commonTag("sands/olivine");
        public static final TagKey<Item> HEMATITIC_SAND = Items.commonTag("sands/hematitic");
        public static final TagKey<Item> VOLCANIC_SAND = Items.commonTag("sands/volcanic");
        public static final TagKey<Item> HIGH_QUALITY_CLOTH = Items.tag("high_quality_cloth");
        public static final TagKey<Item> GEM_POWDERS = Items.tag("gem_powders");
        public static final TagKey<Item> BOOKS = Items.commonTag("books");
        public static final TagKey<Item> ORE_DEPOSITS = Items.tag("ore_deposits");
        public static final TagKey<Item> TANNIN_LOGS = Items.tag("tannin_logs");
        public static final TagKey<Item> FLUXSTONE = Items.tag("fluxstone");
        public static final TagKey<Item> FIREPIT_KINDLING = Items.tag("firepit_kindling");
        public static final TagKey<Item> FIREPIT_STICKS = Items.tag("firepit_sticks");
        public static final TagKey<Item> FIREPIT_LOGS = Items.tag("firepit_logs");
        public static final TagKey<Item> LOG_PILE_LOGS = Items.tag("log_pile_logs");
        public static final TagKey<Item> PIT_KILN_STRAW = Items.tag("pit_kiln_straw");
        public static final TagKey<Item> PIT_KILN_4_STRAW = Items.tag("pit_kiln_4_straw");
        public static final TagKey<Item> PIT_KILN_LOGS = Items.tag("pit_kiln_logs");
        public static final TagKey<Item> INEFFICIENT_LOGGING_AXES = Items.tag("inefficient_logging_axes");
        public static final TagKey<Item> CAN_BE_LIT_ON_TORCH = Items.tag("can_be_lit_on_torch");
        public static final TagKey<Item> ROCK_KNAPPING = Items.tag("rock_knapping");
        public static final TagKey<Item> CLAY_KNAPPING = Items.tag("clay_knapping");
        public static final TagKey<Item> FIRE_CLAY_KNAPPING = Items.tag("fire_clay_knapping");
        public static final TagKey<Item> LEATHER_KNAPPING = Items.tag("leather_knapping");
        public static final TagKey<Item> GOAT_HORN_KNAPPING = Items.tag("goat_horn_knapping");
        public static final TagKey<Item> QUERN_HANDSTONES = Items.tag("quern_handstones");
        public static final TagKey<Item> SEWING_DARK_CLOTH = Items.tag("sewing_dark_cloth");
        public static final TagKey<Item> SEWING_LIGHT_CLOTH = Items.tag("sewing_light_cloth");
        public static final TagKey<Item> SEWING_NEEDLES = Items.tag("sewing_needles");
        public static final TagKey<Item> FIREPIT_FUEL = Items.tag("firepit_fuel");
        public static final TagKey<Item> FORGE_FUEL = Items.tag("forge_fuel");
        public static final TagKey<Item> BLAST_FURNACE_FUEL = Items.tag("blast_furnace_fuel");
        public static final TagKey<Item> BLAST_FURNACE_SHEETS = Items.tag("blast_furnace_sheets");
        public static final TagKey<Item> BLAST_FURNACE_TUYERES = Items.tag("blast_furnace_tuyeres");
        public static final TagKey<Item> TOOL_RACK_TOOLS = Items.tag("usable_on_tool_rack");
        public static final TagKey<Item> POWDER_KEG_FUEL = Items.tag("usable_in_powder_keg");
        public static final TagKey<Item> USABLE_IN_MOLD_TABLE = Items.tag("usable_in_mold_table");
        public static final TagKey<Item> MINECART_HOLDABLE = Items.tag("minecart_holdable");
        public static final TagKey<Item> TRIP_HAMMERS = Items.tag("trip_hammers");
        public static final TagKey<Item> WELDING_FLUX = Items.tag("welding_flux");
        public static final TagKey<Item> SCRIBING_INK = Items.tag("scribing_ink");
        public static final TagKey<Item> THATCH_BED_HIDES = Items.tag("thatch_bed_hides");
        public static final TagKey<Item> BOWL_POWDERS = Items.tag("bowl_powders");
        public static final TagKey<Item> SCRAPING_WAXES = Items.tag("scraping_waxes");
        public static final Map<RockCategory, TagKey<Item>> STONES_LOOSE_CATEGORY = Helpers.mapOf(RockCategory.class, type -> Items.tag("stones/loose/" + type.getSerializedName()));
        public static final TagKey<Item> FLUID_ITEM_INGREDIENT_EMPTY_CONTAINERS = Items.tag("fluid_item_ingredient_empty_containers");
        public static final TagKey<Item> DISABLED_MONSTER_HELD_ITEMS = Items.tag("disabled_monster_held_items");
        public static final TagKey<Item> FOX_SPAWNS_WITH = Items.tag("fox_spawns_with");
        public static final TagKey<Item> CARRIED_BY_HORSE = Items.tag("carried_by_horse");
        public static final TagKey<Item> UNFIRED_POTTERY = Items.tag("unfired_pottery");
        public static final TagKey<Item> METAL_PLATED_BLOCKS = Items.tag("metal_plated_blocks");
        public static final TagKey<Item> MOB_FEET_ARMOR = Items.tag("mob_feet_armor");
        public static final TagKey<Item> MOB_LEG_ARMOR = Items.tag("mob_leg_armor");
        public static final TagKey<Item> MOB_CHEST_ARMOR = Items.tag("mob_chest_armor");
        public static final TagKey<Item> MOB_HEAD_ARMOR = Items.tag("mob_head_armor");
        public static final TagKey<Item> SKELETON_WEAPONS = Items.tag("skeleton_weapons");
        public static final TagKey<Item> STONES_RAW = Items.tag(Blocks.STONES_RAW);
        public static final TagKey<Item> STONES_HARDENED = Items.tag(Blocks.STONES_HARDENED);
        public static final TagKey<Item> STONES_SMOOTH = Items.tag(Blocks.STONES_SMOOTH);
        public static final TagKey<Item> STONES_SMOOTH_SLABS = Items.tag(Blocks.STONES_SMOOTH_SLABS);
        public static final TagKey<Item> STONES_PRESSURE_PLATES = Items.tag(Blocks.STONES_PRESSURE_PLATES);
        public static final TagKey<Item> STONES_LOOSE = Items.tag(Blocks.STONES_LOOSE);
        public static final TagKey<Item> DIRT = Items.tag(Blocks.DIRT);
        public static final TagKey<Item> GRASS = Items.tag(Blocks.GRASS);
        public static final TagKey<Item> COARSE_DIRT = Items.tag(Blocks.COARSE_DIRT);
        public static final TagKey<Item> MUD = Items.tag(Blocks.MUD);
        public static final TagKey<Item> MUD_BRICKS = Items.tag(Blocks.MUD_BRICKS);
        public static final TagKey<Item> ANVILS = Items.tag(Blocks.ANVILS);
        public static final TagKey<Item> WORKBENCHES = Items.tag(Blocks.WORKBENCHES);
        public static final TagKey<Item> AQUEDUCTS = Items.tag(Blocks.AQUEDUCTS);
        public static final TagKey<Item> FALLEN_LEAVES = Items.tag(Blocks.FALLEN_LEAVES);
        public static final TagKey<Item> CLAY_INDICATORS = Items.tag(Blocks.CLAY_INDICATORS);

        private static TagKey<Item> tag(TagKey<Block> blockTag) {
            return TagKey.create((ResourceKey)Registries.ITEM, (ResourceLocation)blockTag.location());
        }

        private static TagKey<Item> tag(String name) {
            return TagKey.create((ResourceKey)Registries.ITEM, (ResourceLocation)Helpers.identifier(name));
        }

        private static TagKey<Item> commonTag(String name) {
            return TagKey.create((ResourceKey)Registries.ITEM, (ResourceLocation)ResourceLocation.fromNamespaceAndPath((String)"c", (String)name));
        }
    }

    public static class Fluids {
        public static final TagKey<Fluid> WATER_LIKE = FluidTags.WATER;
        public static final TagKey<Fluid> LAVA_LIKE = FluidTags.LAVA;
        public static final TagKey<Fluid> ANY_FRESH_WATER = Fluids.create("any_fresh_water");
        public static final TagKey<Fluid> ANY_INFINITE_WATER = Fluids.create("any_infinite_water");
        public static final TagKey<Fluid> FRESH_WATER = Fluids.create("fresh_water");
        public static final TagKey<Fluid> SALT_WATER = Fluids.create("salt_water");
        public static final TagKey<Fluid> INFINITE_WATER = Fluids.create("infinite_water");
        public static final TagKey<Fluid> MIXABLE = Fluids.create("mixable");
        public static final TagKey<Fluid> HYDRATING = Fluids.create("hydrating");
        public static final TagKey<Fluid> ALCOHOLS = Fluids.create("alcohols");
        public static final TagKey<Fluid> MOLTEN_METALS = Fluids.create("molten_metals");
        public static final TagKey<Fluid> DRINKABLES = Fluids.create("drinkables");
        public static final TagKey<Fluid> INGREDIENTS = Fluids.create("ingredients");
        public static final TagKey<Fluid> USABLE_IN_POT = Fluids.create("usable_in_pot");
        public static final TagKey<Fluid> USABLE_IN_JUG = Fluids.create("usable_in_jug");
        public static final TagKey<Fluid> USABLE_IN_WOODEN_BUCKET = Fluids.create("usable_in_wooden_bucket");
        public static final TagKey<Fluid> USABLE_IN_RED_STEEL_BUCKET = Fluids.create("usable_in_red_steel_bucket");
        public static final TagKey<Fluid> USABLE_IN_BLUE_STEEL_BUCKET = Fluids.create("usable_in_blue_steel_bucket");
        public static final TagKey<Fluid> USABLE_IN_BARREL = Fluids.create("usable_in_barrel");
        public static final TagKey<Fluid> USABLE_IN_SCRIBING_TABLE = Fluids.create("usable_in_scribing_table");
        public static final TagKey<Fluid> USABLE_IN_SLUICE = Fluids.create("usable_in_sluice");
        public static final TagKey<Fluid> USABLE_IN_INGOT_MOLD = Fluids.create("usable_in_ingot_mold");
        public static final TagKey<Fluid> USABLE_IN_TOOL_HEAD_MOLD = Fluids.create("usable_in_tool_head_mold");
        public static final TagKey<Fluid> USABLE_IN_BELL_MOLD = Fluids.create("usable_in_bell_mold");

        private static TagKey<Fluid> create(String id) {
            return TagKey.create((ResourceKey)Registries.FLUID, (ResourceLocation)Helpers.identifier(id));
        }
    }

    public static class Blocks {
        public static final TagKey<Block> CAN_TRIGGER_COLLAPSE = Blocks.tag("can_trigger_collapse");
        public static final TagKey<Block> CAN_START_COLLAPSE = Blocks.tag("can_start_collapse");
        public static final TagKey<Block> CAN_COLLAPSE = Blocks.tag("can_collapse");
        public static final TagKey<Block> CAN_LANDSLIDE = Blocks.tag("can_landslide");
        public static final TagKey<Block> SUPPORTS_LANDSLIDE = Blocks.tag("supports_landslide");
        public static final TagKey<Block> NOT_SOLID_SUPPORTING = Blocks.tag("not_solid_supporting");
        public static final TagKey<Block> TOUGHNESS_1 = Blocks.tag("toughness_1");
        public static final TagKey<Block> TOUGHNESS_2 = Blocks.tag("toughness_2");
        public static final TagKey<Block> TOUGHNESS_3 = Blocks.tag("toughness_3");
        public static final TagKey<Block> BREAKS_WHEN_ISOLATED = Blocks.tag("breaks_when_isolated");
        public static final TagKey<Block> FALLEN_LEAVES = Blocks.tag("fallen_leaves");
        public static final TagKey<Block> SEASONAL_LEAVES = Blocks.tag("seasonal_leaves");
        public static final TagKey<Block> STONES_RAW = Blocks.commonTag("stones/raw");
        public static final TagKey<Block> STONES_HARDENED = Blocks.commonTag("stones/hardened");
        public static final TagKey<Block> STONES_SMOOTH = Blocks.commonTag("stones/smooth");
        public static final TagKey<Block> STONES_SMOOTH_SLABS = Blocks.commonTag("stones/smooth_slabs");
        public static final TagKey<Block> STONES_SPIKE = Blocks.commonTag("stones/spike");
        public static final TagKey<Block> STONES_PRESSURE_PLATES = Blocks.commonTag("stones/pressure_plate");
        public static final TagKey<Block> STONES_LOOSE = Blocks.commonTag("stones/loose");
        public static final TagKey<Block> INSULATION = Blocks.tag("insulation");
        public static final TagKey<Block> EXTRA_CAVE_CARVER_REPLACEABLE = Blocks.tag("extra_cave_carver_replaceable");
        public static final TagKey<Block> LAMPS = Blocks.tag("lamps");
        public static final TagKey<Block> ANVILS = Blocks.tag("anvils");
        public static final TagKey<Block> LOGS_THAT_LOG = Blocks.tag("logs_that_log");
        public static final TagKey<Block> WORKBENCHES = Blocks.tag("workbenches");
        public static final TagKey<Block> SUPPORT_BEAMS = Blocks.tag("support_beams");
        public static final TagKey<Block> AQUEDUCTS = Blocks.tag("aqueducts");
        public static final TagKey<Block> CHARCOAL_PIT_INSULATION = Blocks.tag("charcoal_pit_insulation");
        public static final TagKey<Block> CHARCOAL_FORGE_INSULATION = Blocks.tag("charcoal_forge_insulation");
        public static final TagKey<Block> CHARCOAL_FORGE_INVISIBLE = Blocks.tag("charcoal_forge_invisible");
        public static final TagKey<Block> BLOOMERY_INSULATION = Blocks.tag("bloomery_insulation");
        public static final TagKey<Block> BLAST_FURNACE_INSULATION = Blocks.tag("blast_furnace_insulation");
        public static final TagKey<Block> HEAT_INSULATION = Blocks.tag("heat_insulation");
        public static final TagKey<Block> HEAT_PASSABLE = Blocks.tag("heat_passable");
        public static final TagKey<Block> SCRAPING_SURFACE = Blocks.tag("scraping_surface");
        public static final TagKey<Block> GLASS_POURING_TABLE = Blocks.tag("glass_pouring_table");
        public static final TagKey<Block> GLASS_BASIN_BLOCKS = Blocks.tag("glass_basin_blocks");
        public static final TagKey<Block> THATCH_BED_THATCH = Blocks.tag("thatch_bed_thatch");
        public static final TagKey<Block> FRUIT_TREE_BRANCH = Blocks.tag("fruit_tree_branches");
        public static final TagKey<Block> FRUIT_TREE_LEAVES = Blocks.tag("fruit_tree_leaves");
        public static final TagKey<Block> FRUIT_TREE_SAPLING = Blocks.tag("fruit_tree_saplings");
        public static final TagKey<Block> KELP_TREE = Blocks.tag("kelp_trees");
        public static final TagKey<Block> KELP_BRANCH = Blocks.tag("kelp_branches");
        public static final TagKey<Block> BAMBOO = Blocks.tag("bamboo");
        public static final TagKey<Block> BAMBOO_SAPLING = Blocks.tag("bamboo_sapling");
        public static final TagKey<Block> LIVING_SPREADING_BUSHES = Blocks.tag("spreading_bushes/living");
        public static final TagKey<Block> SPREADING_BUSHES = Blocks.tag("spreading_bushes");
        public static final TagKey<Block> THORNY_BUSHES = Blocks.tag("thorny_bushes");
        public static final TagKey<Block> POWDERKEG_CANNOT_BREAK = Blocks.tag("explosion_proof");
        public static final TagKey<Block> POWDERKEG_CAN_BREAK = Blocks.tag("powderkeg_breaking_blocks");
        public static final TagKey<Block> CAN_BE_SNOW_PILED = Blocks.tag("can_be_snow_piled");
        public static final TagKey<Block> CAN_BE_ICE_PILED = Blocks.tag("can_be_ice_piled");
        public static final TagKey<Block> CONVERTS_TO_HUMUS = Blocks.tag("converts_to_humus");
        public static final TagKey<Block> SOLID_TOP_FACE = Blocks.tag("solid_top_face");
        public static final TagKey<Block> LIT_BY_DROPPED_TORCH = Blocks.tag("lit_by_dropped_torch");
        public static final TagKey<Block> SMOKES_IN_RAIN = Blocks.commonTag("smokes_in_rain");
        public static final TagKey<Block> MINEABLE_WITH_PROPICK = Blocks.tag("mineable/propick");
        public static final TagKey<Block> MINEABLE_WITH_CHISEL = Blocks.tag("mineable/chisel");
        public static final TagKey<Block> MINEABLE_WITH_HAMMER = Blocks.tag("mineable/hammer");
        public static final TagKey<Block> MINEABLE_WITH_KNIFE = Blocks.tag("mineable/knife");
        public static final TagKey<Block> MINEABLE_WITH_SCYTHE = Blocks.tag("mineable/scythe");
        public static final TagKey<Block> MINEABLE_WITH_GLASS_SAW = Blocks.tag("mineable/glass_saw");
        public static final TagKey<Block> MINEABLE_WITH_HOE = Blocks.tag("mineable/hoe");
        public static final TagKey<Block> PROSPECTABLE = Blocks.tag("prospectable");
        public static final TagKey<Block> DIRT = Blocks.tag("dirt");
        public static final TagKey<Block> GRASS = Blocks.tag("grass");
        public static final TagKey<Block> COARSE_DIRT = Blocks.tag("coarse_dirt");
        public static final TagKey<Block> FARMLANDS = Blocks.tag("farmlands");
        public static final TagKey<Block> PATHS = Blocks.tag("paths");
        public static final TagKey<Block> MUD = Blocks.tag("mud");
        public static final TagKey<Block> DUFF = Blocks.tag("duff");
        public static final TagKey<Block> MUD_BRICKS = Blocks.tag("mud_bricks");
        public static final TagKey<Block> CLAYS = Blocks.tag("clays");
        public static final TagKey<Block> KAOLIN_CLAYS = Blocks.tag("clays/kaolin");
        public static final TagKey<Block> INCREASES_SOIL_HYDRATION = Blocks.tag("increases_soil_hydration");
        public static final TagKey<Block> DECREASES_SOIL_HYDRATION = Blocks.tag("decreases_soil_hydration");
        public static final TagKey<Block> VERY_RICH_FARMLAND = Blocks.tag("very_rich_farmland");
        public static final TagKey<Block> RICH_FARMLAND = Blocks.tag("rich_farmland");
        public static final TagKey<Block> NORMAL_FARMLAND = Blocks.tag("normal_farmland");
        public static final TagKey<Block> POOR_FARMLAND = Blocks.tag("poor_farmland");
        public static final TagKey<Block> VERY_POOR_FARMLAND = Blocks.tag("very_poor_farmland");
        public static final TagKey<Block> ANEMONE_PLANTABLE_ON = Blocks.tag("anemone_plantable_on");
        public static final TagKey<Block> TREE_GROWS_ON = Blocks.tag("tree_grows_on");
        public static final TagKey<Block> WILD_CROP_GROWS_ON = Blocks.tag("wild_crop_grows_on");
        public static final TagKey<Block> SPREADING_FRUIT_GROWS_ON = Blocks.tag("spreading_fruit_grows_on");
        public static final TagKey<Block> BUSH_PLANTABLE_ON = Blocks.tag("bush_plantable_on");
        public static final TagKey<Block> DRY_PLANT_PLANTABLE_ON = Blocks.tag("dry_plant_plantable_on");
        public static final TagKey<Block> EPIPHYTE_PLANTABLE_ON = Blocks.tag("epiphyte_plantable_on");
        public static final TagKey<Block> GRASS_PLANTABLE_ON = Blocks.tag("grass_plantable_on");
        public static final TagKey<Block> SEA_BUSH_PLANTABLE_ON = Blocks.tag("sea_bush_plantable_on");
        public static final TagKey<Block> HALOPHYTE_PLANTABLE_ON = Blocks.tag("halophyte_plantable_on");
        public static final TagKey<Block> CREEPING_STONE_PLANTABLE_ON = Blocks.tag("creeping_stone_plantable_on");
        public static final TagKey<Block> CREEPING_PLANT_NOT_PLANTABLE_ON = Blocks.tag("creeping_plant_not_plantable_on");
        public static final TagKey<Block> RABBIT_RAIDABLE = Blocks.tag("rabbit_raidable");
        public static final TagKey<Block> FOX_RAIDABLE = Blocks.tag("fox_raidable");
        public static final TagKey<Block> PET_SITS_ON = Blocks.tag("pet_sits_on");
        public static final TagKey<Block> MONSTER_SPAWNS_ON = Blocks.tag("monster_spawns_on");
        public static final TagKey<Block> CONSUMES_TOOL_DURABILITY = Blocks.tag("consumes_tool_durability");
        public static final TagKey<Block> NATURAL_REGROWING_PLANTS = Blocks.tag("natural_regrowing_plants");
        public static final TagKey<Block> ANIMAL_IGNORED_PLANTS = Blocks.tag("animal_ignored_plants");
        public static final TagKey<Block> BEAR_CRAWLS_ON = Blocks.tag("bear_crawls_on");
        public static final TagKey<Block> CLAY_INDICATORS = Blocks.tag("clay_indicators");
        public static final TagKey<Block> SALT_WATER_CORAL_PLANTS = Blocks.tag("salt_water_coral_plants");
        public static final TagKey<Block> SALT_WATER_CORALS = Blocks.tag("salt_water_corals");
        public static final TagKey<Block> SALT_WATER_WALL_CORALS = Blocks.tag("salt_water_wall_corals");
        public static final TagKey<Block> HALOPHYTE = Blocks.tag("halophyte");
        public static final TagKey<Block> SINGLE_BLOCK_REPLACEABLE = Blocks.tag("single_block_replaceable");
        public static final TagKey<Block> TIDE_POOL_BLOCKS = Blocks.tag("tide_pool_blocks");
        public static final TagKey<Block> KAOLIN_CLAY_REPLACEABLE = Blocks.tag("kaolin_clay_replaceable");
        public static final TagKey<Block> POWDER_SNOW_REPLACEABLE = Blocks.tag("powder_snow_replaceable");
        public static final TagKey<Block> COLD_OCEAN_BLOCKS = Blocks.tag("cold_ocean_blocks");
        public static final TagKey<Block> SEA_STACK_ROCKS = Blocks.tag("sea_stack_rocks");
        public static final TagKey<Block> THERMOMETER_READABLE = Blocks.tag("thermometer_readable");

        private static TagKey<Block> tag(String name) {
            return TagKey.create((ResourceKey)Registries.BLOCK, (ResourceLocation)Helpers.identifier(name));
        }

        private static TagKey<Block> commonTag(String name) {
            return TagKey.create((ResourceKey)Registries.BLOCK, (ResourceLocation)ResourceLocation.fromNamespaceAndPath((String)"c", (String)name));
        }
    }
}

