/*
 * Decompiled with CFR 0.152.
 */
package net.dries007.tfc.common.blockentities;

import java.util.List;
import net.dries007.tfc.client.particle.TFCParticles;
import net.dries007.tfc.common.TFCTags;
import net.dries007.tfc.common.blockentities.InventoryBlockEntity;
import net.dries007.tfc.common.blockentities.TickableInventoryBlockEntity;
import net.dries007.tfc.common.blocks.devices.FirepitBlock;
import net.dries007.tfc.common.component.heat.HeatCapability;
import net.dries007.tfc.common.items.Powder;
import net.dries007.tfc.common.items.TFCItems;
import net.dries007.tfc.util.Helpers;
import net.dries007.tfc.util.SyncableContainerData;
import net.dries007.tfc.util.calendar.ICalendarTickable;
import net.dries007.tfc.util.data.Fuel;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.HolderLookup;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.util.Mth;
import net.minecraft.util.RandomSource;
import net.minecraft.world.MenuProvider;
import net.minecraft.world.inventory.ContainerData;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.phys.AABB;
import net.neoforged.neoforge.common.util.INBTSerializable;
import net.neoforged.neoforge.items.IItemHandler;
import net.neoforged.neoforge.items.IItemHandlerModifiable;

public abstract class AbstractFirepitBlockEntity<C extends IItemHandlerModifiable & INBTSerializable<CompoundTag>>
extends TickableInventoryBlockEntity<C>
implements ICalendarTickable,
MenuProvider {
    public static final int SLOT_FUEL_CONSUME = 0;
    public static final int SLOT_FUEL_2 = 1;
    public static final int SLOT_FUEL_3 = 2;
    public static final int SLOT_FUEL_INPUT = 3;
    protected final SyncableContainerData syncableData;
    protected boolean needsSlotUpdate = false;
    protected boolean needsRecipeUpdate = false;
    protected int burnTicks = 0;
    protected int airTicks;
    protected float burnTemperature = 0.0f;
    protected float temperature = 0.0f;
    private long lastPlayerTick = Integer.MIN_VALUE;
    private float dirtiness = 0.0f;
    private int lastMaxBurnTicks = Integer.MAX_VALUE;
    private int ash = 0;

    public static void convertTo(LevelAccessor level, BlockPos pos, BlockState state, AbstractFirepitBlockEntity<?> firepit, Block newBlock) {
        firepit.ejectMainInventory();
        List<ItemStack> saved = Helpers.copyToAndClear(firepit.inventory);
        BlockState newState = Helpers.copyProperties(newBlock.defaultBlockState(), state);
        level.setBlock(pos, newState, 3);
        Helpers.playPlaceSound(null, level, pos, newState);
        BlockEntity newEntity = level.getBlockEntity(pos);
        if (newEntity instanceof AbstractFirepitBlockEntity) {
            AbstractFirepitBlockEntity newFirepit = (AbstractFirepitBlockEntity)newEntity;
            Helpers.copyFrom(saved, newFirepit.inventory);
            newFirepit.copyFrom(firepit);
        }
    }

    public static void serverTick(Level level, BlockPos pos, BlockState state, AbstractFirepitBlockEntity<?> firepit) {
        firepit.checkForLastTickSync();
        firepit.checkForCalendarUpdate();
        if (firepit.needsRecipeUpdate) {
            firepit.needsRecipeUpdate = false;
            firepit.updateCachedRecipe();
        }
        if (level.getGameTime() % 20L == 0L) {
            AABB bounds = new AABB((double)pos.getX(), (double)pos.getY(), (double)pos.getZ(), (double)(pos.getX() + 1), (double)pos.getY() + 0.5, (double)(pos.getZ() + 1));
            Helpers.gatherAndConsumeItems(level, bounds, (IItemHandler)firepit.inventory, 0, 3);
            firepit.updateSmokeLevel(state);
        }
        boolean isRaining = level.isRainingAt(pos);
        if (((Boolean)state.getValue((Property)FirepitBlock.LIT)).booleanValue()) {
            if (firepit.burnTicks > 0) {
                firepit.burnTicks = firepit.burnTicks - (firepit.airTicks > 0 || isRaining ? 2 : 1);
                if (firepit.burnTicks <= 0) {
                    firepit.markForSync();
                }
            }
            if (firepit.burnTicks <= 0 && !firepit.consumeFuel()) {
                firepit.extinguish(state);
            }
        }
        if (firepit.airTicks > 0) {
            --firepit.airTicks;
            if (firepit.airTicks <= 0) {
                firepit.markForSync();
            }
        }
        if (firepit.temperature > 0.0f || firepit.burnTemperature > 0.0f) {
            firepit.temperature = HeatCapability.adjustDeviceTemp(firepit.temperature, firepit.burnTemperature, firepit.airTicks, isRaining);
        }
        HeatCapability.provideHeatTo(level, pos.above(), Direction.DOWN, firepit.temperature);
        firepit.handleCooking();
        if (firepit.needsSlotUpdate) {
            firepit.cascadeFuelSlots();
        }
    }

    public static void clientTick(Level level, BlockPos pos, BlockState state, AbstractFirepitBlockEntity<?> firepit) {
        if (((Boolean)state.getValue((Property)FirepitBlock.LIT)).booleanValue() && firepit.burnTicks > 0) {
            firepit.burnTicks = firepit.burnTicks - (firepit.airTicks > 0 || level.isRainingAt(pos) ? 2 : 1);
        }
        if (firepit.airTicks > 0) {
            --firepit.airTicks;
        }
        RandomSource random = level.getRandom();
        int smoke = (Integer)state.getValue((Property)FirepitBlock.SMOKE_LEVEL);
        Block block = state.getBlock();
        if (block instanceof FirepitBlock) {
            FirepitBlock block2 = (FirepitBlock)block;
            if (((Boolean)state.getValue((Property)FirepitBlock.LIT)).booleanValue() && random.nextInt(9 - smoke) == 0) {
                double x = (double)pos.getX() + 0.5;
                double y = (double)pos.getY() + block2.getParticleHeightOffset();
                double z = (double)pos.getZ() + 0.5;
                for (int i = 0; i < 1 + random.nextInt(3); ++i) {
                    level.addAlwaysVisibleParticle((ParticleOptions)TFCParticles.SMOKES.get(smoke).get(), x + (double)(Helpers.triangle(random) * 0.5f), y + random.nextDouble(), z + (double)(Helpers.triangle(random) * 0.5f), 0.0, 0.07, 0.0);
                }
            }
        }
    }

    public AbstractFirepitBlockEntity(BlockEntityType<?> type, BlockPos pos, BlockState state, InventoryBlockEntity.InventoryFactory<C> inventoryFactory) {
        super(type, pos, state, inventoryFactory);
        this.syncableData = new SyncableContainerData().add(() -> (int)this.temperature, value -> {
            this.temperature = value;
        });
    }

    @Override
    public void loadAdditional(CompoundTag nbt, HolderLookup.Provider provider) {
        this.temperature = nbt.getFloat("temperature");
        this.burnTicks = nbt.getInt("burnTicks");
        this.airTicks = nbt.getInt("airTicks");
        this.burnTemperature = nbt.getFloat("burnTemperature");
        this.lastPlayerTick = nbt.getLong("lastPlayerTick");
        this.dirtiness = nbt.getFloat("dirtiness");
        this.lastMaxBurnTicks = nbt.getInt("lastMaxBurnTicks");
        this.ash = nbt.getInt("ash");
        this.needsRecipeUpdate = true;
        super.loadAdditional(nbt, provider);
    }

    @Override
    public void saveAdditional(CompoundTag nbt, HolderLookup.Provider provider) {
        nbt.putFloat("temperature", this.temperature);
        nbt.putInt("burnTicks", this.burnTicks);
        nbt.putInt("airTicks", this.airTicks);
        nbt.putFloat("burnTemperature", this.burnTemperature);
        nbt.putLong("lastPlayerTick", this.lastPlayerTick);
        nbt.putFloat("dirtiness", this.dirtiness);
        nbt.putInt("lastMaxBurnTicks", this.lastMaxBurnTicks);
        nbt.putInt("ash", this.ash);
        super.saveAdditional(nbt, provider);
    }

    @Override
    public void setAndUpdateSlots(int slot) {
        super.setAndUpdateSlots(slot);
        this.needsSlotUpdate = true;
        this.updateCachedRecipe();
        this.markForSync();
    }

    @Override
    public void onCalendarUpdate(long ticks) {
        assert (this.level != null);
        if (((Boolean)this.level.getBlockState(this.worldPosition).getValue((Property)FirepitBlock.LIT)).booleanValue()) {
            HeatCapability.Remainder remainder = HeatCapability.consumeFuelForTicks(ticks, this.inventory, this.burnTicks, this.burnTemperature, 0, 3);
            this.burnTicks = remainder.burnTicks();
            this.burnTemperature = remainder.burnTemperature();
            this.needsSlotUpdate = true;
            if (remainder.ticks() > 0L) {
                this.extinguish(this.level.getBlockState(this.worldPosition));
                this.coolInstantly();
            }
        }
    }

    @Override
    @Deprecated
    public long getLastCalendarUpdateTick() {
        return this.lastPlayerTick;
    }

    @Override
    @Deprecated
    public void setLastCalendarUpdateTick(long tick) {
        this.lastPlayerTick = tick;
    }

    public void updateSmokeLevel(BlockState state) {
        assert (this.level != null);
        this.dirtiness = Mth.clamp((float)(0.99f * this.dirtiness), (float)0.0f, (float)1.0f);
        int wantedSmokeLevel = Mth.ceil((float)Mth.map((float)this.dirtiness, (float)0.0f, (float)1.0f, (float)0.0f, (float)4.0f));
        if (state.hasProperty((Property)FirepitBlock.SMOKE_LEVEL) && (Integer)state.getValue((Property)FirepitBlock.SMOKE_LEVEL) != wantedSmokeLevel) {
            this.level.setBlockAndUpdate(this.worldPosition, (BlockState)state.setValue((Property)FirepitBlock.SMOKE_LEVEL, (Comparable)Integer.valueOf(wantedSmokeLevel)));
        }
    }

    public void intakeAir(int amount) {
        this.airTicks += amount;
        if (this.airTicks > 600) {
            this.airTicks = 600;
        }
    }

    public void extinguish(BlockState state) {
        assert (this.level != null);
        if (((Boolean)state.getValue((Property)FirepitBlock.LIT)).booleanValue()) {
            Helpers.playSound(this.level, this.worldPosition, SoundEvents.FIRE_EXTINGUISH);
            this.level.setBlockAndUpdate(this.worldPosition, (BlockState)state.setValue((Property)FirepitBlock.LIT, (Comparable)Boolean.valueOf(false)));
            this.burnTicks = 0;
            this.airTicks = 0;
            this.burnTemperature = 0.0f;
            this.dirtiness = 0.0f;
        }
    }

    public boolean light(BlockState state) {
        assert (this.level != null);
        if (this.burnTicks > 0) {
            return true;
        }
        if (this.consumeFuel()) {
            this.level.setBlockAndUpdate(this.worldPosition, (BlockState)state.setValue((Property)FirepitBlock.LIT, (Comparable)Boolean.valueOf(true)));
            return true;
        }
        return false;
    }

    public void ejectMainInventory() {
        assert (this.level != null);
        for (int i = 4; i < this.inventory.getSlots(); ++i) {
            ItemStack stack = Helpers.removeStack((IItemHandler)this.inventory, i);
            if (stack.isEmpty()) continue;
            Helpers.spawnItem(this.level, this.worldPosition, stack, 0.7);
        }
    }

    public void copyFrom(AbstractFirepitBlockEntity<?> other) {
        this.burnTicks = other.burnTicks;
        this.airTicks = other.airTicks;
        this.burnTemperature = other.burnTemperature;
        this.temperature = other.temperature;
        this.needsSlotUpdate = true;
    }

    @Override
    public int getSlotStackLimit(int slot) {
        return slot == 5 || slot == 6 ? 64 : 1;
    }

    @Override
    public boolean isItemValid(int slot, ItemStack stack) {
        return switch (slot) {
            case 3 -> {
                if (Fuel.get(stack) != null && Helpers.isItem(stack.getItem(), TFCTags.Items.FIREPIT_FUEL)) {
                    yield true;
                }
                yield false;
            }
            case 4 -> HeatCapability.has(stack);
            case 5, 6 -> true;
            default -> false;
        };
    }

    public float getTemperature() {
        return this.temperature;
    }

    public ContainerData getSyncableData() {
        return this.syncableData;
    }

    protected boolean consumeFuel() {
        assert (this.level != null);
        ItemStack fuelStack = this.inventory.getStackInSlot(0);
        if (!fuelStack.isEmpty()) {
            this.inventory.setStackInSlot(0, ItemStack.EMPTY);
            this.needsSlotUpdate = true;
            Fuel fuel = Fuel.get(fuelStack);
            if (fuel != null) {
                this.burnTicks += fuel.duration();
                this.lastMaxBurnTicks = fuel.duration();
                this.burnTemperature = fuel.temperature();
                this.dirtiness += 1.0f - fuel.purity();
            }
            if (this.level.random.nextFloat() < 0.5f) {
                this.addAsh(1);
            }
            this.markForSync();
        }
        return this.burnTicks > 0;
    }

    protected abstract void handleCooking();

    protected abstract void coolInstantly();

    protected abstract void updateCachedRecipe();

    protected void cascadeFuelSlots() {
        int lowestOpenSlot = 0;
        for (int i = 0; i <= 3; ++i) {
            ItemStack stack = this.inventory.getStackInSlot(i);
            if (stack.isEmpty()) continue;
            if (i > lowestOpenSlot) {
                this.inventory.setStackInSlot(lowestOpenSlot, stack.copy());
                this.inventory.setStackInSlot(i, ItemStack.EMPTY);
            }
            ++lowestOpenSlot;
        }
        this.markForSync();
        this.needsSlotUpdate = false;
    }

    public BurnStage getBurnStage(int slot) {
        if (this.burnTemperature < 1.0f || this.temperature < 1.0f) {
            return slot < 2 ? BurnStage.COLD : BurnStage.FRESH;
        }
        float pctFromFirepitTemp = Math.min(1.0f, this.temperature / this.burnTemperature);
        if (pctFromFirepitTemp < 0.1f) {
            return slot < 2 ? BurnStage.COLD : BurnStage.FRESH;
        }
        float lastMaxBurnTicks = (float)this.lastMaxBurnTicks < 1.0f ? 1500.0f : (float)this.lastMaxBurnTicks;
        float pctFromBurnTicks = Math.min(1.0f, (float)this.burnTicks / lastMaxBurnTicks);
        if (slot == 0) {
            return BurnStage.HEAT_STAGES[Math.round(pctFromFirepitTemp * 3.0f)];
        }
        if (slot == 1) {
            return BurnStage.HEAT_STAGES[Math.round(2.0f * pctFromFirepitTemp + pctFromBurnTicks)];
        }
        if (slot == 2) {
            return BurnStage.HEAT_STAGES[Math.round(pctFromFirepitTemp + 2.0f * pctFromBurnTicks)];
        }
        if (slot == 3) {
            return BurnStage.HEAT_STAGES[Math.round(3.0f * pctFromBurnTicks)];
        }
        return BurnStage.FRESH;
    }

    public int getAsh() {
        return this.ash;
    }

    public void setAsh(int ash) {
        this.ash = ash;
    }

    public void addAsh(int ash) {
        this.ash = Math.min(8, ash);
    }

    @Override
    public void ejectInventory() {
        assert (this.level != null);
        super.ejectInventory();
        if (this.ash > 0) {
            Helpers.spawnItem(this.level, this.worldPosition, new ItemStack((ItemLike)TFCItems.POWDERS.get((Object)Powder.WOOD_ASH).get(), this.ash));
        }
    }

    public static enum BurnStage {
        FRESH,
        DRIED,
        RED,
        WHITE,
        COLD;

        private static final BurnStage[] HEAT_STAGES;

        static {
            HEAT_STAGES = new BurnStage[]{FRESH, DRIED, RED, WHITE};
        }
    }
}

