/*
 * Decompiled with CFR 0.152.
 */
package net.dries007.tfc.common.blockentities;

import net.dries007.tfc.common.blockentities.TFCBlockEntities;
import net.dries007.tfc.common.blockentities.TickableBlockEntity;
import net.dries007.tfc.util.climate.Climate;
import net.minecraft.core.BlockPos;
import net.minecraft.core.HolderLookup;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.util.Mth;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockState;

public class AnemometerBlockEntity
extends TickableBlockEntity {
    public static final float MAX_SPEED = 1.0f;
    private static final float LERP_SPEED = 0.003141593f;
    private float targetSpeed;
    private float actualSpeed;
    private float windSpeed;
    float angle = 0.0f;
    boolean needsUpdate = false;

    protected AnemometerBlockEntity(BlockEntityType<?> type, BlockPos pos, BlockState state) {
        super(type, pos, state);
    }

    public AnemometerBlockEntity(BlockPos pos, BlockState state) {
        this((BlockEntityType)TFCBlockEntities.ANEMOMETER.get(), pos, state);
    }

    public static void serverTick(Level level, BlockPos pos, BlockState state, AnemometerBlockEntity anemometer) {
        if (anemometer.needsUpdate) {
            anemometer.markForSync();
            anemometer.needsUpdate = false;
        }
        if (level.getGameTime() % 40L == 0L) {
            float wind = Climate.get(level).getWind(level, pos).length();
            anemometer.actualSpeed = AnemometerBlockEntity.windToVisualSpeed(wind);
            if (anemometer.windSpeed != wind) {
                anemometer.windSpeed = wind;
                level.updateNeighborsAt(pos, state.getBlock());
                level.updateNeighborsAt(pos.below(), state.getBlock());
            }
        }
    }

    public static void clientTick(Level level, BlockPos pos, BlockState state, AnemometerBlockEntity anemometer) {
        float currentSpeed;
        float targetSpeed;
        anemometer.angle += anemometer.actualSpeed;
        if (level.getGameTime() % 40L == 0L) {
            float wind = Climate.get(level).getWind(level, pos).length();
            anemometer.targetSpeed = AnemometerBlockEntity.windToVisualSpeed(wind);
        }
        anemometer.actualSpeed = (targetSpeed = anemometer.targetSpeed) > (currentSpeed = anemometer.actualSpeed) ? Math.min(targetSpeed, currentSpeed + 0.003141593f) : Math.max(targetSpeed, currentSpeed - 0.003141593f);
    }

    private static float windToVisualSpeed(float wind) {
        return Mth.clampedMap((float)wind, (float)0.0f, (float)0.5f, (float)0.0f, (float)1.0f);
    }

    public float getAngle(float partialTick) {
        return this.angle + this.actualSpeed * partialTick;
    }

    public int getRedstoneSignal() {
        return Math.clamp((long)Mth.floor((float)(this.windSpeed * 16.0f)), 0, 15);
    }

    @Override
    public void saveAdditional(CompoundTag tag, HolderLookup.Provider provider) {
        super.saveAdditional(tag, provider);
        tag.putFloat("actualSpeed", this.actualSpeed);
    }

    @Override
    public void loadAdditional(CompoundTag tag, HolderLookup.Provider provider) {
        super.loadAdditional(tag, provider);
        this.actualSpeed = tag.getFloat("actualSpeed");
        this.needsUpdate = true;
    }
}

