/*
 * Decompiled with CFR 0.152.
 */
package net.dries007.tfc.common.blockentities;

import java.util.List;
import net.dries007.tfc.client.TFCSounds;
import net.dries007.tfc.client.particle.TFCParticles;
import net.dries007.tfc.common.TFCTags;
import net.dries007.tfc.common.blockentities.InventoryBlockEntity;
import net.dries007.tfc.common.blockentities.TFCBlockEntities;
import net.dries007.tfc.common.blocks.devices.Tiered;
import net.dries007.tfc.common.capabilities.InventoryItemHandler;
import net.dries007.tfc.common.component.forge.ForgeRule;
import net.dries007.tfc.common.component.forge.ForgeStep;
import net.dries007.tfc.common.component.forge.Forging;
import net.dries007.tfc.common.component.forge.ForgingBonus;
import net.dries007.tfc.common.component.forge.ForgingBonusComponent;
import net.dries007.tfc.common.component.forge.ForgingCapability;
import net.dries007.tfc.common.component.heat.HeatCapability;
import net.dries007.tfc.common.component.heat.IHeat;
import net.dries007.tfc.common.container.AnvilContainer;
import net.dries007.tfc.common.container.AnvilPlanContainer;
import net.dries007.tfc.common.container.ISlotCallback;
import net.dries007.tfc.common.recipes.AnvilRecipe;
import net.dries007.tfc.common.recipes.RecipeHelpers;
import net.dries007.tfc.common.recipes.TFCRecipeTypes;
import net.dries007.tfc.common.recipes.WeldingRecipe;
import net.dries007.tfc.common.recipes.input.NonEmptyInput;
import net.dries007.tfc.util.Helpers;
import net.dries007.tfc.util.SelfTests;
import net.dries007.tfc.util.advancements.TFCAdvancements;
import net.minecraft.core.BlockPos;
import net.minecraft.core.HolderLookup;
import net.minecraft.core.NonNullList;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.SimpleParticleType;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.util.Mth;
import net.minecraft.util.RandomSource;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.MenuProvider;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.Recipe;
import net.minecraft.world.item.crafting.RecipeHolder;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockState;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class AnvilBlockEntity
extends InventoryBlockEntity<AnvilInventory>
implements ISlotCallback {
    public static final int SLOT_INPUT_MAIN = 0;
    public static final int SLOT_INPUT_SECOND = 1;
    public static final int SLOT_HAMMER = 2;
    public static final int SLOT_CATALYST = 3;
    public static final int[] SLOTS_BY_HAND_EXTRACT = new int[]{0, 1};
    public static final int[] SLOTS_BY_HAND_INSERT = new int[]{3, 0, 1};
    @Nullable
    private ResourceLocation lastRecipe = null;

    public AnvilBlockEntity(BlockPos pos, BlockState state) {
        this((BlockEntityType<? extends AnvilBlockEntity>)((BlockEntityType)TFCBlockEntities.ANVIL.get()), pos, state, AnvilInventory::new);
    }

    public AnvilBlockEntity(BlockEntityType<? extends AnvilBlockEntity> type, BlockPos pos, BlockState state, InventoryBlockEntity.InventoryFactory<AnvilInventory> inventoryFactory) {
        super(type, pos, state, inventoryFactory);
    }

    public Forging getMainInputForging() {
        return ForgingCapability.get(((AnvilInventory)this.inventory).getStackInSlot(0));
    }

    public MenuProvider planProvider() {
        return new MenuProvider(){

            public Component getDisplayName() {
                return AnvilBlockEntity.this.getDisplayName();
            }

            @Nullable
            public AbstractContainerMenu createMenu(int containerId, Inventory playerInventory, Player player) {
                return AnvilBlockEntity.this.createPlanContainer(containerId, playerInventory, player);
            }

            public boolean shouldTriggerClientSideContainerClosingOnOpen() {
                return false;
            }
        };
    }

    public MenuProvider anvilProvider() {
        return this;
    }

    @Override
    @Nullable
    public AbstractContainerMenu createMenu(int containerId, Inventory inventory, Player player) {
        return AnvilContainer.create(this, player.getInventory(), containerId);
    }

    public boolean shouldTriggerClientSideContainerClosingOnOpen() {
        return false;
    }

    @Nullable
    public AbstractContainerMenu createPlanContainer(int containerId, Inventory inventory, Player player) {
        return AnvilPlanContainer.create(this, player.getInventory(), containerId);
    }

    @Override
    public boolean isItemValid(int slot, ItemStack stack) {
        return switch (slot) {
            case 0, 1 -> true;
            case 2 -> Helpers.isItem(stack, TFCTags.Items.TOOLS_HAMMER);
            case 3 -> Helpers.isItem(stack, TFCTags.Items.WELDING_FLUX);
            default -> false;
        };
    }

    @Override
    public int getSlotStackLimit(int slot) {
        return slot == 3 ? 64 : 1;
    }

    @Override
    public void onSlotTake(Player player, int slot, ItemStack stack) {
        if (slot == 0) {
            ForgingCapability.clearRecipeIfNotWorked(stack);
        }
    }

    @Override
    public void loadAdditional(CompoundTag nbt, HolderLookup.Provider provider) {
        super.loadAdditional(nbt, provider);
        if (nbt.contains("lastRecipe", 8)) {
            this.lastRecipe = ResourceLocation.tryParse((String)nbt.getString("lastRecipe"));
        }
    }

    @Override
    public void saveAdditional(CompoundTag nbt, HolderLookup.Provider provider) {
        super.saveAdditional(nbt, provider);
        if (this.lastRecipe != null) {
            nbt.putString("lastRecipe", this.lastRecipe.toString());
        }
    }

    @Override
    public void setAndUpdateSlots(int slot) {
        Forging forge;
        AnvilRecipe recipe;
        assert (this.level != null);
        ItemStack stack = ((AnvilInventory)this.inventory).getStackInSlot(0);
        if (!stack.isEmpty() && (recipe = (forge = ForgingCapability.get(stack)).getRecipe()) == null && !this.level.isClientSide) {
            List<RecipeHolder<AnvilRecipe>> all = AnvilRecipe.getAll(this.level, stack, this.getTier());
            if (all.size() == 1) {
                forge.setRecipe((RecipeHolder<AnvilRecipe>)((RecipeHolder)all.iterator().next()), (AnvilRecipe.Inventory)this.inventory);
            } else if (this.lastRecipe != null) {
                all.stream().filter(r -> r.id().equals((Object)this.lastRecipe)).findAny().ifPresent(r -> forge.setRecipe((RecipeHolder<AnvilRecipe>)r, (AnvilRecipe.Inventory)this.inventory));
            }
        }
        this.setChanged();
    }

    @Override
    public void ejectInventory() {
        ForgingCapability.clearRecipeIfNotWorked(((AnvilInventory)this.inventory).getStackInSlot(0));
        super.ejectInventory();
    }

    public void chooseRecipe(ResourceLocation recipeId) {
        assert (this.level != null);
        @Nullable AnvilRecipe recipe = AnvilRecipe.byId(recipeId);
        ItemStack stack = ((AnvilInventory)this.inventory).getStackInSlot(0);
        if (!stack.isEmpty() && recipe != null) {
            ForgingCapability.get(stack).setRecipe((RecipeHolder<AnvilRecipe>)new RecipeHolder(recipeId, (Recipe)recipe), (AnvilRecipe.Inventory)this.inventory);
            this.lastRecipe = recipeId;
        }
    }

    public void work(ServerPlayer player, ForgeStep step) {
        assert (this.level != null);
        ItemStack stack = ((AnvilInventory)this.inventory).getStackInSlot(0);
        Forging forge = ForgingCapability.get(stack);
        ItemStack hammer = ((AnvilInventory)this.inventory).getStackInSlot(2);
        if (!Helpers.isItem(hammer, TFCTags.Items.TOOLS_HAMMER)) {
            hammer = ItemStack.EMPTY;
        }
        InteractionHand hammerSlot = null;
        if (hammer.isEmpty()) {
            hammer = Helpers.isItem(player.getMainHandItem(), TFCTags.Items.TOOLS_HAMMER) ? player.getMainHandItem() : ItemStack.EMPTY;
            hammerSlot = InteractionHand.MAIN_HAND;
        }
        if (hammer.isEmpty()) {
            hammer = Helpers.isItem(player.getOffhandItem(), TFCTags.Items.TOOLS_HAMMER) ? player.getOffhandItem() : ItemStack.EMPTY;
            hammerSlot = InteractionHand.OFF_HAND;
        }
        if (hammer.isEmpty()) {
            player.displayClientMessage((Component)Component.translatable((String)"tfc.tooltip.hammer_required_to_work"), false);
            return;
        }
        if (!forge.isWorked() && forge.work() == 0 && step.step() < 0) {
            return;
        }
        AnvilRecipe recipe = forge.getRecipe();
        if (recipe != null) {
            if (!recipe.matches((AnvilRecipe.Inventory)this.inventory, this.level)) {
                player.displayClientMessage((Component)Component.translatable((String)"tfc.tooltip.anvil_is_too_low_tier_to_work"), false);
                return;
            }
            @Nullable IHeat heat = HeatCapability.get(stack);
            if (heat != null && !heat.canWork()) {
                player.displayClientMessage((Component)Component.translatable((String)"tfc.tooltip.not_hot_enough_to_work"), false);
                return;
            }
            forge.addStep(step);
            Helpers.damageItem(hammer, (LivingEntity)player, hammerSlot);
            if (forge.work() < 0 || forge.work() > 150) {
                ((AnvilInventory)this.inventory).setStackInSlot(0, ItemStack.EMPTY);
                this.level.playSound(null, this.worldPosition, SoundEvents.ANVIL_DESTROY, SoundSource.PLAYERS, 0.4f, 1.0f);
                return;
            }
            this.createForgingEffects();
            if (recipe.checkComplete((AnvilRecipe.Inventory)this.inventory)) {
                ItemStack outputStack = recipe.assemble((AnvilRecipe.Inventory)this.inventory, (HolderLookup.Provider)this.level.registryAccess());
                @Nullable IHeat outputHeat = HeatCapability.get(outputStack);
                if (outputHeat != null) {
                    outputHeat.setTemperatureIfWarmer(heat);
                }
                if (recipe.shouldApplyForgingBonus()) {
                    float ratio = (float)forge.totalWorked() / (float)ForgeRule.calculateOptimalStepsToTarget(recipe.computeTarget((AnvilRecipe.Inventory)this.inventory), recipe.getRules());
                    ForgingBonus bonus = ForgingBonus.byRatio(ratio);
                    ForgingBonusComponent.set(outputStack, bonus, (Player)player);
                    if (bonus == ForgingBonus.PERFECT) {
                        TFCAdvancements.PERFECTLY_FORGED.trigger(player);
                    }
                }
                ((AnvilInventory)this.inventory).setStackInSlot(0, outputStack);
            }
            this.markForSync();
        }
    }

    public boolean workRemotely(ForgeStep step, int movement, boolean forceCompletion) {
        assert (this.level != null);
        if (this.level.isClientSide) {
            return false;
        }
        ItemStack stack = ((AnvilInventory)this.inventory).getStackInSlot(0);
        Forging forge = ForgingCapability.get(stack);
        if (!forge.isWorked() && forge.work() == 0 && movement < 0) {
            return false;
        }
        AnvilRecipe recipe = forge.getRecipe();
        if (recipe != null) {
            if (!recipe.matches((AnvilRecipe.Inventory)this.inventory, this.level)) {
                return false;
            }
            @Nullable IHeat heat = HeatCapability.get(stack);
            if (heat != null && !heat.canWork()) {
                return false;
            }
            if (forceCompletion) {
                int target = recipe.computeTarget((AnvilRecipe.Inventory)this.inventory);
                int cursor = forge.work();
                if (movement > 0 && cursor > target || movement < 0 && cursor < target) {
                    movement = -movement;
                }
                if (movement > 0 && cursor + movement > target || movement < 0 && cursor + movement < target) {
                    movement = target - cursor;
                }
            }
            forge.addStep(step, movement);
            if (forge.work() < 0 || forge.work() > 150) {
                ((AnvilInventory)this.inventory).setStackInSlot(0, ItemStack.EMPTY);
                this.level.playSound(null, this.worldPosition, SoundEvents.ANVIL_DESTROY, SoundSource.PLAYERS, 0.4f, 1.0f);
                return true;
            }
            this.createForgingEffects();
            if (recipe.checkComplete((AnvilRecipe.Inventory)this.inventory)) {
                ItemStack outputStack = recipe.assemble((AnvilRecipe.Inventory)this.inventory, (HolderLookup.Provider)this.level.registryAccess());
                @Nullable IHeat outputHeat = HeatCapability.get(outputStack);
                if (outputHeat != null) {
                    outputHeat.setTemperatureIfWarmer(heat);
                }
                ((AnvilInventory)this.inventory).setStackInSlot(0, outputStack);
            }
            this.markForSync();
        }
        return true;
    }

    private void createForgingEffects() {
        assert (this.level != null);
        this.level.playSound(null, this.worldPosition, (SoundEvent)TFCSounds.ANVIL_HIT.get(), SoundSource.PLAYERS, 0.4f, 1.0f);
        Level level = this.level;
        if (level instanceof ServerLevel) {
            ServerLevel server = (ServerLevel)level;
            double x = (double)this.worldPosition.getX() + Mth.nextDouble((RandomSource)this.level.random, (double)0.2, (double)0.8);
            double z = (double)this.worldPosition.getZ() + Mth.nextDouble((RandomSource)this.level.random, (double)0.2, (double)0.8);
            double y = (double)this.worldPosition.getY() + Mth.nextDouble((RandomSource)this.level.random, (double)0.8, (double)1.0);
            server.sendParticles((ParticleOptions)((SimpleParticleType)TFCParticles.SPARK.get()), x, y, z, 5, 0.0, 0.0, 0.0, (double)0.2f);
        }
    }

    public InteractionResult weld(Player player) {
        ItemStack left = ((AnvilInventory)this.inventory).getLeft();
        ItemStack right = ((AnvilInventory)this.inventory).getRight();
        if (left.isEmpty() && right.isEmpty()) {
            return InteractionResult.PASS;
        }
        assert (this.level != null);
        WeldingRecipe recipe = (WeldingRecipe)RecipeHelpers.unbox(RecipeHelpers.getHolder(this.level, TFCRecipeTypes.WELDING, (WeldingRecipe.Inventory)this.inventory));
        if (recipe != null) {
            if (!recipe.isCorrectTier(this.getTier())) {
                player.displayClientMessage((Component)Component.translatable((String)"tfc.tooltip.anvil_is_too_low_tier_to_weld"), true);
                return InteractionResult.FAIL;
            }
            @Nullable IHeat leftHeat = HeatCapability.get(left);
            @Nullable IHeat rightHeat = HeatCapability.get(right);
            if (leftHeat != null && !leftHeat.canWeld() || rightHeat != null && !rightHeat.canWeld()) {
                player.displayClientMessage((Component)Component.translatable((String)"tfc.tooltip.not_hot_enough_to_weld"), true);
                return InteractionResult.FAIL;
            }
            if (((AnvilInventory)this.inventory).getStackInSlot(3).isEmpty()) {
                player.displayClientMessage((Component)Component.translatable((String)"tfc.tooltip.no_flux_to_weld"), true);
                return InteractionResult.FAIL;
            }
            ItemStack result = recipe.assemble((WeldingRecipe.Inventory)this.inventory);
            @Nullable IHeat resultHeat = HeatCapability.get(result);
            ((AnvilInventory)this.inventory).setStackInSlot(0, result);
            ((AnvilInventory)this.inventory).setStackInSlot(1, ItemStack.EMPTY);
            ((AnvilInventory)this.inventory).getStackInSlot(3).shrink(1);
            if (resultHeat != null) {
                resultHeat.setTemperatureIfWarmer(leftHeat);
                resultHeat.setTemperatureIfWarmer(rightHeat);
            }
            this.markForSync();
            return InteractionResult.sidedSuccess((boolean)this.level.isClientSide);
        }
        return InteractionResult.PASS;
    }

    public int getTier() {
        int n;
        Block block = this.getBlockState().getBlock();
        if (block instanceof Tiered) {
            Tiered tiered = (Tiered)block;
            n = tiered.getTier();
        } else {
            n = 0;
        }
        return n;
    }

    public void setInventoryFromOutsideWorld(ItemStack main, ItemStack hammer, ItemStack flux) {
        NonNullList<ItemStack> internalStacks = ((AnvilInventory)this.inventory).getInternalStacks();
        internalStacks.set(0, (Object)main);
        internalStacks.set(2, (Object)hammer);
        internalStacks.set(3, (Object)flux);
    }

    public static class AnvilInventory
    extends InventoryItemHandler
    implements AnvilRecipe.Inventory,
    WeldingRecipe.Inventory,
    NonEmptyInput {
        private final AnvilBlockEntity anvil;

        public AnvilInventory(InventoryBlockEntity<AnvilInventory> anvil) {
            super(anvil, 4);
            this.anvil = (AnvilBlockEntity)anvil;
        }

        @Override
        public ItemStack getItem() {
            return this.getStackInSlot(0);
        }

        @Override
        public ItemStack getLeft() {
            return this.getStackInSlot(0);
        }

        @Override
        public ItemStack getRight() {
            return this.getStackInSlot(1);
        }

        @Override
        public int getTier() {
            return this.anvil.getTier();
        }

        @Override
        public long getSeed() {
            long l;
            SelfTests.warnWhenCalledFromClientThread();
            Level level = this.anvil.getLevel();
            if (level instanceof ServerLevel) {
                ServerLevel level2 = (ServerLevel)level;
                l = level2.getSeed();
            } else {
                l = 0L;
            }
            return l;
        }

        @NotNull
        public ItemStack extractItem(int slot, int amount, boolean simulate) {
            ItemStack stack = super.extractItem(slot, amount, simulate);
            ForgingCapability.clearRecipeIfNotWorked(stack);
            return stack;
        }
    }
}

