/*
 * Decompiled with CFR 0.152.
 */
package net.dries007.tfc.common.blockentities;

import java.util.List;
import net.dries007.tfc.client.TFCSounds;
import net.dries007.tfc.common.blockentities.TFCBlockEntities;
import net.dries007.tfc.common.blockentities.TFCBlockEntity;
import net.dries007.tfc.common.blockentities.rotation.CrankshaftBlockEntity;
import net.dries007.tfc.common.blocks.devices.BellowsBlock;
import net.dries007.tfc.common.blocks.devices.IBellowsConsumer;
import net.dries007.tfc.util.rotation.Rotation;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.HolderLookup;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundSource;
import net.minecraft.util.Mth;
import net.minecraft.world.ItemInteractionResult;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.MoverType;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.material.PushReaction;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.Vec3;
import org.jetbrains.annotations.Nullable;

public class BellowsBlockEntity
extends TFCBlockEntity {
    public static final int BELLOWS_AIR = 200;
    public static final int MAX_DEVICE_AIR_TICKS = 600;
    public static final float MIN_EXTENSION = 0.125f;
    public static final float MAX_EXTENSION = 0.625f;
    private long lastPushed = 0L;
    private boolean justPushed = false;

    public static void tickBoth(Level level, BlockPos pos, BlockState state, BellowsBlockEntity bellows) {
        @Nullable Rotation networkRotation = bellows.getCrankRotation();
        float extension = bellows.getExtensionLength(1.0f);
        if (extension > 0.575f && !bellows.justPushed && bellows.lastPushed + 20L < level.getGameTime() && networkRotation != null) {
            bellows.doPush();
            bellows.justPushed = true;
            bellows.lastPushed = level.getGameTime() - 20L + (long)Math.max(20, (int)(5.0265484f / networkRotation.speed()));
        } else if (bellows.justPushed) {
            bellows.justPushed = false;
            bellows.afterPush();
        }
        if (extension >= 0.625f) {
            return;
        }
        Direction direction = ((Direction)state.getValue((Property)BellowsBlock.FACING)).getOpposite();
        AABB bounds = state.getShape((BlockGetter)level, pos).bounds().move(pos);
        List list = level.getEntities(null, bounds);
        if (!list.isEmpty()) {
            for (Entity entity : list) {
                if (entity.getPistonPushReaction() == PushReaction.IGNORE) continue;
                entity.move(MoverType.SHULKER_BOX, new Vec3(0.1 * (double)direction.getStepX(), 0.0, 0.1 * (double)direction.getStepZ()));
            }
        }
    }

    public BellowsBlockEntity(BlockEntityType<?> type, BlockPos pos, BlockState state) {
        super(type, pos, state);
    }

    public BellowsBlockEntity(BlockPos pos, BlockState state) {
        this((BlockEntityType)TFCBlockEntities.BELLOWS.get(), pos, state);
    }

    public boolean isConnectedToNetwork() {
        return this.getCrankRotation() != null;
    }

    @Nullable
    public Rotation getCrankRotation() {
        CrankshaftBlockEntity crank = this.getCrankBlockEntity();
        return crank == null ? null : crank.getRotationNode().rotation();
    }

    @Nullable
    public CrankshaftBlockEntity getCrankBlockEntity() {
        return this.level == null ? null : CrankshaftBlockEntity.getCrankShaftAt((LevelAccessor)this.level, this.worldPosition, ((Direction)this.getBlockState().getValue((Property)BellowsBlock.FACING)).getOpposite());
    }

    @Override
    protected void saveAdditional(CompoundTag tag, HolderLookup.Provider provider) {
        super.saveAdditional(tag, provider);
        tag.putLong("pushed", this.lastPushed);
        tag.putBoolean("justPushed", this.justPushed);
    }

    @Override
    protected void loadAdditional(CompoundTag tag, HolderLookup.Provider provider) {
        super.loadAdditional(tag, provider);
        this.lastPushed = tag.getLong("pushed");
        this.justPushed = tag.getBoolean("justPushed");
    }

    public float getExtensionLength(float partialTick) {
        if (this.level == null) {
            return 0.125f;
        }
        CrankshaftBlockEntity entity = this.getCrankBlockEntity();
        if (entity != null) {
            return Mth.clamp((float)(0.125f + entity.getExtensionLength(partialTick)), (float)0.125f, (float)0.625f);
        }
        int time = (int)(this.level.getGameTime() - this.lastPushed);
        if (time < 10) {
            return (float)time * 0.05f + 0.125f;
        }
        if (time < 20) {
            return (float)(20 - time) * 0.05f + 0.125f;
        }
        return 0.125f;
    }

    public ItemInteractionResult onRightClick() {
        assert (this.level != null);
        if (this.level.getGameTime() - this.lastPushed < 20L || this.isConnectedToNetwork()) {
            return ItemInteractionResult.PASS_TO_DEFAULT_BLOCK_INTERACTION;
        }
        this.doPush();
        return ItemInteractionResult.sidedSuccess((boolean)this.level.isClientSide);
    }

    private void doPush() {
        assert (this.level != null);
        if (this.level.isClientSide) {
            return;
        }
        boolean foundAnyReceivers = false;
        boolean foundAnyAllowingReceivers = false;
        Direction direction = (Direction)this.getBlockState().getValue((Property)BellowsBlock.FACING);
        for (IBellowsConsumer.Offset offset : IBellowsConsumer.offsets()) {
            BlockPos airPosition = this.worldPosition.above(offset.up()).relative(direction, offset.out()).relative(direction.getClockWise(), offset.side());
            BlockState state = this.level.getBlockState(airPosition);
            Block block = state.getBlock();
            if (!(block instanceof IBellowsConsumer)) continue;
            IBellowsConsumer consumer = (IBellowsConsumer)block;
            foundAnyReceivers = true;
            if (!consumer.canAcceptAir(this.level, airPosition, state)) continue;
            foundAnyAllowingReceivers = true;
            consumer.intakeAir(this.level, airPosition, state, 200);
        }
        if (!foundAnyReceivers || foundAnyAllowingReceivers) {
            this.lastPushed = this.level.getGameTime();
            this.justPushed = true;
            this.markForSync();
            this.afterPush();
        }
    }

    private void afterPush() {
        assert (this.level != null);
        Direction direction = (Direction)this.getBlockState().getValue((Property)BellowsBlock.FACING);
        BlockPos facingPos = this.worldPosition.relative(direction);
        this.level.playSound(null, this.worldPosition, (SoundEvent)TFCSounds.BELLOWS_BLOW.get(), SoundSource.BLOCKS, 1.0f, 1.0f + (this.level.random.nextFloat() - this.level.random.nextFloat()) / 16.0f);
        this.level.addParticle((ParticleOptions)ParticleTypes.POOF, (double)((float)facingPos.getX() + 0.5f - 0.3f * (float)direction.getStepX()), (double)((float)facingPos.getY() + 0.5f), (double)((float)facingPos.getZ() + 0.5f - 0.3f * (float)direction.getStepZ()), 0.0, 0.005, 0.0);
    }

    public int getTicksSincePushed() {
        assert (this.level != null);
        return (int)(this.level.getGameTime() - this.lastPushed);
    }
}

