/*
 * Decompiled with CFR 0.152.
 */
package net.dries007.tfc.common.blockentities;

import net.dries007.tfc.common.blockentities.TFCBlockEntities;
import net.dries007.tfc.common.blockentities.TFCBlockEntity;
import net.dries007.tfc.common.blocks.plant.fruit.IBushBlock;
import net.dries007.tfc.util.calendar.Calendars;
import net.dries007.tfc.util.calendar.ICalendarTickable;
import net.minecraft.core.BlockPos;
import net.minecraft.core.HolderLookup;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockState;

public class BerryBushBlockEntity
extends TFCBlockEntity
implements ICalendarTickable {
    private long lastTick = Integer.MIN_VALUE;
    private long lastUpdateTick = Calendars.SERVER.getTicks();
    private BlockPos stemPos;

    public static void serverTick(Level level, BlockPos pos, BlockState state, BerryBushBlockEntity bush) {
        bush.checkForCalendarUpdate();
    }

    public BerryBushBlockEntity(BlockPos pos, BlockState state) {
        this((BlockEntityType)TFCBlockEntities.BERRY_BUSH.get(), pos, state, pos);
    }

    protected BerryBushBlockEntity(BlockEntityType<?> type, BlockPos pos, BlockState state, BlockPos stemPos) {
        super(type, pos, state);
        this.stemPos = stemPos;
    }

    public long getTicksSinceBushUpdate() {
        return Calendars.SERVER.getTicks() - this.lastUpdateTick;
    }

    @Override
    public void loadAdditional(CompoundTag nbt, HolderLookup.Provider provider) {
        this.lastUpdateTick = nbt.getLong("lastUpdateTick");
        this.lastTick = nbt.getLong("lastTick");
        if (nbt.contains("stemPos", 11)) {
            int[] stemArray = nbt.getIntArray("stemPos");
            this.stemPos = new BlockPos(stemArray[0], stemArray[1], stemArray[2]);
        } else {
            this.stemPos = nbt.contains("stemPos", 4) ? BlockPos.of((long)nbt.getLong("stemPos")) : this.worldPosition;
        }
        super.loadAdditional(nbt, provider);
    }

    @Override
    public void saveAdditional(CompoundTag nbt, HolderLookup.Provider provider) {
        nbt.putLong("lastUpdateTick", this.lastUpdateTick);
        nbt.putLong("lastTick", this.lastTick);
        nbt.putLong("stemPos", this.stemPos.asLong());
        super.saveAdditional(nbt, provider);
    }

    @Override
    public void onCalendarUpdate(long ticks) {
        BlockState state;
        Block block;
        if (this.level != null && ticks >= 24000L && (block = (state = this.level.getBlockState(this.worldPosition)).getBlock()) instanceof IBushBlock) {
            IBushBlock bush = (IBushBlock)block;
            bush.onUpdate(this.level, this.worldPosition, state);
            this.lastUpdateTick = Calendars.SERVER.getTicks();
            this.setChanged();
        }
    }

    @Override
    @Deprecated
    public long getLastCalendarUpdateTick() {
        return this.lastTick;
    }

    @Override
    @Deprecated
    public void setLastCalendarUpdateTick(long tick) {
        this.lastTick = tick;
    }

    public void setLastBushTick(long ticks) {
        this.lastUpdateTick = ticks;
    }

    public void setStemPos(BlockPos stemPos) {
        this.stemPos = stemPos;
    }

    public BlockPos getStemPos() {
        return this.stemPos;
    }
}

