/*
 * Decompiled with CFR 0.152.
 */
package net.dries007.tfc.common.blockentities;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.function.Function;
import java.util.stream.IntStream;
import net.dries007.tfc.common.TFCTags;
import net.dries007.tfc.common.blockentities.IHeatable;
import net.dries007.tfc.common.blockentities.InventoryBlockEntity;
import net.dries007.tfc.common.blockentities.TFCBlockEntities;
import net.dries007.tfc.common.blockentities.TickableInventoryBlockEntity;
import net.dries007.tfc.common.blocks.MoltenBlock;
import net.dries007.tfc.common.blocks.devices.BlastFurnaceBlock;
import net.dries007.tfc.common.blocks.devices.BloomeryBlock;
import net.dries007.tfc.common.capabilities.DelegateFluidHandler;
import net.dries007.tfc.common.capabilities.PartialFluidHandler;
import net.dries007.tfc.common.capabilities.SidedHandler;
import net.dries007.tfc.common.component.heat.HeatCapability;
import net.dries007.tfc.common.component.heat.IHeat;
import net.dries007.tfc.common.container.BlastFurnaceContainer;
import net.dries007.tfc.common.fluids.FluidHelpers;
import net.dries007.tfc.common.recipes.BlastFurnaceRecipe;
import net.dries007.tfc.common.recipes.HeatingRecipe;
import net.dries007.tfc.config.TFCConfig;
import net.dries007.tfc.util.Helpers;
import net.dries007.tfc.util.SyncableContainerData;
import net.dries007.tfc.util.calendar.ICalendarTickable;
import net.dries007.tfc.util.data.Fuel;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.HolderLookup;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.Tag;
import net.minecraft.world.entity.EntitySelector;
import net.minecraft.world.entity.item.ItemEntity;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.inventory.ContainerData;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.phys.AABB;
import net.neoforged.neoforge.capabilities.Capabilities;
import net.neoforged.neoforge.fluids.FluidStack;
import net.neoforged.neoforge.fluids.capability.IFluidHandler;
import net.neoforged.neoforge.fluids.capability.templates.FluidTank;
import net.neoforged.neoforge.items.IItemHandler;
import net.neoforged.neoforge.items.ItemStackHandler;
import org.jetbrains.annotations.Nullable;

public class BlastFurnaceBlockEntity
extends TickableInventoryBlockEntity<BlastFurnaceInventory>
implements ICalendarTickable,
IHeatable {
    private final List<ItemStack> inputStacks;
    private final List<HeatingRecipe> inputCachedRecipes;
    private final List<ItemStack> catalystStacks;
    private final List<ItemStack> fuelStacks;
    private final SyncableContainerData syncedData;
    private final SidedHandler<IFluidHandler> sidedFluidInventory;
    private final FluidTank outputFluidTank;
    private FluidStack inputFluid;
    @Nullable
    private BlastFurnaceRecipe cachedRecipe;
    private float temperature;
    private int burnTicks;
    private float burnTemperature;
    private int airTicks;
    private long lastPlayerTick = Integer.MIN_VALUE;
    private int lastKnownCapacity;

    public static void serverTick(Level level, BlockPos pos, BlockState state, BlastFurnaceBlockEntity entity) {
        entity.checkForLastTickSync();
        entity.checkForCalendarUpdate();
        if (level.getGameTime() % 20L == 0L) {
            int capacity = entity.calculateCapacity();
            boolean modified = entity.inputStacks.size() > capacity || entity.catalystStacks.size() > capacity || entity.fuelStacks.size() > capacity;
            entity.popItemsOffOverCapacity(entity.inputStacks, capacity);
            entity.popItemsOffOverCapacity(entity.catalystStacks, capacity);
            entity.popItemsOffOverCapacity(entity.fuelStacks, capacity);
            if (modified) {
                if (((Boolean)state.getValue((Property)BlastFurnaceBlock.LIT)).booleanValue()) {
                    state = (BlockState)state.setValue((Property)BlastFurnaceBlock.LIT, (Comparable)Boolean.valueOf(false));
                    level.setBlockAndUpdate(pos, state);
                }
                entity.markForSync();
            }
            entity.addItemsFromWorld(capacity);
            MoltenBlock.manageMoltenBlockTower(level, entity.worldPosition.above(), (Boolean)state.getValue((Property)BloomeryBlock.LIT), TFCConfig.SERVER.blastFurnaceMaxChimneyHeight.get(), entity.inputStacks.size() + entity.fuelStacks.size(), 2 * TFCConfig.SERVER.blastFurnaceCapacity.get());
        }
        if (((Boolean)state.getValue((Property)BlastFurnaceBlock.LIT)).booleanValue()) {
            if (entity.burnTicks > 0) {
                entity.burnTicks = entity.burnTicks - TFCConfig.SERVER.blastFurnaceFuelConsumptionMultiplier.get() * (entity.airTicks > 0 ? 2 : 1);
            }
            if (entity.burnTicks <= 0 && !entity.consumeFuel()) {
                entity.extinguish(state);
            }
        } else if (entity.burnTemperature > 0.0f) {
            entity.extinguish(state);
        }
        if (entity.airTicks > 0) {
            ItemStack tuyere;
            if (entity.airTicks % 20 == 0 && entity.temperature > 400.0f && !(tuyere = ((BlastFurnaceInventory)entity.inventory).getStackInSlot(0)).isEmpty()) {
                Helpers.damageItem(tuyere, level);
            }
            --entity.airTicks;
        }
        if (entity.temperature > 0.0f || entity.burnTemperature > 0.0f) {
            entity.temperature = HeatCapability.adjustDeviceTemp(entity.temperature, entity.burnTemperature, entity.airTicks, false);
            entity.ensureCachedRecipesAreAligned();
            ArrayList<FluidStack> newInputFluids = new ArrayList<FluidStack>();
            Iterator<ItemStack> inputIterator = entity.inputStacks.iterator();
            Iterator<ItemStack> catalystIterator = entity.catalystStacks.iterator();
            Iterator<HeatingRecipe> recipeIterator = entity.inputCachedRecipes.iterator();
            while (inputIterator.hasNext()) {
                ItemStack inputStack = inputIterator.next();
                ItemStack catalystStack = catalystIterator.next();
                HeatingRecipe inputRecipe = recipeIterator.next();
                @Nullable IHeat inputHeat = HeatCapability.get(inputStack);
                if (inputHeat == null) continue;
                HeatCapability.addTemp(inputHeat, entity.temperature);
                if (inputRecipe == null || !inputRecipe.isValidTemperature(inputHeat.getTemperature())) continue;
                FluidStack fluidStack = inputRecipe.assembleFluid(inputStack);
                newInputFluids.add(fluidStack);
                inputIterator.remove();
                catalystIterator.remove();
                recipeIterator.remove();
            }
            if (!newInputFluids.isEmpty()) {
                for (FluidStack newInputFluid : newInputFluids) {
                    entity.insertOrReplaceInputFluid(newInputFluid);
                }
                BlastFurnaceRecipe recipe = BlastFurnaceRecipe.get(level, entity.inputFluid);
                if (recipe != null) {
                    FluidStack newOutputFluid = recipe.assembleFluidOutput(entity.inputFluid);
                    entity.outputFluidTank.fill(newOutputFluid, IFluidHandler.FluidAction.EXECUTE);
                }
            }
            entity.markForSync();
        }
        if (!entity.outputFluidTank.isEmpty()) {
            @Nullable IFluidHandler belowFluidHandler = (IFluidHandler)level.getCapability(Capabilities.FluidHandler.BLOCK, pos.below(), (Object)Direction.UP);
            if (belowFluidHandler != null && FluidHelpers.transferExact((IFluidHandler)entity.outputFluidTank, belowFluidHandler, 1)) {
                HeatCapability.provideHeatTo(level, pos.below(), Direction.UP, entity.temperature);
            }
            entity.markForSync();
        }
        entity.setChanged();
    }

    public BlastFurnaceBlockEntity(BlockPos pos, BlockState state) {
        super((BlockEntityType)TFCBlockEntities.BLAST_FURNACE.get(), pos, state, BlastFurnaceInventory::new);
        this.inputStacks = new ArrayList<ItemStack>();
        this.inputCachedRecipes = new ArrayList<HeatingRecipe>();
        this.catalystStacks = new ArrayList<ItemStack>();
        this.fuelStacks = new ArrayList<ItemStack>();
        this.inputFluid = FluidStack.EMPTY;
        this.outputFluidTank = new FluidTank(TFCConfig.SERVER.blastFurnaceFluidCapacity.get().intValue());
        this.syncedData = new SyncableContainerData().add(() -> this.lastKnownCapacity, value -> {
            this.lastKnownCapacity = value;
        }).add(() -> (int)this.temperature, value -> {
            this.temperature = value;
        });
        this.sidedFluidInventory = new SidedHandler<IFluidHandler>((IFluidHandler)this.inventory);
        if (TFCConfig.SERVER.blastFurnaceEnableAutomation.get().booleanValue()) {
            this.sidedInventory.on(this.inventory, Helpers.DIRECTIONS);
            this.sidedFluidInventory.on((IFluidHandler)((Function<IFluidHandler, IFluidHandler>)PartialFluidHandler::extractOnly), Helpers.DIRECTIONS);
        }
    }

    @Override
    public IItemHandler getSidedInventory(@Nullable Direction context) {
        return (IItemHandler)this.sidedInventory.get(context);
    }

    @Nullable
    public IFluidHandler getSidedFluidInventory(@Nullable Direction context) {
        return this.sidedFluidInventory.get(context);
    }

    public int getCapacity() {
        return this.lastKnownCapacity;
    }

    public int getAirTicks() {
        return this.airTicks;
    }

    public int getInputCount() {
        return this.inputStacks.size();
    }

    public int getFuelCount() {
        return this.fuelStacks.size();
    }

    public int getCatalystCount() {
        return this.catalystStacks.size();
    }

    @Override
    public float getTemperature() {
        return this.temperature;
    }

    public ContainerData getSyncedData() {
        return this.syncedData;
    }

    public boolean hasTuyere() {
        return !((BlastFurnaceInventory)this.inventory).getStackInSlot(0).isEmpty();
    }

    public void intakeAir(int amount) {
        this.airTicks += amount;
        if (this.airTicks > 600) {
            this.airTicks = 600;
        }
    }

    public boolean light(Level level, BlockPos pos, BlockState state) {
        if (((Boolean)state.getValue((Property)BlastFurnaceBlock.LIT)).booleanValue()) {
            return true;
        }
        if (!this.fuelStacks.isEmpty()) {
            level.setBlock(pos, (BlockState)state.setValue((Property)BlastFurnaceBlock.LIT, (Comparable)Boolean.valueOf(true)), 3);
            return true;
        }
        return false;
    }

    @Override
    public void loadAdditional(CompoundTag nbt, HolderLookup.Provider provider) {
        Helpers.readItemStacksFromNbt(provider, this.inputStacks, nbt.getList("inputStacks", 10));
        Helpers.readItemStacksFromNbt(provider, this.catalystStacks, nbt.getList("catalystStacks", 10));
        Helpers.readItemStacksFromNbt(provider, this.fuelStacks, nbt.getList("fuelStacks", 10));
        this.inputFluid = FluidStack.parseOptional((HolderLookup.Provider)provider, (CompoundTag)nbt.getCompound("inputFluid"));
        this.outputFluidTank.readFromNBT(provider, nbt.getCompound("outputFluidTank"));
        this.temperature = nbt.getFloat("temperature");
        this.burnTicks = nbt.getInt("burnTicks");
        this.airTicks = nbt.getInt("airTicks");
        this.burnTemperature = nbt.getFloat("burnTemperature");
        this.lastPlayerTick = nbt.getLong("lastPlayerTick");
        super.loadAdditional(nbt, provider);
    }

    @Override
    public void saveAdditional(CompoundTag nbt, HolderLookup.Provider provider) {
        nbt.put("inputStacks", (Tag)Helpers.writeItemStacksToNbt(provider, this.inputStacks));
        nbt.put("catalystStacks", (Tag)Helpers.writeItemStacksToNbt(provider, this.catalystStacks));
        nbt.put("fuelStacks", (Tag)Helpers.writeItemStacksToNbt(provider, this.fuelStacks));
        nbt.put("inputFluid", this.inputFluid.saveOptional(provider));
        nbt.put("outputFluidTank", (Tag)this.outputFluidTank.writeToNBT(provider, new CompoundTag()));
        nbt.putFloat("temperature", this.temperature);
        nbt.putInt("burnTicks", this.burnTicks);
        nbt.putInt("airTicks", this.airTicks);
        nbt.putFloat("burnTemperature", this.burnTemperature);
        nbt.putLong("lastPlayerTick", this.lastPlayerTick);
        super.saveAdditional(nbt, provider);
    }

    @Override
    public void onCalendarUpdate(long ticks) {
        assert (this.level != null);
        HeatCapability.Remainder remainder = HeatCapability.consumeFuelForTicks(ticks, this.burnTicks, this.burnTemperature, this.fuelStacks);
        this.burnTicks = remainder.burnTicks();
        this.burnTemperature = remainder.burnTemperature();
        if (remainder.ticks() > 0L) {
            this.extinguish(this.getBlockState());
            for (ItemStack stack : this.inputStacks) {
                HeatCapability.setTemperature(stack, 0.0f);
            }
        }
    }

    @Override
    @Nullable
    public AbstractContainerMenu createMenu(int containerId, Inventory inventory, Player player) {
        return BlastFurnaceContainer.create(this, inventory, containerId);
    }

    @Override
    @Deprecated
    public long getLastCalendarUpdateTick() {
        return this.lastPlayerTick;
    }

    @Override
    @Deprecated
    public void setLastCalendarUpdateTick(long tick) {
        this.lastPlayerTick = tick;
    }

    @Override
    public boolean isItemValid(int slot, ItemStack stack) {
        return Helpers.isItem(stack, TFCTags.Items.BLAST_FURNACE_TUYERES);
    }

    @Override
    public void ejectInventory() {
        super.ejectInventory();
        this.dumpItems();
        this.destroyMolten();
    }

    private void dumpItems() {
        assert (this.level != null);
        BlockPos pos = this.worldPosition.above();
        this.inputStacks.forEach(stack -> Helpers.spawnDropsAtExactCenter(this.level, pos, stack));
        this.catalystStacks.forEach(stack -> Helpers.spawnDropsAtExactCenter(this.level, pos, stack));
        this.fuelStacks.forEach(stack -> Helpers.spawnDropsAtExactCenter(this.level, pos, stack));
        this.cachedRecipe = null;
    }

    private void insertOrReplaceInputFluid(FluidStack newFluid) {
        this.inputFluid = this.insertOrReplaceFluid(newFluid, this.inputFluid);
    }

    private FluidStack insertOrReplaceFluid(FluidStack newFluid, FluidStack currentFluid) {
        if (currentFluid.isEmpty()) {
            return newFluid;
        }
        if (currentFluid.getFluid() == newFluid.getFluid()) {
            currentFluid.grow(newFluid.getAmount());
            return currentFluid;
        }
        return newFluid;
    }

    private void popItemsOffOverCapacity(List<ItemStack> items, int capacity) {
        assert (this.level != null);
        while (items.size() > capacity) {
            Helpers.spawnItem(this.level, this.worldPosition, items.remove(items.size() - 1));
        }
    }

    private void ensureCachedRecipesAreAligned() {
        if (this.inputStacks.size() != this.inputCachedRecipes.size()) {
            this.inputCachedRecipes.clear();
            for (ItemStack inputStack : this.inputStacks) {
                this.inputCachedRecipes.add(HeatingRecipe.getRecipe(inputStack));
            }
        }
    }

    private boolean consumeFuel() {
        if (this.fuelStacks.isEmpty()) {
            return false;
        }
        ItemStack fuelStack = this.fuelStacks.get(0);
        if (!fuelStack.isEmpty()) {
            this.fuelStacks.remove(0);
            Fuel fuel = Fuel.get(fuelStack);
            if (fuel != null) {
                this.burnTicks += fuel.duration();
                this.burnTemperature = fuel.temperature();
            }
            this.markForSync();
        }
        return this.burnTicks > 0;
    }

    public void extinguish(BlockState state) {
        assert (this.level != null);
        this.level.setBlockAndUpdate(this.worldPosition, (BlockState)state.setValue((Property)BlastFurnaceBlock.LIT, (Comparable)Boolean.valueOf(false)));
        this.burnTicks = 0;
        this.burnTemperature = 0.0f;
        this.markForSync();
    }

    private void addItemsFromWorld(int capacity) {
        assert (this.level != null);
        this.updateCachedRecipe();
        if (this.cachedRecipe == null && !this.inputStacks.isEmpty()) {
            this.dumpItems();
            this.markForSync();
        }
        if (this.inputStacks.size() == capacity && this.fuelStacks.size() == capacity) {
            return;
        }
        List items = this.level.getEntitiesOfClass(ItemEntity.class, AABB.encapsulatingFullBlocks((BlockPos)this.worldPosition, (BlockPos)this.worldPosition.offset(1, BlastFurnaceBlock.getChimneyLevels(this.level, this.worldPosition) + 2, 1)), EntitySelector.ENTITY_STILL_ALIVE);
        if (this.cachedRecipe == null) {
            for (ItemEntity entity : items) {
                ItemStack stack = entity.getItem();
                BlastFurnaceRecipe recipe = BlastFurnaceRecipe.get(this.level, stack);
                if (recipe == null) continue;
                this.cachedRecipe = recipe;
                this.markForSync();
                break;
            }
        }
        if (this.cachedRecipe != null) {
            ArrayList<ItemEntity> foundInputs = new ArrayList<ItemEntity>();
            ArrayList<ItemEntity> foundCatalysts = new ArrayList<ItemEntity>();
            ArrayList<ItemEntity> foundFuels = new ArrayList<ItemEntity>();
            int inputCount = 0;
            int catalystCount = 0;
            int fuelCount = 0;
            for (ItemEntity entity : items) {
                ItemStack stack = entity.getItem();
                if (this.cachedRecipe.matchesInput(stack)) {
                    foundInputs.add(entity);
                    inputCount += stack.getCount();
                    continue;
                }
                if (this.cachedRecipe.matchesCatalyst(stack)) {
                    foundCatalysts.add(entity);
                    catalystCount += stack.getCount();
                    continue;
                }
                if (!Helpers.isItem(stack, TFCTags.Items.BLAST_FURNACE_FUEL)) continue;
                foundFuels.add(entity);
                fuelCount += stack.getCount();
            }
            int totalInsertCapacity = IntStream.of(capacity - this.inputStacks.size(), inputCount, catalystCount).min().orElse(0);
            Helpers.consumeItemsFromEntitiesIndividually(foundInputs, totalInsertCapacity, this.inputStacks::add);
            Helpers.consumeItemsFromEntitiesIndividually(foundCatalysts, totalInsertCapacity, this.catalystStacks::add);
            int totalFuelCapacity = Math.min(capacity - this.fuelStacks.size(), fuelCount);
            Helpers.consumeItemsFromEntitiesIndividually(foundFuels, totalFuelCapacity, this.fuelStacks::add);
            this.markForSync();
        }
    }

    private void destroyMolten() {
        assert (this.level != null);
        MoltenBlock.removeMoltenBlockTower(this.level, this.worldPosition.above(), TFCConfig.SERVER.blastFurnaceMaxChimneyHeight.get());
    }

    private int calculateCapacity() {
        assert (this.level != null);
        this.lastKnownCapacity = BlastFurnaceBlock.getChimneyLevels(this.level, this.worldPosition) * TFCConfig.SERVER.blastFurnaceCapacity.get();
        return this.lastKnownCapacity;
    }

    private void updateCachedRecipe() {
        assert (this.level != null);
        this.cachedRecipe = !this.inputStacks.isEmpty() ? BlastFurnaceRecipe.get(this.level, this.inputStacks.get(0)) : null;
    }

    public static class BlastFurnaceInventory
    extends ItemStackHandler
    implements DelegateFluidHandler {
        private final BlastFurnaceBlockEntity blastFurnace;

        BlastFurnaceInventory(InventoryBlockEntity<?> entity) {
            super(1);
            this.blastFurnace = (BlastFurnaceBlockEntity)entity;
        }

        public FluidStack getFluid() {
            return this.blastFurnace.inputFluid;
        }

        public ItemStack getCatalyst() {
            return this.blastFurnace.catalystStacks.isEmpty() ? ItemStack.EMPTY : this.blastFurnace.catalystStacks.get(0);
        }

        @Override
        public IFluidHandler getFluidHandler() {
            return this.blastFurnace.outputFluidTank;
        }
    }
}

