/*
 * Decompiled with CFR 0.152.
 */
package net.dries007.tfc.common.blockentities;

import net.dries007.tfc.common.TFCTags;
import net.dries007.tfc.common.blockentities.InventoryBlockEntity;
import net.dries007.tfc.common.blockentities.TFCBlockEntities;
import net.dries007.tfc.common.capabilities.PartialItemHandler;
import net.dries007.tfc.config.TFCConfig;
import net.dries007.tfc.util.Helpers;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockState;
import net.neoforged.neoforge.items.ItemStackHandler;

public class BowlBlockEntity
extends InventoryBlockEntity<ItemStackHandler> {
    public static final int MAX_POWDER = 16;

    public BowlBlockEntity(BlockPos pos, BlockState state) {
        this((BlockEntityType)TFCBlockEntities.BOWL.get(), pos, state);
    }

    public BowlBlockEntity(BlockEntityType<?> type, BlockPos pos, BlockState state) {
        super(type, pos, state, BowlBlockEntity.defaultInventory(1));
        if (TFCConfig.SERVER.powderBowlEnableAutomation.get().booleanValue()) {
            this.sidedInventory.on(new PartialItemHandler(this.inventory).insertAll(), Direction.UP).on(new PartialItemHandler(this.inventory).extractAll(), d -> d != Direction.UP);
        }
    }

    @Override
    public void setAndUpdateSlots(int slot) {
        this.markForSync();
    }

    @Override
    public int getSlotStackLimit(int slot) {
        return 16;
    }

    @Override
    public boolean isItemValid(int slot, ItemStack stack) {
        return Helpers.isItem(stack, TFCTags.Items.BOWL_POWDERS);
    }
}

