/*
 * Decompiled with CFR 0.152.
 */
package net.dries007.tfc.common.blockentities;

import net.dries007.tfc.common.blockentities.TFCBlockEntities;
import net.dries007.tfc.common.blockentities.TickableBlockEntity;
import net.dries007.tfc.common.blocks.TFCBlockStateProperties;
import net.dries007.tfc.util.calendar.Calendars;
import net.dries007.tfc.util.calendar.ICalendar;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.HolderLookup;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.Property;

public class CalendarClockBlockEntity
extends TickableBlockEntity {
    private float monthAngle;
    private float minuteAngle;
    private float hourAngle;
    private int hour;
    private int month;
    private boolean needsUpdate = false;

    protected CalendarClockBlockEntity(BlockEntityType<?> type, BlockPos pos, BlockState state) {
        super(type, pos, state);
    }

    public CalendarClockBlockEntity(BlockPos pos, BlockState state) {
        this((BlockEntityType)TFCBlockEntities.CALENDAR_CLOCK.get(), pos, state);
    }

    public static void serverTick(Level level, BlockPos pos, BlockState state, CalendarClockBlockEntity clock) {
        if (clock.needsUpdate) {
            clock.markForSync();
            clock.needsUpdate = false;
        }
        if (Calendars.SERVER.getCalendarTicks() % 60L == 0L) {
            int signal = clock.getRedstoneSignal();
            if (Calendars.SERVER.getAbsoluteCalendarMonthOfYear().ordinal() != clock.month) {
                clock.month = Calendars.SERVER.getAbsoluteCalendarMonthOfYear().ordinal();
            }
            if (ICalendar.getHourOfDay(Calendars.SERVER.getCalendarTicks()) != clock.hour) {
                clock.hour = ICalendar.getHourOfDay(Calendars.SERVER.getCalendarTicks());
            }
            if (signal != clock.getRedstoneSignal()) {
                level.updateNeighborsAt(pos, state.getBlock());
                level.updateNeighborsAt(pos.relative(((Direction)state.getValue((Property)BlockStateProperties.FACING)).getOpposite()), state.getBlock());
            }
        }
        CalendarClockBlockEntity.clientTick(level, pos, state, clock);
    }

    public static void clientTick(Level level, BlockPos pos, BlockState state, CalendarClockBlockEntity clock) {
        if (level.getGameTime() % 20L == 0L) {
            clock.minuteAngle = (float)Math.PI * 2 * Calendars.CLIENT.getCalendarFractionOfHour();
        }
        clock.hourAngle = (float)Math.PI * 2 * Calendars.CLIENT.getCalendarFractionOfDay() * 2.0f;
        clock.monthAngle = (float)Math.PI * 2 * Calendars.CLIENT.getCalendarFractionOfYear();
    }

    public float[] getAngles() {
        return new float[]{this.minuteAngle, this.hourAngle, this.monthAngle};
    }

    public void needsInstantUpdate() {
        assert (this.level != null);
        float fractionOver = (float)this.level.getGameTime() % 20.0f / 1000.0f;
        this.minuteAngle = (float)Math.PI * 2 * Calendars.CLIENT.getCalendarFractionOfHour() - (float)Math.PI * 2 * fractionOver + 0.03141593f;
        this.hourAngle = (float)Math.PI * 2 * Calendars.CLIENT.getCalendarFractionOfDay() * 2.0f;
        this.monthAngle = (float)Math.PI * 2 * Calendars.CLIENT.getCalendarFractionOfYear();
    }

    public int getRedstoneSignal() {
        if (((Boolean)this.getBlockState().getValue((Property)TFCBlockStateProperties.CLOCK_MONTH_MODE)).booleanValue()) {
            return this.month;
        }
        return this.hour > 11 ? this.hour - 12 : this.hour;
    }

    @Override
    public void saveAdditional(CompoundTag tag, HolderLookup.Provider provider) {
        super.saveAdditional(tag, provider);
        tag.putFloat("minuteAngle", this.minuteAngle);
        tag.putFloat("hourAngle", this.hourAngle);
        tag.putFloat("monthAngle", this.monthAngle);
    }

    @Override
    public void loadAdditional(CompoundTag tag, HolderLookup.Provider provider) {
        super.loadAdditional(tag, provider);
        this.hourAngle = tag.getFloat("hourAngle");
        this.minuteAngle = tag.getFloat("minuteAngle");
        this.monthAngle = tag.getFloat("monthAngle");
        this.needsUpdate = true;
    }
}

