/*
 * Decompiled with CFR 0.152.
 */
package net.dries007.tfc.common.blockentities;

import java.util.Arrays;
import java.util.function.Predicate;
import net.dries007.tfc.client.TFCSounds;
import net.dries007.tfc.common.TFCTags;
import net.dries007.tfc.common.blockentities.TFCBlockEntities;
import net.dries007.tfc.common.blockentities.TickableInventoryBlockEntity;
import net.dries007.tfc.common.blocks.TFCBlocks;
import net.dries007.tfc.common.blocks.devices.CharcoalForgeBlock;
import net.dries007.tfc.common.capabilities.PartialItemHandler;
import net.dries007.tfc.common.component.food.FoodCapability;
import net.dries007.tfc.common.component.food.FoodTraits;
import net.dries007.tfc.common.component.heat.Heat;
import net.dries007.tfc.common.component.heat.HeatCapability;
import net.dries007.tfc.common.component.heat.IHeat;
import net.dries007.tfc.common.container.CharcoalForgeContainer;
import net.dries007.tfc.common.recipes.HeatingRecipe;
import net.dries007.tfc.config.TFCConfig;
import net.dries007.tfc.util.Helpers;
import net.dries007.tfc.util.SyncableContainerData;
import net.dries007.tfc.util.calendar.ICalendarTickable;
import net.dries007.tfc.util.data.Fuel;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.HolderLookup;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.util.Mth;
import net.minecraft.world.MenuProvider;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.inventory.ContainerData;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.phys.AABB;
import net.neoforged.neoforge.capabilities.Capabilities;
import net.neoforged.neoforge.fluids.FluidStack;
import net.neoforged.neoforge.items.IItemHandler;
import net.neoforged.neoforge.items.ItemStackHandler;
import org.jetbrains.annotations.Nullable;

public class CharcoalForgeBlockEntity
extends TickableInventoryBlockEntity<ItemStackHandler>
implements ICalendarTickable,
MenuProvider {
    public static final int SLOT_FUEL_MIN = 0;
    public static final int SLOT_FUEL_MAX = 4;
    public static final int SLOT_INPUT_MIN = 5;
    public static final int SLOT_INPUT_MAX = 9;
    public static final int SLOT_EXTRA_MIN = 10;
    public static final int SLOT_EXTRA_MAX = 13;
    protected final ContainerData syncableData;
    private final HeatingRecipe[] cachedRecipes = new HeatingRecipe[5];
    private boolean needsSlotUpdate = false;
    private float temperature = 0.0f;
    private int burnTicks = 0;
    private float burnTemperature = 0.0f;
    private int airTicks = 0;
    private long lastPlayerTick = Integer.MIN_VALUE;
    private boolean needsRecipeUpdate;

    public static void createFromCharcoalPile(Level level, BlockPos pos) {
        level.setBlockAndUpdate(pos, (BlockState)((Block)TFCBlocks.CHARCOAL_FORGE.get()).defaultBlockState().setValue((Property)CharcoalForgeBlock.HEAT, (Comparable)Integer.valueOf(2)));
        level.getBlockEntity(pos, (BlockEntityType)TFCBlockEntities.CHARCOAL_FORGE.get()).ifPresent(CharcoalForgeBlockEntity::onFirstCreation);
    }

    public static void serverTick(Level level, BlockPos pos, BlockState state, CharcoalForgeBlockEntity forge) {
        forge.checkForLastTickSync();
        forge.checkForCalendarUpdate();
        if (forge.needsRecipeUpdate) {
            forge.needsRecipeUpdate = false;
            forge.updateCachedRecipes();
        }
        if (level.getGameTime() % 20L == 0L) {
            AABB bounds = new AABB((double)pos.getX() - 0.2, (double)pos.getY() + 0.875, (double)pos.getZ() - 0.2, (double)pos.getX() + 1.2, (double)pos.getY() + 1.25, (double)pos.getZ() + 1.2);
            Helpers.gatherAndConsumeItems(level, bounds, (IItemHandler)forge.inventory, 0, 4);
        }
        boolean isRaining = level.isRainingAt(pos);
        if ((Integer)state.getValue((Property)CharcoalForgeBlock.HEAT) > 0) {
            int heatLevel;
            if (isRaining && level.random.nextFloat() < 0.15f) {
                Helpers.playSound(level, pos, (SoundEvent)TFCSounds.ITEM_COOL.get());
            }
            if ((heatLevel = Mth.clamp((int)((int)(forge.temperature / Heat.maxVisibleTemperature() * 6.0f) + 1), (int)1, (int)7)) != (Integer)state.getValue((Property)CharcoalForgeBlock.HEAT)) {
                level.setBlockAndUpdate(pos, (BlockState)state.setValue((Property)CharcoalForgeBlock.HEAT, (Comparable)Integer.valueOf(heatLevel)));
                forge.markForSync();
            }
            if (forge.burnTicks > 0) {
                forge.burnTicks = forge.burnTicks - (forge.airTicks > 0 || isRaining ? 2 : 1);
            }
            if (forge.burnTicks <= 0 && !forge.consumeFuel()) {
                forge.extinguish(state);
            }
        } else if (forge.burnTemperature > 0.0f) {
            forge.extinguish(state);
        }
        if (forge.airTicks > 0) {
            --forge.airTicks;
        }
        if (forge.temperature > 0.0f || forge.burnTemperature > 0.0f) {
            forge.temperature = HeatCapability.adjustDeviceTemp(forge.temperature, forge.burnTemperature, forge.airTicks, isRaining);
            HeatCapability.provideHeatTo(level, pos.above(), Direction.DOWN, forge.temperature);
            for (int slot = 5; slot <= 9; ++slot) {
                ItemStack stack = ((ItemStackHandler)forge.inventory).getStackInSlot(slot);
                @Nullable IHeat heat = HeatCapability.get(stack);
                if (heat == null) continue;
                HeatCapability.addTemp(heat, forge.temperature);
                forge.handleInputMelting(stack, slot);
            }
            forge.markForSync();
        }
        if (forge.needsSlotUpdate) {
            forge.cascadeFuelSlots();
        }
    }

    public CharcoalForgeBlockEntity(BlockPos pos, BlockState state) {
        super((BlockEntityType)TFCBlockEntities.CHARCOAL_FORGE.get(), pos, state, CharcoalForgeBlockEntity.defaultInventory(14));
        this.syncableData = new SyncableContainerData().add(() -> (int)this.temperature, value -> {
            this.temperature = value;
        });
        if (TFCConfig.SERVER.charcoalForgeEnableAutomation.get().booleanValue()) {
            this.sidedInventory.on(new PartialItemHandler(this.inventory).insert(0, 1, 2, 3, 4), Direction.UP).on(new PartialItemHandler(this.inventory).insert(5, 6, 7, 8, 9), (Predicate<Direction>)Direction.Plane.HORIZONTAL).on(new PartialItemHandler(this.inventory).extract(5, 6, 7, 8, 9), Direction.DOWN);
        }
        Arrays.fill(this.cachedRecipes, null);
    }

    public void intakeAir(int amount) {
        this.airTicks += amount;
        if (this.airTicks > 600) {
            this.airTicks = 600;
        }
    }

    @Override
    public void onCalendarUpdate(long ticks) {
        assert (this.level != null);
        BlockState state = this.level.getBlockState(this.worldPosition);
        if ((Integer)state.getValue((Property)CharcoalForgeBlock.HEAT) != 0) {
            HeatCapability.Remainder remainder = HeatCapability.consumeFuelForTicks(ticks, this.inventory, this.burnTicks, this.burnTemperature, 0, 4);
            this.burnTicks = remainder.burnTicks();
            this.burnTemperature = remainder.burnTemperature();
            this.needsSlotUpdate = true;
            if (remainder.ticks() > 0L) {
                this.extinguish(state);
                for (int i = 5; i <= 9; ++i) {
                    ItemStack stack = ((ItemStackHandler)this.inventory).getStackInSlot(i);
                    HeatCapability.setTemperature(stack, 0.0f);
                }
            }
        }
    }

    @Override
    @Deprecated
    public long getLastCalendarUpdateTick() {
        return this.lastPlayerTick;
    }

    @Override
    @Deprecated
    public void setLastCalendarUpdateTick(long tick) {
        this.lastPlayerTick = tick;
    }

    public ContainerData getSyncableData() {
        return this.syncableData;
    }

    public float getTemperature() {
        return this.temperature;
    }

    public int getAirTicks() {
        return this.airTicks;
    }

    public void onFirstCreation() {
        this.burnTicks = 200;
        this.burnTemperature = 500.0f;
        this.markForSync();
    }

    @Override
    @Nullable
    public AbstractContainerMenu createMenu(int windowID, Inventory playerInv, Player player) {
        return CharcoalForgeContainer.create(this, playerInv, windowID);
    }

    @Override
    public void loadAdditional(CompoundTag nbt, HolderLookup.Provider provider) {
        this.temperature = nbt.getFloat("temperature");
        this.burnTicks = nbt.getInt("burnTicks");
        this.airTicks = nbt.getInt("airTicks");
        this.burnTemperature = nbt.getFloat("burnTemperature");
        this.lastPlayerTick = nbt.getLong("lastPlayerTick");
        super.loadAdditional(nbt, provider);
    }

    @Override
    public void saveAdditional(CompoundTag nbt, HolderLookup.Provider provider) {
        nbt.putFloat("temperature", this.temperature);
        nbt.putInt("burnTicks", this.burnTicks);
        nbt.putInt("airTicks", this.airTicks);
        nbt.putFloat("burnTemperature", this.burnTemperature);
        nbt.putLong("lastPlayerTick", this.lastPlayerTick);
        super.saveAdditional(nbt, provider);
    }

    @Override
    public void setAndUpdateSlots(int slot) {
        super.setAndUpdateSlots(slot);
        this.needsSlotUpdate = true;
        this.updateCachedRecipes();
    }

    @Override
    public int getSlotStackLimit(int slot) {
        return 1;
    }

    @Override
    public boolean isItemValid(int slot, ItemStack stack) {
        if (slot <= 4) {
            return Helpers.isItem(stack.getItem(), TFCTags.Items.FORGE_FUEL);
        }
        if (slot <= 9) {
            return HeatCapability.has(stack);
        }
        if (!Helpers.mightHaveCapability(stack, Capabilities.FluidHandler.ITEM)) {
            return false;
        }
        return HeatCapability.has(stack);
    }

    public boolean light(BlockState state) {
        assert (this.level != null);
        if (this.burnTicks > 0) {
            return true;
        }
        if (this.consumeFuel()) {
            this.level.setBlockAndUpdate(this.worldPosition, (BlockState)state.setValue((Property)CharcoalForgeBlock.HEAT, (Comparable)Integer.valueOf(2)));
            return true;
        }
        return false;
    }

    private boolean consumeFuel() {
        ItemStack fuelStack = ((ItemStackHandler)this.inventory).getStackInSlot(0);
        if (!fuelStack.isEmpty()) {
            ((ItemStackHandler)this.inventory).setStackInSlot(0, ItemStack.EMPTY);
            this.needsSlotUpdate = true;
            Fuel fuel = Fuel.get(fuelStack);
            if (fuel != null) {
                this.burnTicks += fuel.duration();
                this.burnTemperature = fuel.temperature();
            }
            this.markForSync();
        }
        return this.burnTicks > 0;
    }

    public void extinguish(BlockState state) {
        assert (this.level != null);
        this.level.setBlockAndUpdate(this.worldPosition, (BlockState)state.setValue((Property)CharcoalForgeBlock.HEAT, (Comparable)Integer.valueOf(0)));
        this.burnTicks = 0;
        this.burnTemperature = 0.0f;
        this.markForSync();
    }

    private void handleInputMelting(ItemStack stack, int startIndex) {
        assert (this.level != null);
        HeatingRecipe recipe = this.cachedRecipes[startIndex - 5];
        @Nullable IHeat cap = HeatCapability.get(stack);
        if (cap != null && recipe != null && recipe.isValidTemperature(cap.getTemperature())) {
            assert (this.level != null);
            FluidStack fluidStack = recipe.assembleFluid(stack);
            ItemStack outputStack = recipe.assembleItem(stack);
            float itemTemperature = cap.getTemperature();
            for (int slot = 10; slot <= 13 && !(fluidStack = Helpers.mergeOutputFluidIntoSlot(this.inventory, fluidStack, itemTemperature, slot)).isEmpty(); ++slot) {
            }
            FoodCapability.applyTrait(outputStack, FoodTraits.CHARCOAL_GRILLED);
            ((ItemStackHandler)this.inventory).setStackInSlot(startIndex, outputStack);
        }
    }

    private void cascadeFuelSlots() {
        int lowestAvailSlot = 0;
        for (int i = 0; i <= 4; ++i) {
            ItemStack stack = ((ItemStackHandler)this.inventory).getStackInSlot(i);
            if (stack.isEmpty()) continue;
            if (i > lowestAvailSlot) {
                ((ItemStackHandler)this.inventory).setStackInSlot(lowestAvailSlot, stack.copy());
                ((ItemStackHandler)this.inventory).setStackInSlot(i, ItemStack.EMPTY);
            }
            ++lowestAvailSlot;
        }
        this.needsSlotUpdate = false;
    }

    private void updateCachedRecipes() {
        assert (this.level != null);
        for (int i = 5; i <= 9; ++i) {
            this.cachedRecipes[i - 5] = null;
            ItemStack inputStack = ((ItemStackHandler)this.inventory).getStackInSlot(i);
            if (inputStack.isEmpty()) continue;
            this.cachedRecipes[i - 5] = HeatingRecipe.getRecipe(inputStack);
        }
    }
}

