/*
 * Decompiled with CFR 0.152.
 */
package net.dries007.tfc.common.blockentities;

import net.dries007.tfc.common.TFCTags;
import net.dries007.tfc.common.blockentities.InventoryBlockEntity;
import net.dries007.tfc.common.blockentities.TFCBlockEntities;
import net.dries007.tfc.common.blocks.devices.TFCComposterBlock;
import net.dries007.tfc.common.capabilities.PartialItemHandler;
import net.dries007.tfc.common.component.food.FoodCapability;
import net.dries007.tfc.common.items.TFCItems;
import net.dries007.tfc.config.TFCConfig;
import net.dries007.tfc.util.Helpers;
import net.dries007.tfc.util.calendar.Calendars;
import net.dries007.tfc.util.climate.Climate;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.HolderLookup;
import net.minecraft.core.Vec3i;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.chat.Component;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.tags.BlockTags;
import net.minecraft.tags.TagKey;
import net.minecraft.world.ItemInteractionResult;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;
import net.neoforged.neoforge.items.ItemStackHandler;

public class ComposterBlockEntity
extends InventoryBlockEntity<ItemStackHandler> {
    public static final int MAX_AMOUNT = 16;
    protected long lastUpdateTick = Integer.MIN_VALUE;
    private int green;
    private int brown;

    public ComposterBlockEntity(BlockPos pos, BlockState state) {
        this((BlockEntityType)TFCBlockEntities.COMPOSTER.get(), pos, state);
    }

    public ComposterBlockEntity(BlockEntityType<?> type, BlockPos pos, BlockState state) {
        super(type, pos, state, ComposterBlockEntity.defaultInventory(1));
        if (TFCConfig.SERVER.composterEnableAutomation.get().booleanValue()) {
            this.sidedInventory.on(new PartialItemHandler(this.inventory).extractAll(), Direction.DOWN);
        }
    }

    public void randomTick() {
        assert (this.level != null);
        if (this.green >= 16 && this.brown >= 16 & !this.isRotten() && this.getTicksSinceUpdate() > this.getReadyTicks()) {
            ((ItemStackHandler)this.inventory).setStackInSlot(0, new ItemStack((ItemLike)TFCItems.COMPOST.get()));
            this.setState(TFCComposterBlock.CompostType.READY);
            this.markForSync();
        }
        if (this.isRotten()) {
            Helpers.tickInfestation(this.level, this.getBlockPos(), 5, null);
        }
    }

    public long getReadyTicks() {
        assert (this.level != null);
        BlockPos.MutableBlockPos cursor = new BlockPos.MutableBlockPos();
        cursor.set((Vec3i)this.getBlockPos());
        float rainfall = Climate.getRainfall(this.level, (BlockPos)cursor);
        long readyTicks = TFCConfig.SERVER.composterTicks.get().intValue();
        if (rainfall < 150.0f) {
            readyTicks *= (long)((150.0f - rainfall) / 50.0f + 1.0f);
        } else if (rainfall > 350.0f) {
            readyTicks *= (long)((rainfall - 350.0f) / 50.0f + 1.0f);
        }
        cursor.move(0, 1, 0);
        if (Helpers.isBlock(this.level.getBlockState((BlockPos)cursor), (TagKey<Block>)BlockTags.SNOW)) {
            readyTicks = (long)((float)readyTicks * 0.9f);
        }
        for (Direction direction : Direction.Plane.HORIZONTAL) {
            cursor.setWithOffset((Vec3i)this.getBlockPos(), direction);
            if (!(this.level.getBlockState((BlockPos)cursor).getBlock() instanceof TFCComposterBlock)) continue;
            readyTicks = (long)((float)readyTicks * 1.05f);
        }
        return readyTicks;
    }

    @Override
    public void loadAdditional(CompoundTag nbt, HolderLookup.Provider provider) {
        this.green = nbt.getInt("green");
        this.brown = nbt.getInt("brown");
        this.lastUpdateTick = nbt.getLong("tick");
        super.loadAdditional(nbt, provider);
    }

    @Override
    public void saveAdditional(CompoundTag nbt, HolderLookup.Provider provider) {
        nbt.putInt("green", this.getGreen());
        nbt.putInt("brown", this.getBrown());
        nbt.putLong("tick", this.lastUpdateTick);
        super.saveAdditional(nbt, provider);
    }

    public ItemInteractionResult use(ItemStack stack, Player player, boolean client) {
        assert (this.level != null);
        boolean rotten = this.isRotten();
        BlockPos pos = this.getBlockPos();
        if (player.blockPosition().equals((Object)pos)) {
            return ItemInteractionResult.FAIL;
        }
        Compost compost = this.getCompost(stack);
        if (stack.isEmpty() && player.isShiftKeyDown()) {
            if (this.brown == 16 && this.green == 16 && !rotten) {
                Helpers.spawnItem(this.level, pos.above(), ((ItemStackHandler)this.inventory).extractItem(0, 1, false));
            } else {
                Helpers.spawnItem(this.level, pos.above(), ((ItemStackHandler)this.inventory).extractItem(0, this.getRottenCount(), false));
            }
            this.reset();
            Helpers.playSound(this.level, pos, SoundEvents.ROOTED_DIRT_BREAK);
            return this.finishUse(client);
        }
        if (this.green <= 16 && compost.type == AdditionType.GREEN) {
            if (this.green == 16) {
                if (!client) {
                    player.displayClientMessage((Component)Component.translatable((String)"tfc.composter.too_many_greens"), true);
                }
            } else {
                this.green = Math.min(this.green + compost.amount, 16);
                if (!client) {
                    if (!player.isCreative()) {
                        stack.shrink(1);
                    }
                    Helpers.playSound(this.level, pos, SoundEvents.HOE_TILL);
                    this.resetCounter();
                }
            }
            return this.finishUse(client);
        }
        if (this.brown <= 16 && compost.type == AdditionType.BROWN) {
            if (this.brown == 16) {
                if (!client) {
                    player.displayClientMessage((Component)Component.translatable((String)"tfc.composter.too_many_browns"), true);
                }
            } else {
                this.brown = Math.min(this.brown + compost.amount, 16);
                if (!client) {
                    if (!player.isCreative()) {
                        stack.shrink(1);
                    }
                    Helpers.playSound(this.level, pos, SoundEvents.HOE_TILL);
                    this.resetCounter();
                }
            }
            return this.finishUse(client);
        }
        if (rotten) {
            if (!client) {
                player.displayClientMessage((Component)Component.translatable((String)"tfc.composter.rotten"), true);
            }
            return this.finishUse(client);
        }
        if (compost.type == AdditionType.POISON) {
            if (!client) {
                this.setState(TFCComposterBlock.CompostType.ROTTEN);
            }
            if (!player.isCreative()) {
                stack.shrink(1);
            }
            Helpers.playSound(this.level, pos, SoundEvents.HOE_TILL);
            return this.finishUse(client);
        }
        return ItemInteractionResult.PASS_TO_DEFAULT_BLOCK_INTERACTION;
    }

    public void resetCounter() {
        this.lastUpdateTick = Calendars.SERVER.getTicks();
        this.setChanged();
    }

    public long getTicksSinceUpdate() {
        assert (this.level != null);
        return Calendars.get((LevelReader)this.level).getTicks() - this.lastUpdateTick;
    }

    public ItemInteractionResult finishUse(boolean client) {
        if (!client) {
            int stage = (this.green + this.brown) / 4;
            if (this.green + this.brown > 0) {
                stage = Math.max(stage, 1);
            }
            if (this.isRotten()) {
                int count = this.getRottenCount();
                ((ItemStackHandler)this.inventory).setStackInSlot(0, new ItemStack((ItemLike)TFCItems.ROTTEN_COMPOST.get(), count));
            }
            this.setState(stage);
            this.markForSync();
        }
        return ItemInteractionResult.sidedSuccess((boolean)client);
    }

    private int getRottenCount() {
        return Math.min(this.green, this.brown) / 4;
    }

    public int getGreen() {
        return this.green;
    }

    public int getBrown() {
        return this.brown;
    }

    public void reset() {
        this.brown = 0;
        this.green = 0;
        this.resetCounter();
        this.setState(TFCComposterBlock.CompostType.NORMAL, 0);
    }

    public boolean isRotten() {
        assert (this.level != null);
        return this.level.getBlockState(this.getBlockPos()).getValue(TFCComposterBlock.TYPE) == TFCComposterBlock.CompostType.ROTTEN;
    }

    public boolean isReady() {
        assert (this.level != null);
        return this.level.getBlockState(this.getBlockPos()).getValue(TFCComposterBlock.TYPE) == TFCComposterBlock.CompostType.READY;
    }

    public void setState(TFCComposterBlock.CompostType type) {
        assert (this.level != null);
        this.level.setBlockAndUpdate(this.getBlockPos(), (BlockState)this.level.getBlockState(this.getBlockPos()).setValue(TFCComposterBlock.TYPE, (Comparable)((Object)type)));
    }

    public void setState(TFCComposterBlock.CompostType type, int stage) {
        assert (this.level != null);
        this.level.setBlockAndUpdate(this.getBlockPos(), (BlockState)((BlockState)this.level.getBlockState(this.getBlockPos()).setValue(TFCComposterBlock.TYPE, (Comparable)((Object)type))).setValue((Property)TFCComposterBlock.STAGE, (Comparable)Integer.valueOf(stage)));
    }

    public void setState(int stage) {
        assert (this.level != null);
        this.level.setBlockAndUpdate(this.getBlockPos(), (BlockState)this.level.getBlockState(this.getBlockPos()).setValue((Property)TFCComposterBlock.STAGE, (Comparable)Integer.valueOf(stage)));
    }

    @Override
    public boolean isItemValid(int slot, ItemStack stack) {
        return stack.getItem() == TFCItems.COMPOST.get() || stack.getItem() == TFCItems.ROTTEN_COMPOST.get();
    }

    @Override
    public int getSlotStackLimit(int slot) {
        return 1;
    }

    public Compost getCompost(ItemStack stack) {
        boolean rotten = FoodCapability.isRotten(stack);
        if (Helpers.isItem(stack, TFCTags.Items.COMPOST_POISONS)) {
            return new Compost(AdditionType.POISON, 0);
        }
        if (Helpers.isItem(stack, TFCTags.Items.COMPOST_BROWNS_LOW)) {
            return new Compost(AdditionType.BROWN, 1);
        }
        if (Helpers.isItem(stack, TFCTags.Items.COMPOST_BROWNS_MEDIUM)) {
            return new Compost(AdditionType.BROWN, 2);
        }
        if (Helpers.isItem(stack, TFCTags.Items.COMPOST_BROWNS_HIGH)) {
            return new Compost(AdditionType.BROWN, rotten ? 2 : 4);
        }
        if (Helpers.isItem(stack, TFCTags.Items.COMPOST_GREENS_LOW)) {
            return new Compost(AdditionType.GREEN, 1);
        }
        if (Helpers.isItem(stack, TFCTags.Items.COMPOST_GREENS_MEDIUM)) {
            return new Compost(AdditionType.GREEN, 2);
        }
        if (Helpers.isItem(stack, TFCTags.Items.COMPOST_GREENS_HIGH)) {
            return new Compost(AdditionType.GREEN, rotten ? 2 : 4);
        }
        return new Compost(AdditionType.NONE, 0);
    }

    public record Compost(AdditionType type, int amount) {
    }

    public static enum AdditionType {
        NONE,
        GREEN,
        BROWN,
        POISON;

    }
}

