/*
 * Decompiled with CFR 0.152.
 */
package net.dries007.tfc.common.blockentities;

import com.google.common.collect.ImmutableList;
import java.util.List;
import java.util.function.Function;
import java.util.function.Predicate;
import net.dries007.tfc.common.blockentities.IHeatable;
import net.dries007.tfc.common.blockentities.InventoryBlockEntity;
import net.dries007.tfc.common.blockentities.TFCBlockEntities;
import net.dries007.tfc.common.blockentities.TickableInventoryBlockEntity;
import net.dries007.tfc.common.capabilities.DelegateItemHandler;
import net.dries007.tfc.common.capabilities.InventoryItemHandler;
import net.dries007.tfc.common.capabilities.PartialFluidHandler;
import net.dries007.tfc.common.capabilities.PartialItemHandler;
import net.dries007.tfc.common.capabilities.SidedHandler;
import net.dries007.tfc.common.component.TFCComponents;
import net.dries007.tfc.common.component.block.CrucibleComponent;
import net.dries007.tfc.common.component.fluid.FluidContainer;
import net.dries007.tfc.common.component.fluid.FluidContainerInfo;
import net.dries007.tfc.common.component.food.FoodCapability;
import net.dries007.tfc.common.component.food.FoodTraits;
import net.dries007.tfc.common.component.heat.HeatCapability;
import net.dries007.tfc.common.component.heat.HeatComponent;
import net.dries007.tfc.common.component.heat.IHeat;
import net.dries007.tfc.common.component.heat.IHeatConsumer;
import net.dries007.tfc.common.component.mold.IMold;
import net.dries007.tfc.common.container.CrucibleContainer;
import net.dries007.tfc.common.fluids.FluidHelpers;
import net.dries007.tfc.common.recipes.HeatingRecipe;
import net.dries007.tfc.config.TFCConfig;
import net.dries007.tfc.util.FluidAlloy;
import net.dries007.tfc.util.Helpers;
import net.dries007.tfc.util.SyncableContainerData;
import net.dries007.tfc.util.calendar.ICalendarTickable;
import net.dries007.tfc.util.data.FluidHeat;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.HolderLookup;
import net.minecraft.core.component.DataComponentMap;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.Tag;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.inventory.ContainerData;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.material.Fluid;
import net.neoforged.neoforge.capabilities.Capabilities;
import net.neoforged.neoforge.common.util.INBTSerializable;
import net.neoforged.neoforge.fluids.FluidStack;
import net.neoforged.neoforge.fluids.capability.IFluidHandler;
import net.neoforged.neoforge.items.IItemHandler;
import net.neoforged.neoforge.items.IItemHandlerModifiable;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class CrucibleBlockEntity
extends TickableInventoryBlockEntity<CrucibleInventory>
implements ICalendarTickable,
IHeatable {
    public static final int SLOTS = 10;
    public static final int SLOT_INPUT_START = 0;
    public static final int SLOT_INPUT_END = 8;
    public static final int SLOT_OUTPUT = 9;
    private static final int TARGET_TEMPERATURE_STABILITY_TICKS = 5;
    private final SidedHandler<IFluidHandler> sidedFluidInventory;
    private final SyncableContainerData syncableData;
    private final HeatingRecipe[] cachedRecipes = new HeatingRecipe[9];
    private float temperature = 0.0f;
    private float targetTemperature = 0.0f;
    private boolean needsRecipeUpdate = true;
    private int targetTemperatureStabilityTicks;
    private int lastFillTicks = 0;
    private long lastUpdateTick = Integer.MIN_VALUE;
    private int fastPourSlot = 0;
    private int fastPourTicks = 0;

    public static void serverTick(Level level, BlockPos pos, BlockState state, CrucibleBlockEntity crucible) {
        crucible.checkForLastTickSync();
        crucible.checkForCalendarUpdate();
        if (crucible.needsRecipeUpdate) {
            crucible.needsRecipeUpdate = false;
            crucible.updateCaches();
        }
        if (crucible.temperature != crucible.targetTemperature) {
            crucible.temperature = HeatCapability.adjustTempTowards(crucible.temperature, crucible.targetTemperature);
        }
        if (crucible.targetTemperatureStabilityTicks > 0) {
            --crucible.targetTemperatureStabilityTicks;
        }
        if (crucible.targetTemperature > 0.0f && crucible.targetTemperatureStabilityTicks == 0) {
            crucible.targetTemperature = HeatCapability.adjustTempTowards(crucible.targetTemperature, 0.0f);
        }
        boolean canFill = crucible.lastFillTicks <= 0;
        for (int slot = 0; slot <= 8; ++slot) {
            ItemStack drainStack;
            IMold mold;
            IHeat inputHeat;
            ItemStack inputStack = ((CrucibleInventory)crucible.inventory).getStackInSlot(slot);
            if (!inputStack.isEmpty() && (inputHeat = HeatCapability.get(inputStack)) != null) {
                HeatCapability.addTemp(inputHeat, crucible.temperature, 2.0f + crucible.temperature * 0.0025f);
                HeatingRecipe recipe = crucible.cachedRecipes[slot];
                if (recipe != null && recipe.isValidTemperature(inputHeat.getTemperature())) {
                    ItemStack outputItem = recipe.assembleItem(inputStack);
                    FluidStack outputFluid = recipe.assembleFluid(inputStack);
                    FoodCapability.applyTrait(outputItem, FoodTraits.BURNT_TO_A_CRISP);
                    ((CrucibleInventory)crucible.inventory).setStackInSlot(slot, outputItem);
                    ((CrucibleInventory)crucible.inventory).fill(outputFluid, IFluidHandler.FluidAction.EXECUTE);
                    crucible.markForSync();
                }
            }
            if (!canFill || (mold = IMold.get(drainStack = ((CrucibleInventory)crucible.inventory).getStackInSlot(slot))) == null || !mold.isMolten() || !FluidHelpers.transferExact((IFluidHandler)mold, (IFluidHandler)crucible.inventory, 1)) continue;
            if (crucible.fastPourTicks >= 0 && crucible.fastPourSlot == slot) {
                --crucible.fastPourTicks;
                crucible.lastFillTicks = TFCConfig.SERVER.crucibleFastPouringRate.get();
            } else {
                crucible.lastFillTicks = TFCConfig.SERVER.cruciblePouringRate.get();
            }
            crucible.markForSync();
        }
        if (crucible.lastFillTicks > 0) {
            --crucible.lastFillTicks;
        }
        if (((CrucibleInventory)crucible.inventory).isMolten()) {
            FluidStack outputDrop = ((CrucibleInventory)crucible.inventory).drain(1, IFluidHandler.FluidAction.SIMULATE);
            FluidStack outputRemainder = Helpers.mergeOutputFluidIntoSlot(crucible.inventory, outputDrop, crucible.temperature, 9);
            if (outputRemainder.isEmpty()) {
                ((CrucibleInventory)crucible.inventory).drain(1, IFluidHandler.FluidAction.EXECUTE);
            }
            crucible.markForSync();
        }
    }

    public CrucibleBlockEntity(BlockPos pos, BlockState state) {
        super((BlockEntityType)TFCBlockEntities.CRUCIBLE.get(), pos, state, CrucibleInventory::new);
        this.sidedFluidInventory = new SidedHandler<IFluidHandler>((IFluidHandler)this.inventory);
        if (TFCConfig.SERVER.crucibleEnableAutomation.get().booleanValue()) {
            this.sidedInventory.on(new PartialItemHandler(this.inventory).insert(0, 1, 2, 3, 4, 5, 6, 7, 8), Direction.UP).on(new PartialItemHandler(this.inventory).insert(9).extract(9), (Predicate<Direction>)Direction.Plane.HORIZONTAL);
            this.sidedFluidInventory.on((IFluidHandler)((Function<IFluidHandler, IFluidHandler>)PartialFluidHandler::insertOnly), Direction.UP).on(PartialFluidHandler::extractOnly, (Predicate<Direction>)Direction.Plane.HORIZONTAL);
        }
        this.syncableData = new SyncableContainerData().add(() -> (int)this.temperature, value -> {
            this.temperature = value;
        });
    }

    @Nullable
    public IFluidHandler getSidedFluidInventory(@Nullable Direction context) {
        return this.sidedFluidInventory.get(context);
    }

    @Override
    public float getTemperature() {
        return this.temperature;
    }

    public FluidAlloy getAlloy() {
        return ((CrucibleInventory)this.inventory).alloy;
    }

    public FluidStack getAlloyResult() {
        assert (this.level != null);
        return ((CrucibleInventory)this.inventory).alloy.getResult(this.level);
    }

    public FluidContainerInfo containerInfo() {
        return CrucibleInventory.INFO;
    }

    public ContainerData getSyncableData() {
        return this.syncableData;
    }

    @Override
    public boolean isItemValid(int slot, ItemStack stack) {
        return HeatCapability.has(stack) && (slot != 9 || Helpers.mightHaveCapability(stack, Capabilities.FluidHandler.ITEM));
    }

    @Override
    public void onCalendarUpdate(long ticks) {
        assert (this.level != null);
        this.targetTemperature = HeatCapability.adjustTempTowards(this.targetTemperature, 0.0f, ticks);
        this.temperature = HeatCapability.adjustTempTowards(this.temperature, this.targetTemperature, ticks);
    }

    @Override
    public int getSlotStackLimit(int slot) {
        return 1;
    }

    @Override
    @Deprecated
    public long getLastCalendarUpdateTick() {
        return this.lastUpdateTick;
    }

    @Override
    @Deprecated
    public void setLastCalendarUpdateTick(long tick) {
        this.lastUpdateTick = tick;
    }

    @Override
    @Nullable
    public AbstractContainerMenu createMenu(int containerId, Inventory inventory, Player player) {
        return CrucibleContainer.create(this, player.getInventory(), containerId);
    }

    @Override
    protected void applyImplicitComponents(BlockEntity.DataComponentInput components) {
        CrucibleComponent crucible = (CrucibleComponent)components.getOrDefault(TFCComponents.CRUCIBLE, (Object)CrucibleComponent.EMPTY);
        HeatComponent heat = (HeatComponent)components.getOrDefault(TFCComponents.HEAT, (Object)HeatComponent.EMPTY);
        this.temperature = heat.getTemperature();
        Helpers.copyFrom(crucible.itemContent(), this.inventory);
        ((CrucibleInventory)this.inventory).alloy.copyFrom(crucible.fluidContent());
        super.applyImplicitComponents(components);
    }

    @Override
    protected void collectImplicitComponents(DataComponentMap.Builder builder) {
        assert (this.level != null);
        FluidHeat heat = FluidHeat.getOrUnknown(((CrucibleInventory)this.inventory).alloy.getResult(this.level));
        float heatCapacity = heat.heatCapacity(((CrucibleInventory)this.inventory).alloy.getAmount());
        ImmutableList.Builder inventoryList = ImmutableList.builder();
        Helpers.copyTo((ImmutableList.Builder<ItemStack>)inventoryList, (IItemHandler)this.inventory);
        builder.set(TFCComponents.CRUCIBLE, (Object)new CrucibleComponent((List<ItemStack>)inventoryList.build(), ((CrucibleInventory)this.inventory).alloy.copy()));
        builder.set(TFCComponents.HEAT, (Object)HeatComponent.of(2.0f + heatCapacity, this.temperature));
        super.collectImplicitComponents(builder);
    }

    @Override
    public void loadAdditional(CompoundTag nbt, HolderLookup.Provider provider) {
        this.temperature = nbt.getFloat("temperature");
        this.targetTemperature = nbt.getFloat("targetTemperature");
        this.targetTemperatureStabilityTicks = nbt.getInt("targetTemperatureStabilityTicks");
        this.lastUpdateTick = nbt.getLong("lastUpdateTick");
        this.needsRecipeUpdate = true;
        super.loadAdditional(nbt, provider);
    }

    @Override
    public void saveAdditional(CompoundTag nbt, HolderLookup.Provider provider) {
        nbt.putFloat("temperature", this.temperature);
        nbt.putFloat("targetTemperature", this.targetTemperature);
        nbt.putInt("targetTemperatureStabilityTicks", this.targetTemperatureStabilityTicks);
        nbt.putLong("lastUpdateTick", this.lastUpdateTick);
        super.saveAdditional(nbt, provider);
    }

    @Override
    public void setAndUpdateSlots(int slot) {
        super.setAndUpdateSlots(slot);
        if (slot != 9) {
            this.cachedRecipes[slot] = HeatingRecipe.getRecipe(((CrucibleInventory)this.inventory).getStackInSlot(slot));
        }
    }

    public void setFastPouring(int slot) {
        this.fastPourSlot = slot;
        this.fastPourTicks = 20;
    }

    private void updateCaches() {
        for (int slot = 0; slot <= 8; ++slot) {
            this.cachedRecipes[slot] = HeatingRecipe.getRecipe(((CrucibleInventory)this.inventory).getStackInSlot(slot));
        }
    }

    public static class CrucibleInventory
    implements DelegateItemHandler,
    FluidContainer,
    IHeatConsumer,
    INBTSerializable<CompoundTag> {
        private static final FluidContainerInfo INFO = new FluidContainerInfo(){

            @Override
            public boolean canContainFluid(Fluid input) {
                return FluidHeat.get(input) != null;
            }

            @Override
            public int fluidCapacity() {
                return TFCConfig.SERVER.crucibleCapacity.get();
            }
        };
        private final CrucibleBlockEntity crucible;
        private final InventoryItemHandler inventory;
        private final FluidAlloy alloy;

        CrucibleInventory(InventoryBlockEntity<?> entity) {
            this.crucible = (CrucibleBlockEntity)entity;
            this.inventory = new InventoryItemHandler(entity, 10);
            this.alloy = FluidAlloy.empty();
        }

        @Override
        public FluidContainerInfo containerInfo() {
            return INFO;
        }

        public boolean isMolten() {
            assert (this.crucible.level != null);
            @Nullable FluidHeat metal = FluidHeat.get(this.alloy.getResult(this.crucible.level).getFluid());
            return metal == null || this.crucible.temperature > metal.meltTemperature();
        }

        @Override
        public IItemHandlerModifiable getItemHandler() {
            return this.inventory;
        }

        public CompoundTag serializeNBT(HolderLookup.Provider provider) {
            CompoundTag nbt = new CompoundTag();
            nbt.put("inventory", (Tag)this.inventory.serializeNBT(provider));
            nbt.put("alloy", this.alloy.serializeNBT());
            return nbt;
        }

        public void deserializeNBT(HolderLookup.Provider provider, CompoundTag nbt) {
            this.inventory.deserializeNBT(provider, nbt.getCompound("inventory"));
            this.alloy.deserializeNBT(nbt.getCompound("alloy"));
        }

        @NotNull
        public FluidStack getFluidInTank(int tank) {
            assert (this.crucible.level != null);
            return this.alloy.getResult(this.crucible.level);
        }

        @Override
        public int getTankCapacity(int tank) {
            return INFO.fluidCapacity();
        }

        @Override
        public boolean isFluidValid(int tank, @NotNull FluidStack stack) {
            return FluidHeat.get(stack.getFluid()) != null;
        }

        public int fill(FluidStack resource, IFluidHandler.FluidAction action) {
            return this.alloy.fill(resource, action, INFO);
        }

        @NotNull
        public FluidStack drain(int maxDrain, IFluidHandler.FluidAction action) {
            if (this.isMolten()) {
                assert (this.crucible.level != null);
                FluidStack result = this.alloy.drain(this.crucible.level, maxDrain, action);
                if (action.execute()) {
                    this.crucible.markForSync();
                }
                return result;
            }
            return FluidStack.EMPTY;
        }

        @Override
        public float getTemperature() {
            return this.crucible.temperature;
        }

        @Override
        public void setTemperature(float temperature) {
            if (temperature >= this.crucible.temperature) {
                this.crucible.temperature = temperature;
                this.crucible.targetTemperatureStabilityTicks = 5;
                this.crucible.markForSync();
            }
        }
    }
}

