/*
 * Decompiled with CFR 0.152.
 */
package net.dries007.tfc.common.blockentities;

import net.dries007.tfc.common.blockentities.TFCBlockEntities;
import net.dries007.tfc.common.blockentities.TFCBlockEntity;
import net.dries007.tfc.common.blocks.crop.DecayingBlock;
import net.dries007.tfc.common.component.food.FoodCapability;
import net.minecraft.core.BlockPos;
import net.minecraft.core.HolderLookup;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockState;

public class DecayingBlockEntity
extends TFCBlockEntity {
    private ItemStack stack = ItemStack.EMPTY;

    public static void serverTick(Level level, BlockPos pos, BlockState state, DecayingBlockEntity decaying) {
        Block block;
        if (level.getGameTime() % 20L == 0L && decaying.isRotten() && (block = state.getBlock()) instanceof DecayingBlock) {
            DecayingBlock block2 = (DecayingBlock)block;
            decaying.setStack(ItemStack.EMPTY);
            level.setBlockAndUpdate(pos, block2.getRottedBlock().defaultBlockState());
        }
    }

    public DecayingBlockEntity(BlockPos pos, BlockState state) {
        super((BlockEntityType)TFCBlockEntities.DECAYING.get(), pos, state);
    }

    protected DecayingBlockEntity(BlockEntityType<?> type, BlockPos pos, BlockState state) {
        super(type, pos, state);
    }

    @Override
    public void loadAdditional(CompoundTag nbt, HolderLookup.Provider provider) {
        super.loadAdditional(nbt, provider);
        this.stack = ItemStack.parseOptional((HolderLookup.Provider)provider, (CompoundTag)nbt.getCompound("item"));
    }

    @Override
    public void saveAdditional(CompoundTag nbt, HolderLookup.Provider provider) {
        super.saveAdditional(nbt, provider);
        if (!this.stack.isEmpty()) {
            nbt.put("item", this.stack.save(provider));
        }
    }

    public boolean isRotten() {
        return this.stack.isEmpty() || FoodCapability.isRotten(this.stack);
    }

    public ItemStack getStack() {
        return this.stack;
    }

    public void setStack(ItemStack stack) {
        this.stack = stack.copyWithCount(1);
    }
}

