/*
 * Decompiled with CFR 0.152.
 */
package net.dries007.tfc.common.blockentities;

import java.util.ArrayDeque;
import java.util.ArrayList;
import java.util.List;
import javax.annotation.Nullable;
import net.dries007.tfc.common.TFCTags;
import net.dries007.tfc.common.blockentities.IHeatable;
import net.dries007.tfc.common.blockentities.PlacedItemBlockEntity;
import net.dries007.tfc.common.blockentities.TFCBlockEntities;
import net.dries007.tfc.common.blockentities.TickableInventoryBlockEntity;
import net.dries007.tfc.common.blocks.FireboxBlock;
import net.dries007.tfc.common.component.heat.Heat;
import net.dries007.tfc.common.component.heat.HeatCapability;
import net.dries007.tfc.common.component.heat.IHeat;
import net.dries007.tfc.common.container.FireboxContainer;
import net.dries007.tfc.common.recipes.HeatingRecipe;
import net.dries007.tfc.util.Helpers;
import net.dries007.tfc.util.calendar.Calendars;
import net.dries007.tfc.util.calendar.ICalendarTickable;
import net.dries007.tfc.util.data.Fuel;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.HolderLookup;
import net.minecraft.core.Vec3i;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.util.Mth;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.block.DoorBlock;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;
import net.neoforged.neoforge.items.ItemStackHandler;

public class FireboxBlockEntity
extends TickableInventoryBlockEntity<ItemStackHandler>
implements ICalendarTickable,
IHeatable {
    public static final int SLOTS = 16;
    private static final Direction[] NOT_DOWN = new Direction[]{Direction.NORTH, Direction.SOUTH, Direction.EAST, Direction.WEST, Direction.UP};
    private long lastPlayerTick;
    private long heatingTimestamp;
    private int burnTicks = 0;
    private int airTicks = 0;
    private int heatingCount = 0;
    private float temperature = 0.0f;
    private float burnTemperature = 0.0f;
    private boolean needsSlotUpdate = true;
    private List<BlockPos> operableBlocks = new ArrayList<BlockPos>();

    public static void serverTick(Level level, BlockPos pos, BlockState state, FireboxBlockEntity box) {
        box.checkForLastTickSync();
        box.checkForCalendarUpdate();
        if (((Boolean)state.getValue((Property)FireboxBlock.LIT)).booleanValue()) {
            if (box.burnTicks > 0) {
                box.burnTicks = box.burnTicks - (box.airTicks > 0 ? 2 : 1);
            }
            if (box.burnTicks <= 0 && !box.consumeFuel()) {
                box.extinguish(state);
            }
        } else if (box.burnTemperature > 0.0f) {
            box.extinguish(state);
        }
        if (box.airTicks > 0) {
            --box.airTicks;
        }
        if (box.temperature > 0.0f || box.burnTemperature > 0.0f) {
            box.temperature = HeatCapability.adjustDeviceTemp(box.temperature, box.burnTemperature, box.airTicks, false);
            HeatCapability.provideHeatTo(level, pos.above(), Direction.DOWN, box.temperature);
            box.markForSync();
        }
        if (box.needsSlotUpdate) {
            box.cascadeFuelSlots();
        }
        if (level.getGameTime() % 200L == 0L) {
            int oldCap = box.heatingCount;
            box.operableBlocks = FireboxBlockEntity.floodfill(level, pos.above(), box);
            if (oldCap != box.operableBlocks.size()) {
                box.heatingCount = box.operableBlocks.size();
                box.heatingTimestamp = Calendars.SERVER.getTicks();
                box.markForSync();
            }
        }
        if (box.temperature == 0.0f || box.heatingCount < 4 || Math.abs(box.temperature - box.burnTemperature) > 601.0f) {
            box.heatingTimestamp = Calendars.SERVER.getTicks();
        }
        if (box.getTimeLeft() <= 0L) {
            FireboxBlockEntity.performHeating(level, box, box.operableBlocks);
        }
    }

    private static List<BlockPos> floodfill(Level level, BlockPos pos, FireboxBlockEntity firebox) {
        if (level.isClientSide || firebox.temperature <= 0.0f) {
            return new ArrayList<BlockPos>();
        }
        BlockPos.MutableBlockPos cursor = new BlockPos.MutableBlockPos();
        ArrayList<BlockPos> positions = new ArrayList<BlockPos>(!firebox.operableBlocks.isEmpty() ? firebox.operableBlocks.size() : 16);
        ArrayDeque<Path> queue = new ArrayDeque<Path>();
        positions.add(pos);
        record Path(BlockPos pos, int cost) {
        }
        queue.add(new Path(pos, 0));
        int capacity = firebox.getTotalHeatableBlocks();
        block0: while (!queue.isEmpty()) {
            Path current = (Path)queue.remove();
            if (--capacity <= 0) {
                positions.clear();
                break;
            }
            for (Direction direction : NOT_DOWN) {
                BlockState state;
                cursor.setWithOffset((Vec3i)current.pos, direction);
                if (positions.contains(cursor.immutable()) || FireboxBlockEntity.isValidExterior(level, cursor, state = level.getBlockState((BlockPos)cursor), direction)) continue;
                if (FireboxBlockEntity.isValidInterior(state)) {
                    BlockPos posNext = cursor.immutable();
                    queue.add(new Path(posNext, current.cost + 1));
                    positions.add(posNext);
                    continue;
                }
                positions.clear();
                continue block0;
            }
        }
        return positions;
    }

    private static void performHeating(Level level, FireboxBlockEntity firebox, List<BlockPos> filled) {
        filled.forEach(testPos -> {
            if (level.getBlockEntity(testPos) instanceof PlacedItemBlockEntity) {
                BlockEntity patt0$temp;
                if (level instanceof ServerLevel) {
                    ServerLevel server = (ServerLevel)level;
                    if (level.random.nextFloat() < 0.01f) {
                        server.sendParticles((ParticleOptions)ParticleTypes.FLAME, (double)testPos.getX() + 0.5, (double)testPos.getY() + 0.5, (double)testPos.getZ() + 0.5, 1, 0.0, 0.0, 0.0, 0.01);
                    }
                }
                if ((patt0$temp = level.getBlockEntity(testPos)) instanceof PlacedItemBlockEntity) {
                    PlacedItemBlockEntity placedItem = (PlacedItemBlockEntity)patt0$temp;
                    Object inv = placedItem.getInventory();
                    for (int i = 0; i < inv.getSlots(); ++i) {
                        HeatingRecipe recipe;
                        ItemStack item = inv.getStackInSlot(i);
                        IHeat heat = HeatCapability.get(item);
                        if (heat == null) continue;
                        HeatCapability.addTemp(heat, firebox.temperature);
                        if (level.getGameTime() % 20L != 0L || (recipe = HeatingRecipe.getRecipe(item)) == null || !recipe.matches(item) || !recipe.isValidTemperature(heat.getTemperature())) continue;
                        ItemStack output = recipe.assembleItem(item);
                        item.setCount(0);
                        inv.insertItem(i, output, false);
                        placedItem.markForSync();
                    }
                }
            }
        });
    }

    private static boolean isValidInterior(BlockState state) {
        return !state.canOcclude() || Helpers.isBlock(state, TFCTags.Blocks.HEAT_PASSABLE);
    }

    private static boolean isValidExterior(Level level, BlockPos.MutableBlockPos cursor, BlockState state, Direction direction) {
        return Helpers.isBlock(state, TFCTags.Blocks.HEAT_INSULATION) && (state.isFaceSturdy((BlockGetter)level, (BlockPos)cursor, direction.getOpposite()) || state.getBlock() instanceof DoorBlock);
    }

    public FireboxBlockEntity(BlockPos pos, BlockState state) {
        super((BlockEntityType)TFCBlockEntities.FIREBOX.get(), pos, state, FireboxBlockEntity.defaultInventory(16));
        this.lastPlayerTick = Calendars.SERVER.getTicks();
        this.heatingTimestamp = Calendars.SERVER.getTicks();
    }

    public int getHeatingCount() {
        return this.heatingCount;
    }

    public int getTotalHeatableBlocks() {
        return this.temperature >= Heat.BRIGHT_RED.getMin() ? 128 : 64;
    }

    public int getTimeToHeat() {
        int maxBlocks = this.getTotalHeatableBlocks();
        int hour = 1000;
        return (int)Math.max(3000.0f, 3000.0f + Mth.clampedMap((float)this.heatingCount, (float)0.0f, (float)maxBlocks, (float)0.0f, (float)24000.0f) - Mth.clampedMap((float)this.temperature, (float)700.0f, (float)Heat.maxVisibleTemperature(), (float)0.0f, (float)6000.0f));
    }

    public long getTimeLeft() {
        assert (this.level != null);
        if (this.heatingTimestamp == 0L) {
            return -1L;
        }
        return (long)this.getTimeToHeat() - (Calendars.get((LevelReader)this.level).getTicks() - this.heatingTimestamp);
    }

    public boolean isHeating() {
        return this.operableBlocks.size() > 4;
    }

    public void extinguish(BlockState state) {
        assert (this.level != null);
        this.level.setBlockAndUpdate(this.worldPosition, (BlockState)state.setValue((Property)FireboxBlock.LIT, (Comparable)Boolean.valueOf(false)));
        this.burnTicks = 0;
        this.burnTemperature = 0.0f;
        this.temperature = 0.0f;
        this.markForSync();
    }

    public void intakeAir(int amount) {
        this.airTicks += amount;
        if (this.airTicks > 600) {
            this.airTicks = 600;
        }
    }

    @Override
    public void onCalendarUpdate(long ticks) {
        assert (this.level != null);
        BlockState state = this.level.getBlockState(this.worldPosition);
        if (((Boolean)state.getValue((Property)FireboxBlock.LIT)).booleanValue()) {
            HeatCapability.Remainder remainder = HeatCapability.consumeFuelForTicks(ticks, this.inventory, this.burnTicks, this.burnTemperature, 0, 15);
            this.burnTicks = remainder.burnTicks();
            this.burnTemperature = remainder.burnTemperature();
            this.needsSlotUpdate = true;
            if (remainder.ticks() > 0L) {
                this.extinguish(state);
            }
        }
    }

    public boolean light(BlockState state) {
        assert (this.level != null);
        if (this.burnTicks > 0) {
            return true;
        }
        if (this.consumeFuel()) {
            this.level.setBlockAndUpdate(this.worldPosition, (BlockState)state.setValue((Property)FireboxBlock.LIT, (Comparable)Boolean.valueOf(true)));
            return true;
        }
        return false;
    }

    private boolean consumeFuel() {
        ItemStack fuelStack = ((ItemStackHandler)this.inventory).getStackInSlot(0);
        if (!fuelStack.isEmpty()) {
            ((ItemStackHandler)this.inventory).setStackInSlot(0, ItemStack.EMPTY);
            this.needsSlotUpdate = true;
            Fuel fuel = Fuel.get(fuelStack);
            if (fuel != null) {
                this.burnTicks += fuel.duration();
                this.burnTemperature = fuel.temperature();
            }
            this.markForSync();
        }
        return this.burnTicks > 0;
    }

    @Override
    public float getTemperature() {
        return this.temperature;
    }

    @Override
    public void loadAdditional(CompoundTag nbt, HolderLookup.Provider provider) {
        this.temperature = nbt.getFloat("temperature");
        this.burnTicks = nbt.getInt("burnTicks");
        this.airTicks = nbt.getInt("airTicks");
        this.heatingCount = nbt.getInt("heatingCount");
        this.burnTemperature = nbt.getFloat("burnTemperature");
        this.lastPlayerTick = nbt.getLong("lastPlayerTick");
        this.heatingTimestamp = nbt.getLong("heatingTimestamp");
        super.loadAdditional(nbt, provider);
    }

    @Override
    public void saveAdditional(CompoundTag nbt, HolderLookup.Provider provider) {
        nbt.putFloat("temperature", this.temperature);
        nbt.putInt("burnTicks", this.burnTicks);
        nbt.putInt("airTicks", this.airTicks);
        nbt.putInt("heatingCount", this.heatingCount);
        nbt.putFloat("burnTemperature", this.burnTemperature);
        nbt.putLong("lastPlayerTick", this.lastPlayerTick);
        nbt.putLong("heatingTimestamp", this.heatingTimestamp);
        super.saveAdditional(nbt, provider);
    }

    @Override
    public void setAndUpdateSlots(int slot) {
        super.setAndUpdateSlots(slot);
        this.needsSlotUpdate = true;
    }

    @Override
    public boolean isItemValid(int slot, ItemStack stack) {
        return Fuel.get(stack) != null;
    }

    @Override
    public int getSlotStackLimit(int slot) {
        return 1;
    }

    @Override
    @Deprecated
    public long getLastCalendarUpdateTick() {
        return this.lastPlayerTick;
    }

    @Override
    @Deprecated
    public void setLastCalendarUpdateTick(long tick) {
        this.lastPlayerTick = tick;
    }

    @Override
    @Nullable
    public AbstractContainerMenu createMenu(int windowID, Inventory playerInv, Player player) {
        return FireboxContainer.create(this, playerInv, windowID);
    }

    private void cascadeFuelSlots() {
        int lowestAvailSlot = 0;
        for (int i = 0; i < 16; ++i) {
            ItemStack stack = ((ItemStackHandler)this.inventory).getStackInSlot(i);
            if (stack.isEmpty()) continue;
            if (i > lowestAvailSlot) {
                ((ItemStackHandler)this.inventory).setStackInSlot(lowestAvailSlot, stack.copy());
                ((ItemStackHandler)this.inventory).setStackInSlot(i, ItemStack.EMPTY);
            }
            ++lowestAvailSlot;
        }
        this.needsSlotUpdate = false;
    }
}

