/*
 * Decompiled with CFR 0.152.
 */
package net.dries007.tfc.common.blockentities;

import java.util.function.Predicate;
import net.dries007.tfc.common.blockentities.AbstractFirepitBlockEntity;
import net.dries007.tfc.common.blockentities.TFCBlockEntities;
import net.dries007.tfc.common.capabilities.PartialItemHandler;
import net.dries007.tfc.common.component.heat.HeatCapability;
import net.dries007.tfc.common.component.heat.IHeat;
import net.dries007.tfc.common.container.FirepitContainer;
import net.dries007.tfc.common.recipes.HeatingRecipe;
import net.dries007.tfc.config.TFCConfig;
import net.dries007.tfc.util.Helpers;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.world.Containers;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockState;
import net.neoforged.neoforge.fluids.FluidStack;
import net.neoforged.neoforge.items.ItemStackHandler;
import org.jetbrains.annotations.Nullable;

public class FirepitBlockEntity
extends AbstractFirepitBlockEntity<ItemStackHandler> {
    public static final int SLOT_ITEM_INPUT = 4;
    public static final int SLOT_OUTPUT_1 = 5;
    public static final int SLOT_OUTPUT_2 = 6;
    @Nullable
    protected HeatingRecipe cachedRecipe;

    public FirepitBlockEntity(BlockPos pos, BlockState state) {
        super((BlockEntityType)TFCBlockEntities.FIREPIT.get(), pos, state, FirepitBlockEntity.defaultInventory(7));
        if (TFCConfig.SERVER.firePitEnableAutomation.get().booleanValue()) {
            this.sidedInventory.on(new PartialItemHandler(this.inventory).insert(3).extract(5, 6), (Predicate<Direction>)Direction.Plane.HORIZONTAL).on(new PartialItemHandler(this.inventory).insert(4), Direction.UP);
        }
    }

    @Override
    @Nullable
    public AbstractContainerMenu createMenu(int windowID, Inventory playerInv, Player player) {
        return FirepitContainer.create(this, playerInv, windowID);
    }

    @Override
    protected void handleCooking() {
        ItemStack inputStack;
        IHeat cap;
        assert (this.level != null);
        if (this.temperature > 0.0f && (cap = HeatCapability.get(inputStack = ((ItemStackHandler)this.inventory).getStackInSlot(4))) != null) {
            float itemTemp = cap.getTemperature();
            HeatCapability.addTemp(cap, this.temperature);
            if (this.cachedRecipe != null && this.cachedRecipe.isValidTemperature(itemTemp)) {
                HeatingRecipe recipe = this.cachedRecipe;
                ((ItemStackHandler)this.inventory).setStackInSlot(4, ItemStack.EMPTY);
                this.mergeOutputStack(recipe.assembleItem(inputStack));
                this.mergeOutputFluids(recipe.assembleFluid(inputStack), cap.getTemperature());
            }
        }
    }

    @Override
    protected void coolInstantly() {
        HeatCapability.setTemperature(((ItemStackHandler)this.inventory).getStackInSlot(4), 0.0f);
    }

    @Override
    protected void updateCachedRecipe() {
        this.cachedRecipe = HeatingRecipe.getRecipe(((ItemStackHandler)this.inventory).getStackInSlot(4));
    }

    private void mergeOutputStack(ItemStack outputStack) {
        if ((outputStack = ((ItemStackHandler)this.inventory).insertItem(5, outputStack, false)).isEmpty()) {
            return;
        }
        if ((outputStack = ((ItemStackHandler)this.inventory).insertItem(6, outputStack, false)).isEmpty()) {
            return;
        }
        assert (this.level != null);
        Containers.dropItemStack((Level)this.level, (double)this.worldPosition.getX(), (double)this.worldPosition.getY(), (double)this.worldPosition.getZ(), (ItemStack)outputStack);
    }

    private void mergeOutputFluids(FluidStack fluidStack, float temperature) {
        fluidStack = Helpers.mergeOutputFluidIntoSlot(this.inventory, fluidStack, temperature, 5);
        Helpers.mergeOutputFluidIntoSlot(this.inventory, fluidStack, temperature, 6);
    }
}

