/*
 * Decompiled with CFR 0.152.
 */
package net.dries007.tfc.common.blockentities;

import java.util.function.Predicate;
import net.dries007.tfc.common.blockentities.AbstractFirepitBlockEntity;
import net.dries007.tfc.common.blockentities.TFCBlockEntities;
import net.dries007.tfc.common.capabilities.PartialItemHandler;
import net.dries007.tfc.common.component.food.FoodCapability;
import net.dries007.tfc.common.component.food.FoodTraits;
import net.dries007.tfc.common.component.heat.HeatCapability;
import net.dries007.tfc.common.component.heat.IHeat;
import net.dries007.tfc.common.container.GrillContainer;
import net.dries007.tfc.common.recipes.HeatingRecipe;
import net.dries007.tfc.config.TFCConfig;
import net.dries007.tfc.util.Helpers;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockState;
import net.neoforged.neoforge.items.IItemHandler;
import net.neoforged.neoforge.items.ItemStackHandler;
import org.jetbrains.annotations.Nullable;

public class GrillBlockEntity
extends AbstractFirepitBlockEntity<ItemStackHandler> {
    public static final int SLOT_EXTRA_INPUT_START = 4;
    public static final int SLOT_EXTRA_INPUT_END = 8;
    private final HeatingRecipe[] cachedRecipes = new HeatingRecipe[5];

    public GrillBlockEntity(BlockPos pos, BlockState state) {
        super((BlockEntityType)TFCBlockEntities.GRILL.get(), pos, state, GrillBlockEntity.defaultInventory(9));
        if (TFCConfig.SERVER.firePitEnableAutomation.get().booleanValue()) {
            this.sidedInventory.on(new PartialItemHandler(this.inventory).insert(3).extract(4, 5, 6, 7, 8), (Predicate<Direction>)Direction.Plane.HORIZONTAL).on(new PartialItemHandler(this.inventory).insert(4, 5, 6, 7, 8), Direction.UP);
        }
    }

    @Override
    @Nullable
    public AbstractContainerMenu createMenu(int windowID, Inventory playerInv, Player player) {
        return GrillContainer.create(this, playerInv, windowID);
    }

    @Override
    public int getSlotStackLimit(int slot) {
        return 1;
    }

    @Override
    public boolean isItemValid(int slot, ItemStack stack) {
        if (slot >= 4 && slot <= 8) {
            return HeatCapability.has(stack);
        }
        return super.isItemValid(slot, stack);
    }

    @Override
    protected void handleCooking() {
        assert (this.level != null);
        for (int slot = 4; slot <= 8; ++slot) {
            ItemStack inputStack = ((ItemStackHandler)this.inventory).getStackInSlot(slot);
            @Nullable IHeat inputHeat = HeatCapability.get(inputStack);
            if (inputHeat == null) continue;
            HeatCapability.addTemp(inputHeat, this.temperature);
            HeatingRecipe recipe = this.cachedRecipes[slot - 4];
            if (recipe == null || !recipe.isValidTemperature(inputHeat.getTemperature())) continue;
            ItemStack output = recipe.assembleItem(inputStack);
            FoodCapability.applyTrait(output, FoodTraits.WOOD_GRILLED);
            ((ItemStackHandler)this.inventory).setStackInSlot(slot, output);
            this.markForSync();
        }
    }

    @Override
    protected void coolInstantly() {
        for (ItemStack stack : Helpers.iterate((IItemHandler)this.inventory)) {
            HeatCapability.setTemperature(stack, 0.0f);
        }
    }

    @Override
    protected void updateCachedRecipe() {
        for (int slot = 4; slot <= 8; ++slot) {
            ItemStack stack = ((ItemStackHandler)this.inventory).getStackInSlot(slot);
            this.cachedRecipes[slot - 4] = stack.isEmpty() ? null : HeatingRecipe.getRecipe(stack);
        }
    }
}

