/*
 * Decompiled with CFR 0.152.
 */
package net.dries007.tfc.common.blockentities;

import it.unimi.dsi.fastutil.objects.Object2IntMap;
import it.unimi.dsi.fastutil.objects.Object2IntOpenHashMap;
import java.util.ArrayDeque;
import java.util.Comparator;
import java.util.function.Supplier;
import net.dries007.tfc.common.TFCTags;
import net.dries007.tfc.common.blockentities.TFCBlockEntities;
import net.dries007.tfc.common.blockentities.TickableBlockEntity;
import net.dries007.tfc.common.blocks.HotPouredGlassBlock;
import net.dries007.tfc.util.Helpers;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.HolderGetter;
import net.minecraft.core.HolderLookup;
import net.minecraft.core.Vec3i;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.core.registries.Registries;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.NbtUtils;
import net.minecraft.nbt.Tag;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.util.Mth;
import net.minecraft.util.ParticleUtils;
import net.minecraft.util.RandomSource;
import net.minecraft.util.valueproviders.IntProvider;
import net.minecraft.util.valueproviders.UniformInt;
import net.minecraft.world.item.BlockItem;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.phys.Vec3;

public class HotPouredGlassBlockEntity
extends TickableBlockEntity {
    private int capacity = 0;
    private boolean isInitialTransition = true;
    private int animationTicks = 0;
    private boolean initialized = false;
    private BlockState internalState = Blocks.AIR.defaultBlockState();

    public static void tick(Level level, BlockPos pos, BlockState state, HotPouredGlassBlockEntity glass) {
        glass.checkForLastTickSync();
        if (!glass.initialized) {
            return;
        }
        if (glass.animationTicks > 0) {
            --glass.animationTicks;
        } else if (glass.isInitialTransition) {
            glass.isInitialTransition = false;
            if (glass.capacity > 0) {
                HotPouredGlassBlockEntity.doFloodFill(level, pos, state, glass);
                glass.capacity = 0;
            }
            glass.markForSync();
        } else {
            level.setBlockAndUpdate(pos, glass.internalState);
            Helpers.playSound(level, pos, SoundEvents.FIRE_EXTINGUISH);
            RandomSource random = level.getRandom();
            Supplier<Vec3> supplier = () -> new Vec3(Mth.nextDouble((RandomSource)level.getRandom(), (double)-0.005f, (double)0.005f), Mth.nextDouble((RandomSource)random, (double)-0.005f, (double)0.005f), Mth.nextDouble((RandomSource)random, (double)-0.005f, (double)0.005f));
            ParticleUtils.spawnParticlesOnBlockFace((Level)level, (BlockPos)pos.below(), (ParticleOptions)ParticleTypes.SMOKE, (IntProvider)UniformInt.of((int)4, (int)10), (Direction)Direction.UP, supplier, (double)0.6);
        }
    }

    private static void doFloodFill(Level level, BlockPos pos, BlockState state, HotPouredGlassBlockEntity center) {
        if (level.isClientSide) {
            return;
        }
        BlockPos.MutableBlockPos cursor = new BlockPos.MutableBlockPos();
        Object2IntOpenHashMap filled = new Object2IntOpenHashMap();
        ArrayDeque<Path> queue = new ArrayDeque<Path>();
        filled.put((Object)pos, 0);
        record Path(BlockPos pos, int cost) {
        }
        queue.add(new Path(pos, 0));
        int maxCost = -1;
        int capacity = center.capacity;
        while (!queue.isEmpty()) {
            Path current = (Path)queue.remove();
            if (--capacity >= 0 && current.cost > maxCost) {
                maxCost = current.cost;
            }
            if (capacity <= 0 && current.cost > maxCost) break;
            for (Direction direction : Direction.Plane.HORIZONTAL) {
                cursor.setWithOffset((Vec3i)current.pos, direction);
                if (filled.containsKey((Object)cursor) || !HotPouredGlassBlockEntity.canFloodFillAt(level, cursor)) continue;
                BlockPos posNext = cursor.immutable();
                queue.add(new Path(posNext, current.cost + 1));
                filled.put((Object)posNext, current.cost + 1);
            }
        }
        filled.object2IntEntrySet().stream().sorted(Comparator.comparingInt(Object2IntMap.Entry::getIntValue).thenComparing(e -> ((BlockPos)e.getKey()).distSqr((Vec3i)pos))).limit(16L).forEach(entry -> {
            BlockPos fillPos = (BlockPos)entry.getKey();
            int cost = entry.getIntValue();
            level.setBlockAndUpdate(fillPos, (BlockState)state.setValue((Property)HotPouredGlassBlock.FLAT, (Comparable)Boolean.valueOf(true)));
            BlockEntity patt0$temp = level.getBlockEntity(fillPos);
            if (patt0$temp instanceof HotPouredGlassBlockEntity) {
                HotPouredGlassBlockEntity side = (HotPouredGlassBlockEntity)patt0$temp;
                side.isInitialTransition = false;
                side.animationTicks = 40 + cost * 10;
                side.initialized = true;
                side.capacity = 0;
                side.internalState = center.internalState;
                side.markForSync();
            }
        });
    }

    private static boolean canFloodFillAt(Level level, BlockPos.MutableBlockPos cursor) {
        if (level.getBlockState((BlockPos)cursor).isAir()) {
            cursor.move(Direction.DOWN);
            if (Helpers.isBlock(level.getBlockState((BlockPos)cursor), TFCTags.Blocks.GLASS_POURING_TABLE)) {
                cursor.move(Direction.UP);
                return true;
            }
            cursor.move(Direction.UP);
        }
        return false;
    }

    public HotPouredGlassBlockEntity(BlockPos pos, BlockState state) {
        this((BlockEntityType)TFCBlockEntities.HOT_POURED_GLASS.get(), pos, state);
    }

    public HotPouredGlassBlockEntity(BlockEntityType<?> type, BlockPos pos, BlockState state) {
        super(type, pos, state);
    }

    @Override
    public void loadAdditional(CompoundTag nbt, HolderLookup.Provider provider) {
        super.loadAdditional(nbt, provider);
        this.capacity = nbt.getInt("capacity");
        this.isInitialTransition = nbt.getBoolean("isInitialTransition");
        this.animationTicks = nbt.getInt("animationTicks");
        this.initialized = nbt.getBoolean("initialized");
        this.internalState = NbtUtils.readBlockState((HolderGetter)provider.lookupOrThrow(Registries.BLOCK), (CompoundTag)nbt.getCompound("internalState"));
    }

    @Override
    public void saveAdditional(CompoundTag nbt, HolderLookup.Provider provider) {
        super.saveAdditional(nbt, provider);
        nbt.putInt("capacity", this.capacity);
        nbt.putBoolean("isInitialTransition", this.isInitialTransition);
        nbt.putInt("animationTicks", this.animationTicks);
        nbt.putBoolean("initialized", this.initialized);
        nbt.put("internalState", (Tag)NbtUtils.writeBlockState((BlockState)this.internalState));
    }

    public void setGlassItem(ItemStack stack) {
        Item item = stack.getItem();
        if (item instanceof BlockItem) {
            BlockItem bi = (BlockItem)item;
            this.internalState = bi.getBlock().defaultBlockState();
        }
    }

    public void flattenFirstBlock() {
        this.animationTicks = 20;
        this.initialized = true;
        this.capacity = 15;
        this.markForSync();
    }

    public boolean isInitialTransition() {
        return this.isInitialTransition;
    }

    public int getAnimationTicks() {
        return this.animationTicks;
    }

    public boolean isInitialized() {
        return this.initialized;
    }
}

